/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

/**
 */
public class ComboBoxEntry extends ComboBox {

	// for libglade object creation
	public ComboBoxEntry(int hndl) {
		setHandle(hndl);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a new ComboBoxEntry that will contain only Strings.
	 * If you need to include objects other than strings you must
	 * use the constructor that takes a TreeModel.  When you use
	 * this constructor you should use the appendText, insertText,
	 * prependText, and removeText methods to add or remove text
	 * from the comboBox.
	 */
	public ComboBoxEntry() {
		if (-1 == getHandle()) {
			setHandle(gtk_combo_box_entry_new_text());
			initializeEventHandlers();
		}
	}
	
	/**
	 * Create a new ComboBoxEntry with the provided model.  If you
	 * use this constructor you should not use the appendText,
	 * insertText, prependText, or removeText methods.  You should
	 * update the model when you need to change the values in the
	 * ComboBox. 
	 * @param model
	 * @param textColumn
	 */
	public ComboBoxEntry(TreeModel model, int textColumn) {
		setHandle(gtk_combo_box_entry_new_with_model(model.getHandle(), textColumn));
		initializeEventHandlers();
	}
	
	/**
	 * Set the model column which the ComboBoxEntry should use to
	 * get the strings.
	 * @param textColumn
	 */
	public void setTextColumn(int textColumn) {
		gtk_combo_box_entry_set_text_column(getHandle(), textColumn);
	}
	
	/**
	 * Returns the column from the model used by this widget.
	 * @return
	 */
	public int getTextColumn() {
		return gtk_combo_box_entry_get_text_column(getHandle());
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_combo_box_entry_get_type ();
	native static final protected int gtk_combo_box_entry_new();
	native static final protected int gtk_combo_box_entry_new_with_model(int model, int textColumn);
	native static final protected void gtk_combo_box_entry_set_text_column(int entry, int textColumn);
	native static final protected int gtk_combo_box_entry_get_text_column(int entry);
	native static final protected int gtk_combo_box_entry_new_text();
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
