/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;

/**
 */
public class RadioAction extends ToggleAction {
	
	public RadioAction() {
		if (-1 != handle)
			handle = allocate();
	}
	
	RadioAction(int handle) {
		super(handle);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		free(handle);
	}

	public List getGroup(){
		int[] group = gtk_radio_action_get_group(handle);
		List ret = new ArrayList();
		for (int i = 0; i < group.length; i++) {
			RadioAction action = new RadioAction(group[i]);
			ret.add(action);
		}
		return ret;
	}
	
	public void setGroup(List group) {
		if (null == group)
			return;
		int [] values = new int[group.size()];
		for (int i = 0; i < group.size(); i++) {
			values[i] = ((RadioAction)group.get(i)).getHandle();
		}
		gtk_radio_action_set_group(handle, values);
	}
	
	public int getCurrentValue() {
		return gtk_radio_action_get_current_value(handle);
	}
	

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_radio_action_get_type ();
	native static final protected int[] gtk_radio_action_get_group(int action);
	native static final protected void gtk_radio_action_set_group(int action, int[] group);
	native static final protected int gtk_radio_action_get_current_value(int action);
	native static protected int allocate();
	native static protected void free(int action);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
