/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ToggleAction
#define _Included_org_gnu_gtk_ToggleAction
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    gtk_toggle_action_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToggleAction_gtk_1toggle_1action_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_toggle_action_get_type();
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    gtk_toggle_action_toggled
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleAction_gtk_1toggle_1action_1toggled
  (JNIEnv *env, jclass cls, jint action)
{
	gtk_toggle_action_toggled((GtkToggleAction*)action);
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    gtk_toggle_action_set_active
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleAction_gtk_1toggle_1action_1set_1active
  (JNIEnv *env, jclass cls, jint action, jboolean active)
{
	gtk_toggle_action_set_active((GtkToggleAction*)action, (gboolean)active);
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    gtk_toggle_action_get_active
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToggleAction_gtk_1toggle_1action_1get_1active
  (JNIEnv *env, jclass cls, jint action)
{
	return (gboolean)gtk_toggle_action_get_active((GtkToggleAction*)action);
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    gtk_toggle_action_set_draw_as_radio
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleAction_gtk_1toggle_1action_1set_1draw_1as_1radio
  (JNIEnv *env, jclass cls, jint action, jboolean radio)
{
	gtk_toggle_action_set_draw_as_radio((GtkToggleAction*)action, (gboolean)radio);
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    gtk_toggle_action_get_draw_as_radio
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToggleAction_gtk_1toggle_1action_1get_1draw_1as_1radio
  (JNIEnv *env, jclass cls, jint action)
{
	return (gboolean)gtk_toggle_action_get_draw_as_radio((GtkToggleAction*)action);
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    allocate
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToggleAction_allocate
  (JNIEnv *env, jclass cls)
{
	return (jint)g_object_new(GTK_TYPE_TOGGLE_ACTION, NULL);
}

/*
 * Class:     org_gnu_gtk_ToggleAction
 * Method:    free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleAction_free
  (JNIEnv *env, jclass cls, jint action)
{
	g_object_unref((GtkToggleAction*)action);
}

#ifdef __cplusplus
}
#endif
#endif
