/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:32 EDT
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;

/**
 * The PangoLanguage structure is used to represent a language.
 */
public class Language extends Boxed 
{
	/**
	 * Take a RFC-3066 format language tag as a string and convert it to a
	 * PangoLanguage pointer.
	 * <p>This function first canonicalizes the string by converting it to
	 * lowercase, mapping '_' to '-', and stripping all characters other than
	 * letters and '-'.
	 *
	 */
	public Language(String lang){
		handle = pango_language_from_string(lang);
	}

	/**
	 * Constructs a new language object from handle to native resources. This
	 * should only be used internally by the java-gnome packages.
	 */
	public Language(int handle){
		this.handle = handle;
	}

	/**
	 * Returns a RFC-3066 format string representing the given language tag.
	 */
	public String toString(){
		return pango_language_to_string(handle);
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_language_get_type ();
    native static final protected int pango_language_from_string (String language);
    native static final protected String pango_language_to_string (int language);
    native static final protected boolean pango_language_matches (int language, String rangeList);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

