/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:39 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The HandleBox widget allows a portion of the window to be "torn-off".
 * It is a bin widget which displays its children and a handle that the
 * user can drag to tear off a separate window containing the child widget.
 * A thin <i>ghost</i> is drawn in the original location of the handlebox.
 * By dragging the separate window back to its original location it can
 * be reattached.
 */
public class HandleBox extends Bin 
{
	/**
	 * Create a new HandleBox object.
	 */
	public HandleBox() {
		noopInit();
	}
	
	/**
	 * Construct a HandleBox using a handle to a native resource.
	 */
	public HandleBox(int handle) {
	    super(handle);
	}

	protected void noopInit() {
		if (-1 == handle) {
			handle = gtk_handle_box_new();
			initializeEventHandlers();
		}
	}
	
	/**
	 * Set the shadow type to be drawn around the border of the
	 * handle box.
	 * @param type The ShadowType to use for the shadow.
	 */
	public void setShadowType(ShadowType type) {
		gtk_handle_box_set_shadow_type(handle, type.getValue());
	}
	
	/**
	 * Retrieves the shadow type used by this widget.
	 */
	public ShadowType getShadowType() {
		return ShadowType.intern(gtk_handle_box_get_shadow_type(handle));
	}
	
	/**
	 * Sets the side of the handle box where the handle is drawn.
	 * @param position Defines the position of the handle.
	 */
	public void setHandlePosition(PositionType position) {
		gtk_handle_box_set_handle_position(handle, position.getValue());
	}
	
	/**
	 * Retrieves the handle position.
	 */
	public PositionType getHandlePosition() {
		return PositionType.intern(gtk_handle_box_get_handle_position(handle));
	}
	
	/**
	 * Sets the snap edge of the handle box.  The snap edge is the edge
	 * of the detached child that must be aligned with the corresponding
	 * edge of the ghost left behind when the child was detached to 
	 * reattach the torn-off window.
	 * @param edge The side for the snap edge.
	 */
	public void setShapEdge(PositionType edge) {
		gtk_handle_box_set_snap_edge(handle, edge.getValue());
	}
	
	/**
	 * Retrieves the snap edge of the widget.
	 */
	public PositionType getShapEdge() {
		return PositionType.intern(gtk_handle_box_get_snap_edge(handle));
	}
	
	// TODO: Need to add the events CHILD_ATTACHED and CHILD_DETACHED
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_handle_box_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_handle_box_get_type ();
    native static final protected int gtk_handle_box_new ();
    native static final protected void gtk_handle_box_set_shadow_type (int handle_box, int type);
    native static final protected int gtk_handle_box_get_shadow_type (int handle_box);
    native static final protected void gtk_handle_box_set_handle_position (int handle_box, int 
        position);
    native static final protected int gtk_handle_box_get_handle_position (int handle_box);
    native static final protected void gtk_handle_box_set_snap_edge (int handle_box, int edge);
    native static final protected int gtk_handle_box_get_snap_edge (int handle_box);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

