/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:29 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The CheckMenuItem is a menu item that maintains the state of a boolean
 * value in addition to the MenuItem's usual role of activating applicaiton
 * code.
 * <p>
 * A check box indicating the state of boolean value is displayed on the
 * left side of the MenuItem.  Activating the MenuItem toggles this value.
 */
public class CheckMenuItem extends MenuItem {
	
	/**
	 * Create a new CheckMenuItem
	 */
	public CheckMenuItem() {
		noopInit();
	}
	
	/**
	 * Construct a CheckMenuItem using a handle to a native resource.
	 */
	public CheckMenuItem(int handle) {
	    super(handle);
	}

	protected void noopInit() {
		if (-1 == handle) {
			handle = CheckMenuItem.gtk_check_menu_item_new();
			initializeEventHandlers();
		}
	}
	
	/**
	 * Create a new CheckMenuItem with the given label.
	 * 
	 * @param label The label to display for this CheckMenuItem.
	 */
	public CheckMenuItem(String label, boolean hasMnemonic) {
		if (hasMnemonic) {
			handle = CheckMenuItem.gtk_check_menu_item_new_with_mnemonic(label);
		} else {
			handle = CheckMenuItem.gtk_check_menu_item_new_with_label(label);
		}
		initializeEventHandlers();
	}
	
	/**
	 * Sets the active state of the CheckMenuItem's check box.
	 * 
	 * @param isActive true if the check box is checked.
	 */
	public void setActive(boolean isActive) {
		CheckMenuItem.gtk_check_menu_item_set_active(handle, isActive);
	}
	
	/**
	 * Returns whether the CheckMenuItem is active.
	 * 
	 * @return true if the check box is active.
	 */
	public boolean getActive() {
		return CheckMenuItem.gtk_check_menu_item_get_active(handle);
	}
	
	/**
	 * This method will turn on a third state that indicates that the
	 * widget is in an inconsistent state.
	 * 
	 * @param isInconsistent true to display an "inconsistent" third state.
	 */
	public void setInconsistent(boolean isInconsistent) {
		gtk_check_menu_item_set_inconsistent(handle, isInconsistent);
	}
	
	/**
	 * Returns whether the CheckMenuItem is in the "inconsistent" state.
	 * 
	 * @return true if the check box is inconsistent.
	 */
	public boolean getInconsistent() {
		return gtk_check_menu_item_get_inconsistent(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_check_menu_item_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_check_menu_item_get_type();
	native static final protected int gtk_check_menu_item_new();
	native static final protected int gtk_check_menu_item_new_with_label(String label);
	native static final protected int gtk_check_menu_item_new_with_mnemonic(String label);
	native static final protected void gtk_check_menu_item_set_active(int check_menu_item, boolean isActive);
	native static final protected boolean gtk_check_menu_item_get_active(int check_menu_item);
	native static final protected void gtk_check_menu_item_toggled(int check_menu_item);
	native static final protected void gtk_check_menu_item_set_inconsistent(int check_menu_item, boolean setting);
	native static final protected boolean gtk_check_menu_item_get_inconsistent(int check_menu_item);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
