/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 * An interface for packing cells.
 * <p>
 * CellLayout is an interface to be implemented by all objects which want to
 * provide a TreeViewColumn-like API for packing cells, setting attributes and
 * data funcs.
 * 
 * @see ComboBox
 */
public interface CellLayout {

    /**
     * Get the native Handle of this CellLayout object.
     */
    public Handle getHandle();

    /**
     * Packs the cell into the beginning of the CellLayout. If expand is FALSE,
     * then the cell is allocated no more space than it needs. Any unused space
     * is divided evenly between cells for which expand is TRUE.
     */
    public void packStart(CellRenderer renderer, boolean expand);

    /**
     * Adds the cell to the end of the CellLayout. If expand is FALSE, then the
     * cell is allocated no more space than it needs. Any unused space is
     * divided evenly between cells for which expand is TRUE.
     */
    public void packEnd(CellRenderer renderer, boolean expand);

    /**
     * Unsets all the mappings on all renderers on the CellLayout and removes
     * all renderers from the CellLayout.
     */
    public void clear();

    /**
     * Adds an attribute mapping to the list in the CellLayout. The column is
     * the column of the model to get a value from, and the attribute is the
     * parameter on cell to be set from the value.
     */
    public void addAttributeMapping(CellRenderer renderer,
            CellRendererAttribute attribute, DataColumn column);

    /**
     * Clears all existing attributes previously set with
     * {@link #addAttributeMapping}.
     */
    public void clearAttributeMappings(CellRenderer renderer);

    /**
     * Re-inserts the renderer at position. Note that the renderer has already
     * to be packed into the CellLayout for this to function properly.
     */
    public void reorder(CellRenderer renderer, int position);

}
