/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:57 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    gchar * GnomeCanvasText_get_text (GnomeCanvasText * cptr) 
    {
        return cptr->text;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getText
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_CanvasText_getText (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gchar *result_g = (gchar*)GnomeCanvasText_get_text (cptr_g);
        return (*env)->NewStringUTF(env, result_g);
    }

    void GnomeCanvasText_set_text (GnomeCanvasText * cptr, gchar * text) 
    {
        cptr->text = text;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setText
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setText (JNIEnv *env, jint cptr, 
        jstring text) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        const gchar* text_g = (*env)->GetStringUTFChars(env, text, 0);
        GnomeCanvasText_set_text (cptr_g, text_g);
        (*env)->ReleaseStringUTFChars(env, text, text_g);
    }

    gdouble GnomeCanvasText_get_x (GnomeCanvasText * cptr) 
    {
        return cptr->x;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getX
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getX (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_x (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_x (GnomeCanvasText * cptr, gdouble x) 
    {
        cptr->x = x;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setX
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setX (JNIEnv *env, jint cptr, jdouble x) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gdouble x_g = (gdouble) x;
        {
            GnomeCanvasText_set_x (cptr_g, x_g);
        }
    }

    gdouble GnomeCanvasText_get_y (GnomeCanvasText * cptr) 
    {
        return cptr->y;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getY
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getY (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_y (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_y (GnomeCanvasText * cptr, gdouble y) 
    {
        cptr->y = y;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setY
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setY (JNIEnv *env, jint cptr, jdouble y) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gdouble y_g = (gdouble) y;
        {
            GnomeCanvasText_set_y (cptr_g, y_g);
        }
    }

    GtkAnchorType GnomeCanvasText_get_anchor (GnomeCanvasText * cptr) 
    {
        return cptr->anchor;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getAnchor
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getAnchor (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_anchor (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_anchor (GnomeCanvasText * cptr, GtkAnchorType anchor) 
    {
        cptr->anchor = anchor;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setAnchor
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setAnchor (JNIEnv *env, jint cptr, jint 
        anchor) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        GtkAnchorType anchor_g = (GtkAnchorType) anchor;
        {
            GnomeCanvasText_set_anchor (cptr_g, anchor_g);
        }
    }

    GtkJustification GnomeCanvasText_get_justification (GnomeCanvasText * cptr) 
    {
        return cptr->justification;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getJustification
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getJustification (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_justification (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_justification (GnomeCanvasText * cptr, GtkJustification justification) 
    {
        cptr->justification = justification;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setJustification
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setJustification (JNIEnv *env, jint cptr, 
        jint justification) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        GtkJustification justification_g = (GtkJustification) justification;
        {
            GnomeCanvasText_set_justification (cptr_g, justification_g);
        }
    }

    gdouble GnomeCanvasText_get_clip_width (GnomeCanvasText * cptr) 
    {
        return cptr->clip_width;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getClipWidth
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getClipWidth (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_clip_width (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_clip_width (GnomeCanvasText * cptr, gdouble clip_width) 
    {
        cptr->clip_width = clip_width;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setClipWidth
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setClipWidth (JNIEnv *env, jint cptr, 
        jdouble clip_width) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gdouble clip_width_g = (gdouble) clip_width;
        {
            GnomeCanvasText_set_clip_width (cptr_g, clip_width_g);
        }
    }

    gdouble GnomeCanvasText_get_clip_height (GnomeCanvasText * cptr) 
    {
        return cptr->clip_height;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getClipHeight
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getClipHeight (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_clip_height (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_clip_height (GnomeCanvasText * cptr, gdouble clip_height) 
    {
        cptr->clip_height = clip_height;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setClipHeight
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setClipHeight (JNIEnv *env, jint cptr, 
        jdouble clip_height) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gdouble clip_height_g = (gdouble) clip_height;
        {
            GnomeCanvasText_set_clip_height (cptr_g, clip_height_g);
        }
    }

    glong GnomeCanvasText_get_pixel (GnomeCanvasText * cptr) 
    {
        return cptr->pixel;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getPixel
     * Signature: (I)J
     */
    JNIEXPORT jlong JNICALL Java_org_gnu_gnome_CanvasText_getPixel (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jlong result_j = (jlong) (GnomeCanvasText_get_pixel (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_pixel (GnomeCanvasText * cptr, glong pixel) 
    {
        cptr->pixel = pixel;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setPixel
     * Signature: (IJ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setPixel (JNIEnv *env, jint cptr, jlong 
        pixel) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        glong pixel_g = (glong) pixel;
        {
            GnomeCanvasText_set_pixel (cptr_g, pixel_g);
        }
    }

    GdkBitmap * GnomeCanvasText_get_stipple (GnomeCanvasText * cptr) 
    {
        return cptr->stipple;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getStipple
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getStipple (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            return (jint)GnomeCanvasText_get_stipple (cptr_g);
        }
    }

    void GnomeCanvasText_set_stipple (GnomeCanvasText * cptr, GdkBitmap * stipple) 
    {
        cptr->stipple = stipple;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setStipple
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setStipple (JNIEnv *env, jint cptr, jint 
        stipple) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        GdkBitmap *stipple_g = (GdkBitmap *)stipple;
        {
            GnomeCanvasText_set_stipple (cptr_g, stipple_g);
        }
    }

    GdkGC * GnomeCanvasText_get_gc (GnomeCanvasText * cptr) 
    {
        return cptr->gc;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getGc
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getGc (JNIEnv *env, jclass cls, jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            return (jint)GnomeCanvasText_get_gc (cptr_g);
        }
    }

    gint32 GnomeCanvasText_get_max_width (GnomeCanvasText * cptr) 
    {
        return cptr->max_width;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getMaxWidth
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getMaxWidth (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_max_width (cptr_g));
            return result_j;
        }
    }

    gint32 GnomeCanvasText_get_height (GnomeCanvasText * cptr) 
    {
        return cptr->height;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getHeight
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getHeight (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_height (cptr_g));
            return result_j;
        }
    }

    gboolean GnomeCanvasText_get_clip (GnomeCanvasText * cptr) 
    {
        return cptr->clip;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getClip
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_CanvasText_getClip (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jboolean result_j = (jboolean) (GnomeCanvasText_get_clip (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_clip (GnomeCanvasText * cptr, gboolean clip) 
    {
        cptr->clip = clip;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setClip
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setClip (JNIEnv *env, jint cptr, jboolean 
        clip) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gboolean clip_g = (gboolean) clip;
        {
            GnomeCanvasText_set_clip (cptr_g, clip_g);
        }
    }

    PangoFontDescription * GnomeCanvasText_get_font_desc (GnomeCanvasText * cptr) 
    {
        return cptr->font_desc;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getFontDesc
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getFontDesc (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            return (jint)GnomeCanvasText_get_font_desc (cptr_g);
        }
    }

    void GnomeCanvasText_set_font_desc (GnomeCanvasText * cptr, PangoFontDescription * font_desc) 
    {
        cptr->font_desc = font_desc;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setFontDesc
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setFontDesc (JNIEnv *env, jint cptr, jint 
        font_desc) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        PangoFontDescription *font_desc_g = (PangoFontDescription *)font_desc;
        {
            GnomeCanvasText_set_font_desc (cptr_g, font_desc_g);
        }
    }

    PangoAttrList * GnomeCanvasText_get_attr_list (GnomeCanvasText * cptr) 
    {
        return cptr->attr_list;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getAttrList
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getAttrList (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            return (jint)GnomeCanvasText_get_attr_list (cptr_g);
        }
    }

    void GnomeCanvasText_set_attr_list (GnomeCanvasText * cptr, PangoAttrList * attr_list) 
    {
        cptr->attr_list = attr_list;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setAttrList
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setAttrList (JNIEnv *env, jint cptr, jint 
        attr_list) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        PangoAttrList *attr_list_g = (PangoAttrList *)attr_list;
        {
            GnomeCanvasText_set_attr_list (cptr_g, attr_list_g);
        }
    }

    PangoUnderline GnomeCanvasText_get_underline (GnomeCanvasText * cptr) 
    {
        return cptr->underline;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getUnderline
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getUnderline (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_underline (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_underline (GnomeCanvasText * cptr, PangoUnderline underline) 
    {
        cptr->underline = underline;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setUnderline
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setUnderline (JNIEnv *env, jint cptr, jint 
        underline) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        PangoUnderline underline_g = (PangoUnderline) underline;
        {
            GnomeCanvasText_set_underline (cptr_g, underline_g);
        }
    }

    gboolean GnomeCanvasText_get_strikethrough (GnomeCanvasText * cptr) 
    {
        return cptr->strikethrough;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getStrikethrough
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_CanvasText_getStrikethrough (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jboolean result_j = (jboolean) (GnomeCanvasText_get_strikethrough (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_strikethrough (GnomeCanvasText * cptr, gboolean strikethrough) 
    {
        cptr->strikethrough = strikethrough;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setStrikethrough
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setStrikethrough (JNIEnv *env, jint cptr, 
        jboolean strikethrough) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gboolean strikethrough_g = (gboolean) strikethrough;
        {
            GnomeCanvasText_set_strikethrough (cptr_g, strikethrough_g);
        }
    }

    gint32 GnomeCanvasText_get_rise (GnomeCanvasText * cptr) 
    {
        return cptr->rise;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getRise
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getRise (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_rise (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_rise (GnomeCanvasText * cptr, gint32 rise) 
    {
        cptr->rise = rise;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setRise
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setRise (JNIEnv *env, jint cptr, jint rise)
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gint32 rise_g = (gint32) rise;
        {
            GnomeCanvasText_set_rise (cptr_g, rise_g);
        }
    }

    gdouble GnomeCanvasText_get_scale (GnomeCanvasText * cptr) 
    {
        return cptr->scale;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getScale
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getScale (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_scale (cptr_g));
            return result_j;
        }
    }

    void GnomeCanvasText_set_scale (GnomeCanvasText * cptr, gdouble scale) 
    {
        cptr->scale = scale;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setScale
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setScale (JNIEnv *env, jint cptr, jdouble 
        scale) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        gdouble scale_g = (gdouble) scale;
        {
            GnomeCanvasText_set_scale (cptr_g, scale_g);
        }
    }

    PangoLayout * GnomeCanvasText_get_layout (GnomeCanvasText * cptr) 
    {
        return cptr->layout;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getLayout
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getLayout (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            return (jint)GnomeCanvasText_get_layout (cptr_g);
        }
    }

    void GnomeCanvasText_set_layout (GnomeCanvasText * cptr, PangoLayout * layout) 
    {
        cptr->layout = layout;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    setLayout
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasText_setLayout (JNIEnv *env, jint cptr, jint 
        layout) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            GnomeCanvasText_set_layout (cptr_g, layout_g);
        }
    }

    gdouble GnomeCanvasText_get_xofs (GnomeCanvasText * cptr) 
    {
        return cptr->xofs;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getXofs
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getXofs (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_xofs (cptr_g));
            return result_j;
        }
    }

    gdouble GnomeCanvasText_get_yofs (GnomeCanvasText * cptr) 
    {
        return cptr->yofs;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getYofs
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_CanvasText_getYofs (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jdouble result_j = (jdouble) (GnomeCanvasText_get_yofs (cptr_g));
            return result_j;
        }
    }

    gint32 GnomeCanvasText_get_cx (GnomeCanvasText * cptr) 
    {
        return cptr->cx;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getCx
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getCx (JNIEnv *env, jclass cls, jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_cx (cptr_g));
            return result_j;
        }
    }

    gint32 GnomeCanvasText_get_cy (GnomeCanvasText * cptr) 
    {
        return cptr->cy;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getCy
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getCy (JNIEnv *env, jclass cls, jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_cy (cptr_g));
            return result_j;
        }
    }

    gboolean GnomeCanvasText_get_underline_set (GnomeCanvasText * cptr) 
    {
        return cptr->underline_set;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getUnderlineSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_CanvasText_getUnderlineSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jboolean result_j = (jboolean) (GnomeCanvasText_get_underline_set (cptr_g));
            return result_j;
        }
    }

    gboolean GnomeCanvasText_get_strike_set (GnomeCanvasText * cptr) 
    {
        return cptr->strike_set;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getStrikeSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_CanvasText_getStrikeSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jboolean result_j = (jboolean) (GnomeCanvasText_get_strike_set (cptr_g));
            return result_j;
        }
    }

    gboolean GnomeCanvasText_get_rise_set (GnomeCanvasText * cptr) 
    {
        return cptr->rise_set;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getRiseSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_CanvasText_getRiseSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jboolean result_j = (jboolean) (GnomeCanvasText_get_rise_set (cptr_g));
            return result_j;
        }
    }

    gboolean GnomeCanvasText_get_scale_set (GnomeCanvasText * cptr) 
    {
        return cptr->scale_set;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getScaleSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_CanvasText_getScaleSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jboolean result_j = (jboolean) (GnomeCanvasText_get_scale_set (cptr_g));
            return result_j;
        }
    }

    gint32 GnomeCanvasText_get_clip_cx (GnomeCanvasText * cptr) 
    {
        return cptr->clip_cx;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getClipCx
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getClipCx (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_clip_cx (cptr_g));
            return result_j;
        }
    }

    gint32 GnomeCanvasText_get_clip_cy (GnomeCanvasText * cptr) 
    {
        return cptr->clip_cy;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getClipCy
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getClipCy (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_clip_cy (cptr_g));
            return result_j;
        }
    }

    gint32 GnomeCanvasText_get_clip_cheight (GnomeCanvasText * cptr) 
    {
        return cptr->clip_cheight;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getClipCheight
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_getClipCheight (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jint result_j = (jint) (GnomeCanvasText_get_clip_cheight (cptr_g));
            return result_j;
        }
    }

    glong GnomeCanvasText_get_rgba (GnomeCanvasText * cptr) 
    {
        return cptr->rgba;
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    getRgba
     * Signature: (I)J
     */
    JNIEXPORT jlong JNICALL Java_org_gnu_gnome_CanvasText_getRgba (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeCanvasText *cptr_g = (GnomeCanvasText *)cptr;
        {
            jlong result_j = (jlong) (GnomeCanvasText_get_rgba (cptr_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gnome.CanvasText
     * Method:    gnome_canvas_text_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasText_gnome_1canvas_1text_1get_1type (JNIEnv 
        *env, jclass cls) 
    {
        {
            return (jint)gnome_canvas_text_get_type ();
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
