/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *   Philip A. Chapman <pchapman@pcsw.us>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:27:52 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Boxed;
public class CanvasPoints extends Boxed {
	/**
	 * Constructs a new CanvasPoints object with memory reserved for the given
	 * number of points.
	 * @param numPoints The number of points to be represented by the object.
	 */
	public CanvasPoints(int numPoints) {
		handle = gnome_canvas_points_new(numPoints);
	}

	// I could have created a Point class, and taken an array of Point objects,
	// but that seemed a little heavy-weight for this simple constructor.
	// Especially considering that the Point class would have to be immutable.
	// PAC.
	/**
	 * Constructs a new CanvasPoints object with the given points.  Point n
	 * would be (xCoordinates[n], yCoordinates[n]).
	 * @param xCoordinates an array containing the x coordinates of the points.
	 * @param yCoordinates an array containing the y coordinates of the points.
	 * @exception IllegalArgumentException Indicates that the number of
	 *                                     elements in the arrays are not the
	 *                                     same.
	 */
	public CanvasPoints(double xCoordinates[], double yCoordinates[]) throws IllegalArgumentException {
		if (xCoordinates.length != yCoordinates.length) {
			throw new IllegalArgumentException("The number of X coordinates and Y coordinates must be the same.");
		} else {
			handle = gnome_canvas_points_new(xCoordinates.length);
			for (int i = 0; i < xCoordinates.length; i++) {
				gnome_canvas_points_set_point(handle, i, xCoordinates[i], yCoordinates[i]);
			}
		}
	}

	protected void finalize() {
		gnome_canvas_points_free(handle);
	}

	/**
	 * Sets the value of the point at the given index.
	 * @param index The index of the point.  This value is 0 to
	 *              {@link #CanvasPoints(int) numPoints} - 1.
	 */
	public void setPoint(int index, double x, double y) {
		gnome_canvas_points_set_point(handle, index, x, y);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_canvas_points_new(int numPoints);
	native static final protected int gnome_canvas_points_ref(int points);
	native static final protected void gnome_canvas_points_free(int points);
	native static final protected void gnome_canvas_points_set_point(int points, int index, double x, double y);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
