/* preferences_dialog.c generated by valac 0.39.1.3-7091, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gspell/gspell.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksource.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];

#define PREFERENCES_DIALOG_TYPE_STYLE_SCHEMES (preferences_dialog_style_schemes_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block25Data Block25Data;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
#define _g_settings_schema_key_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_key_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

typedef enum  {
	PREFERENCES_DIALOG_STYLE_SCHEMES_ID,
	PREFERENCES_DIALOG_STYLE_SCHEMES_DESC,
	PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS
} PreferencesDialogStyleSchemes;

typedef const gchar* (*PreferencesDialogPlural) (gulong n, void* user_data);
struct _Block25Data {
	int _ref_count_;
	PreferencesDialog* self;
	GSettings* settings;
	GtkButton* default_font_checkbutton;
	GtkTreeView* schemes_treeview;
	GtkTreeSelection* schemes_select;
};

struct _Block26Data {
	int _ref_count_;
	PreferencesDialog* self;
	GtkWidget* widget;
	gboolean must_be_enabled;
};

struct _Block27Data {
	int _ref_count_;
	PreferencesDialog* self;
	GtkLabel* label;
	PreferencesDialogPlural plural;
	gpointer plural_target;
};


static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog__instance;
static PreferencesDialog* preferences_dialog__instance = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
static GType preferences_dialog_style_schemes_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void __lambda88_ (PreferencesDialog* self);
static void preferences_dialog_reset_all (PreferencesDialog* self);
static void ___lambda88__gtk_button_clicked (GtkButton* _sender, 
                                      gpointer self);
static void preferences_dialog_init_editor_tab (PreferencesDialog* self, 
                                         GtkBuilder* builder);
static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self, 
                                                  GtkBuilder* builder);
static void preferences_dialog_init_interactive_completion_setting (PreferencesDialog* self, 
                                                             GtkBuilder* builder);
static void preferences_dialog_init_spell_checking_settings (PreferencesDialog* self, 
                                                      GtkBuilder* builder);
static void preferences_dialog_init_other_tab (PreferencesDialog* self, 
                                        GtkBuilder* builder);
void preferences_dialog_show_me (GtkWindow* parent);
static gboolean ___lambda96_ (void);
static gboolean ____lambda96__gtk_widget_delete_event (GtkWidget* _sender, 
                                                GdkEventAny* event, 
                                                gpointer self);
static void ___lambda97_ (void);
static void ____lambda97__gtk_widget_destroy (GtkWidget* _sender, 
                                       gpointer self);
static void preferences_dialog_set_spin_button_range (PreferencesDialog* self, 
                                               GtkSpinButton* spin_button, 
                                               GSettings* settings, 
                                               const gchar* key);
static void preferences_dialog_set_sensitivity (PreferencesDialog* self, 
                                         GSettings* settings, 
                                         const gchar* key, 
                                         GtkWidget* widget, 
                                         gboolean must_be_enabled);
static void preferences_dialog_set_plural (PreferencesDialog* self, 
                                    GtkLabel* label, 
                                    GSettings* settings, 
                                    const gchar* key, 
                                    PreferencesDialogPlural plural, 
                                    void* plural_target);
static const gchar* __lambda91_ (PreferencesDialog* self, 
                          gulong n);
static const gchar* ___lambda91__preferences_dialog_plural (gulong n, 
                                                     gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self, 
                                               GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void __lambda92_ (Block25Data* _data25_);
static void ___lambda92__g_object_notify (GObject* _sender, 
                                   GParamSpec* pspec, 
                                   gpointer self);
static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, 
                                               GtkTreeView* treeview, 
                                               const gchar* current_id);
static void __lambda93_ (Block25Data* _data25_);
static void _gtk_tree_path_free0_ (gpointer var);
static inline void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void ___lambda93__gtk_tree_selection_changed (GtkTreeSelection* _sender, 
                                              gpointer self);
static void __lambda94_ (Block25Data* _data25_, 
                  GSettings* setting, 
                  const gchar* key);
static void ___lambda94__g_settings_changed (GSettings* _sender, 
                                      const gchar* key, 
                                      gpointer self);
static const gchar* __lambda95_ (PreferencesDialog* self, 
                          gulong n);
static const gchar* ___lambda95__preferences_dialog_plural (gulong n, 
                                                     gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void __lambda89_ (Block26Data* _data26_, 
                  GSettings* setting, 
                  const gchar* k);
static void ___lambda89__g_settings_changed (GSettings* _sender, 
                                      const gchar* key, 
                                      gpointer self);
const gchar* app_settings_get_system_font (AppSettings* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void __lambda90_ (Block27Data* _data27_, 
                  GSettings* setting, 
                  const gchar* k);
static void ___lambda90__g_settings_changed (GSettings* _sender, 
                                      const gchar* key, 
                                      gpointer self);
static void preferences_dialog_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType
preferences_dialog_style_schemes_get_type (void)
{
	static volatile gsize preferences_dialog_style_schemes_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_style_schemes_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_STYLE_SCHEMES_ID, "PREFERENCES_DIALOG_STYLE_SCHEMES_ID", "id"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, "PREFERENCES_DIALOG_STYLE_SCHEMES_DESC", "desc"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, "PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_style_schemes_type_id;
		preferences_dialog_style_schemes_type_id = g_enum_register_static ("PreferencesDialogStyleSchemes", values);
		g_once_init_leave (&preferences_dialog_style_schemes_type_id__volatile, preferences_dialog_style_schemes_type_id);
	}
	return preferences_dialog_style_schemes_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda88_ (PreferencesDialog* self)
{
	preferences_dialog_reset_all (self);
}


static void
___lambda88__gtk_button_clicked (GtkButton* _sender, 
                                 gpointer self)
{
	__lambda88_ ((PreferencesDialog*) self);
}


static PreferencesDialog*
preferences_dialog_construct (GType object_type)
{
	PreferencesDialog * self = NULL;
	GtkHeaderBar* headerbar = NULL;
	GtkWidget* _tmp0_;
	GtkHeaderBar* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkButton* reset_button = NULL;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkHeaderBar* _tmp7_;
	GtkButton* _tmp8_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp9_;
	GtkBuilder* _tmp25_;
	GtkBuilder* _tmp26_;
	GtkBuilder* _tmp27_;
	GtkBuilder* _tmp28_;
	GtkBuilder* _tmp29_;
	GtkNotebook* notebook = NULL;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkNotebook* _tmp32_;
	GtkNotebook* _tmp33_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkNotebook* _tmp37_;
	GError * _inner_error_ = NULL;
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	gtk_window_set_title ((GtkWindow*) self, _ ("Preferences"));
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	_tmp0_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp0_) : NULL);
	headerbar = _tmp1_;
	_tmp2_ = headerbar;
	gtk_header_bar_set_show_close_button (_tmp2_, TRUE);
	_tmp3_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Reset All"));
	g_object_ref_sink (_tmp3_);
	reset_button = _tmp3_;
	_tmp4_ = reset_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Reset all preferences"));
	_tmp5_ = reset_button;
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
	_tmp6_ = reset_button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) ___lambda88__gtk_button_clicked, self, 0);
	_tmp7_ = headerbar;
	_tmp8_ = reset_button;
	gtk_header_bar_pack_start (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = gtk_builder_new ();
	builder = _tmp9_;
	{
		gchar* ui_path = NULL;
		gchar* _tmp10_;
		GtkBuilder* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
		ui_path = _tmp10_;
		_tmp11_ = builder;
		_tmp12_ = ui_path;
		gtk_builder_add_from_file (_tmp11_, _tmp12_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (ui_path);
			goto __catch37_g_error;
		}
		_g_free0 (ui_path);
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		GtkLabel* label_error = NULL;
		const gchar* _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		GtkBox* content_area = NULL;
		GtkBox* _tmp20_;
		GtkBox* _tmp21_;
		GtkBox* _tmp22_;
		GtkLabel* _tmp23_;
		GtkBox* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strdup_printf ("Error: %s", _tmp14_);
		message = _tmp15_;
		_tmp16_ = message;
		g_warning ("preferences_dialog.vala:61: %s", _tmp16_);
		_tmp17_ = message;
		_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
		g_object_ref_sink (_tmp18_);
		label_error = _tmp18_;
		_tmp19_ = label_error;
		gtk_label_set_line_wrap (_tmp19_, TRUE);
		_tmp20_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_box_get_type (), GtkBox));
		content_area = _tmp21_;
		_tmp22_ = content_area;
		_tmp23_ = label_error;
		gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, TRUE, TRUE, (guint) 0);
		_tmp24_ = content_area;
		gtk_widget_show_all ((GtkWidget*) _tmp24_);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		_g_object_unref0 (reset_button);
		_g_object_unref0 (headerbar);
		return self;
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		_g_object_unref0 (reset_button);
		_g_object_unref0 (headerbar);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp25_ = builder;
	preferences_dialog_init_editor_tab (self, _tmp25_);
	_tmp26_ = builder;
	preferences_dialog_init_font_and_colors_tab (self, _tmp26_);
	_tmp27_ = builder;
	preferences_dialog_init_interactive_completion_setting (self, _tmp27_);
	_tmp28_ = builder;
	preferences_dialog_init_spell_checking_settings (self, _tmp28_);
	_tmp29_ = builder;
	preferences_dialog_init_other_tab (self, _tmp29_);
	_tmp30_ = builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "notebook");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp31_) : NULL);
	notebook = _tmp32_;
	_tmp33_ = notebook;
	gtk_widget_unparent ((GtkWidget*) _tmp33_);
	_tmp34_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_box_get_type (), GtkBox));
	content_area = _tmp35_;
	_tmp36_ = content_area;
	_tmp37_ = notebook;
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (content_area);
	_g_object_unref0 (notebook);
	_g_object_unref0 (builder);
	_g_object_unref0 (reset_button);
	_g_object_unref0 (headerbar);
	return self;
}


static PreferencesDialog*
preferences_dialog_new (void)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}


static gboolean
___lambda96_ (void)
{
	gboolean result = FALSE;
	PreferencesDialog* _tmp0_;
	_tmp0_ = preferences_dialog__instance;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean
____lambda96__gtk_widget_delete_event (GtkWidget* _sender, 
                                       GdkEventAny* event, 
                                       gpointer self)
{
	gboolean result;
	result = ___lambda96_ ();
	return result;
}


static void
___lambda97_ (void)
{
	_g_object_unref0 (preferences_dialog__instance);
	preferences_dialog__instance = NULL;
}


static void
____lambda97__gtk_widget_destroy (GtkWidget* _sender, 
                                  gpointer self)
{
	___lambda97_ ();
}


void
preferences_dialog_show_me (GtkWindow* parent)
{
	PreferencesDialog* _tmp0_;
	PreferencesDialog* _tmp4_;
	GtkWindow* _tmp5_;
	PreferencesDialog* _tmp7_;
	g_return_if_fail (parent != NULL);
	_tmp0_ = preferences_dialog__instance;
	if (_tmp0_ == NULL) {
		PreferencesDialog* _tmp1_;
		PreferencesDialog* _tmp2_;
		PreferencesDialog* _tmp3_;
		_tmp1_ = preferences_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (preferences_dialog__instance);
		preferences_dialog__instance = _tmp1_;
		_tmp2_ = preferences_dialog__instance;
		g_signal_connect ((GtkWidget*) _tmp2_, "delete-event", (GCallback) ____lambda96__gtk_widget_delete_event, NULL);
		_tmp3_ = preferences_dialog__instance;
		g_signal_connect ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda97__gtk_widget_destroy, NULL);
	}
	_tmp4_ = preferences_dialog__instance;
	_tmp5_ = gtk_window_get_transient_for ((GtkWindow*) _tmp4_);
	if (parent != _tmp5_) {
		PreferencesDialog* _tmp6_;
		_tmp6_ = preferences_dialog__instance;
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, parent);
	}
	_tmp7_ = preferences_dialog__instance;
	gtk_window_present ((GtkWindow*) _tmp7_);
}


static void
preferences_dialog_reset_all (PreferencesDialog* self)
{
	GtkDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	gint resp = 0;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	gint _tmp5_;
	gchar** settings_str = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint settings_str_length1;
	gint _settings_str_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to reset all preferences?"));
	g_object_ref_sink (_tmp0_);
	dialog = (GtkDialog*) _tmp0_;
	_tmp1_ = dialog;
	gtk_dialog_add_button (_tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = dialog;
	gtk_dialog_add_button (_tmp2_, _ ("_Reset All"), (gint) GTK_RESPONSE_YES);
	_tmp3_ = dialog;
	resp = gtk_dialog_run (_tmp3_);
	_tmp4_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = resp;
	if (_tmp5_ != ((gint) GTK_RESPONSE_YES)) {
		_g_object_unref0 (dialog);
		return;
	}
	_tmp6_ = g_strdup ("org.gnome.latexila.preferences.editor");
	_tmp7_ = g_strdup ("org.gnome.latexila.preferences.latex");
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	settings_str = _tmp8_;
	settings_str_length1 = 2;
	_settings_str_size_ = settings_str_length1;
	_tmp9_ = settings_str;
	_tmp9__length1 = settings_str_length1;
	{
		gchar** setting_str_collection = NULL;
		gint setting_str_collection_length1 = 0;
		gint _setting_str_collection_size_ = 0;
		gint setting_str_it = 0;
		setting_str_collection = _tmp9_;
		setting_str_collection_length1 = _tmp9__length1;
		for (setting_str_it = 0; setting_str_it < _tmp9__length1; setting_str_it = setting_str_it + 1) {
			gchar* _tmp10_;
			gchar* setting_str = NULL;
			_tmp10_ = g_strdup (setting_str_collection[setting_str_it]);
			setting_str = _tmp10_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp11_;
				GSettings* _tmp12_;
				gchar** keys = NULL;
				GSettings* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint keys_length1;
				gint _keys_size_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				_tmp11_ = setting_str;
				_tmp12_ = g_settings_new (_tmp11_);
				settings = _tmp12_;
				_tmp13_ = settings;
				_tmp15_ = _tmp14_ = g_settings_list_keys (_tmp13_);
				keys = _tmp15_;
				keys_length1 = _vala_array_length (_tmp14_);
				_keys_size_ = keys_length1;
				_tmp16_ = keys;
				_tmp16__length1 = keys_length1;
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp16_;
					key_collection_length1 = _tmp16__length1;
					for (key_it = 0; key_it < _tmp16__length1; key_it = key_it + 1) {
						gchar* _tmp17_;
						gchar* key = NULL;
						_tmp17_ = g_strdup (key_collection[key_it]);
						key = _tmp17_;
						{
							GSettings* _tmp18_;
							const gchar* _tmp19_;
							_tmp18_ = settings;
							_tmp19_ = key;
							g_settings_reset (_tmp18_, _tmp19_);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
}


static const gchar*
__lambda91_ (PreferencesDialog* self, 
             gulong n)
{
	const gchar* result = NULL;
	result = ngettext ("minute", "minutes", n);
	return result;
}


static const gchar*
___lambda91__preferences_dialog_plural (gulong n, 
                                        gpointer self)
{
	const gchar* result;
	result = __lambda91_ ((PreferencesDialog*) self, n);
	return result;
}


static void
preferences_dialog_init_editor_tab (PreferencesDialog* self, 
                                    GtkBuilder* builder)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GObject* display_line_nb_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkSpinButton* tab_width_spinbutton = NULL;
	GObject* _tmp3_;
	GtkSpinButton* _tmp4_;
	GObject* insert_spaces_checkbutton = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GtkWidget* forget_no_tabs = NULL;
	GObject* _tmp7_;
	GtkWidget* _tmp8_;
	GObject* hl_current_line_checkbutton = NULL;
	GObject* _tmp9_;
	GObject* _tmp10_;
	GObject* bracket_matching_checkbutton = NULL;
	GObject* _tmp11_;
	GObject* _tmp12_;
	GObject* backup_checkbutton = NULL;
	GObject* _tmp13_;
	GObject* _tmp14_;
	GObject* autosave_checkbutton = NULL;
	GObject* _tmp15_;
	GObject* _tmp16_;
	GtkSpinButton* autosave_spinbutton = NULL;
	GObject* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkLabel* autosave_label = NULL;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GObject* reopen_checkbutton = NULL;
	GObject* _tmp21_;
	GObject* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "display_line_nb_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display_line_nb_checkbutton = _tmp2_;
	g_settings_bind (settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "tab_width_spinbutton");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp3_) : NULL);
	tab_width_spinbutton = _tmp4_;
	preferences_dialog_set_spin_button_range (self, tab_width_spinbutton, settings, "tabs-size");
	g_settings_bind (settings, "tabs-size", (GObject*) tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = gtk_builder_get_object (builder, "insert_spaces_checkbutton");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	insert_spaces_checkbutton = _tmp6_;
	g_settings_bind (settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = gtk_builder_get_object (builder, "forget_no_tabs");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp7_) : NULL);
	forget_no_tabs = _tmp8_;
	g_settings_bind (settings, "forget-no-tabs", (GObject*) forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "insert-spaces", forget_no_tabs, TRUE);
	_tmp9_ = gtk_builder_get_object (builder, "hl_current_line_checkbutton");
	_tmp10_ = _g_object_ref0 (_tmp9_);
	hl_current_line_checkbutton = _tmp10_;
	g_settings_bind (settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = gtk_builder_get_object (builder, "bracket_matching_checkbutton");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	bracket_matching_checkbutton = _tmp12_;
	g_settings_bind (settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = gtk_builder_get_object (builder, "backup_checkbutton");
	_tmp14_ = _g_object_ref0 (_tmp13_);
	backup_checkbutton = _tmp14_;
	g_settings_bind (settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = gtk_builder_get_object (builder, "autosave_checkbutton");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	autosave_checkbutton = _tmp16_;
	g_settings_bind (settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = gtk_builder_get_object (builder, "autosave_spinbutton");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp17_) : NULL);
	autosave_spinbutton = _tmp18_;
	preferences_dialog_set_spin_button_range (self, autosave_spinbutton, settings, "auto-save-interval");
	g_settings_bind (settings, "auto-save-interval", (GObject*) autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "auto-save", (GtkWidget*) autosave_spinbutton, TRUE);
	_tmp19_ = gtk_builder_get_object (builder, "autosave_label");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp19_) : NULL);
	autosave_label = _tmp20_;
	preferences_dialog_set_plural (self, autosave_label, settings, "auto-save-interval", ___lambda91__preferences_dialog_plural, self);
	_tmp21_ = gtk_builder_get_object (builder, "reopen_checkbutton");
	_tmp22_ = _g_object_ref0 (_tmp21_);
	reopen_checkbutton = _tmp22_;
	g_settings_bind (settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (reopen_checkbutton);
	_g_object_unref0 (autosave_label);
	_g_object_unref0 (autosave_spinbutton);
	_g_object_unref0 (autosave_checkbutton);
	_g_object_unref0 (backup_checkbutton);
	_g_object_unref0 (bracket_matching_checkbutton);
	_g_object_unref0 (hl_current_line_checkbutton);
	_g_object_unref0 (forget_no_tabs);
	_g_object_unref0 (insert_spaces_checkbutton);
	_g_object_unref0 (tab_width_spinbutton);
	_g_object_unref0 (display_line_nb_checkbutton);
	_g_object_unref0 (settings);
}


static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->schemes_select);
		_g_object_unref0 (_data25_->schemes_treeview);
		_g_object_unref0 (_data25_->default_font_checkbutton);
		_g_object_unref0 (_data25_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}


static void
__lambda92_ (Block25Data* _data25_)
{
	PreferencesDialog* self;
	self = _data25_->self;
	preferences_dialog_set_system_font_label (self, _data25_->default_font_checkbutton);
}


static void
___lambda92__g_object_notify (GObject* _sender, 
                              GParamSpec* pspec, 
                              gpointer self)
{
	__lambda92_ (self);
}


static void
_gtk_tree_path_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static inline void
_g_list_free__gtk_tree_path_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gtk_tree_path_free0_);
}


static gpointer
_gtk_tree_path_copy0 (gpointer self)
{
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void
__lambda93_ (Block25Data* _data25_)
{
	PreferencesDialog* self;
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkTreePath* path = NULL;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gchar* id = NULL;
	GtkTreeModel* _tmp9_;
	GtkTreeIter _tmp10_;
	const gchar* _tmp11_;
	self = _data25_->self;
	_tmp1_ = gtk_tree_selection_get_selected_rows (_data25_->schemes_select, &_tmp0_);
	model = _tmp0_;
	rows = _tmp1_;
	_tmp2_ = rows;
	if (g_list_length (_tmp2_) != ((guint) 1)) {
		__g_list_free__gtk_tree_path_free0_0 (rows);
		return;
	}
	_tmp3_ = rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path = _tmp5_;
	_tmp6_ = model;
	_tmp7_ = path;
	gtk_tree_model_get_iter (_tmp6_, &_tmp8_, _tmp7_);
	iter = _tmp8_;
	_tmp9_ = model;
	_tmp10_ = iter;
	gtk_tree_model_get (_tmp9_, &_tmp10_, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &id, -1);
	_tmp11_ = id;
	g_settings_set_string (_data25_->settings, "scheme", _tmp11_);
	_g_free0 (id);
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (rows);
}


static void
___lambda93__gtk_tree_selection_changed (GtkTreeSelection* _sender, 
                                         gpointer self)
{
	__lambda93_ (self);
}


static void
__lambda94_ (Block25Data* _data25_, 
             GSettings* setting, 
             const gchar* key)
{
	PreferencesDialog* self;
	gchar* val = NULL;
	gchar* _tmp0_;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	self = _data25_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	val = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (_data25_->schemes_treeview);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	valid = _tmp6_;
	while (TRUE) {
		gboolean _tmp7_;
		gchar* scheme = NULL;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GtkTreeModel* _tmp16_;
		gboolean _tmp17_;
		_tmp7_ = valid;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = model;
		_tmp9_ = iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &scheme, -1, -1);
		_tmp10_ = scheme;
		_tmp11_ = val;
		if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
			GtkTreeSelection* select = NULL;
			GtkTreeSelection* _tmp12_;
			GtkTreeSelection* _tmp13_;
			GtkTreeSelection* _tmp14_;
			GtkTreeIter _tmp15_;
			_tmp12_ = gtk_tree_view_get_selection (_data25_->schemes_treeview);
			_tmp13_ = _g_object_ref0 (_tmp12_);
			select = _tmp13_;
			_tmp14_ = select;
			_tmp15_ = iter;
			gtk_tree_selection_select_iter (_tmp14_, &_tmp15_);
			_g_object_unref0 (select);
			_g_free0 (scheme);
			_g_object_unref0 (model);
			_g_free0 (val);
			return;
		}
		_tmp16_ = model;
		_tmp17_ = gtk_tree_model_iter_next (_tmp16_, &iter);
		valid = _tmp17_;
		_g_free0 (scheme);
	}
	_g_object_unref0 (model);
	_g_free0 (val);
}


static void
___lambda94__g_settings_changed (GSettings* _sender, 
                                 const gchar* key, 
                                 gpointer self)
{
	__lambda94_ (self, _sender, key);
}


static void
preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self, 
                                             GtkBuilder* builder)
{
	Block25Data* _data25_;
	GSettings* _tmp0_;
	GObject* _tmp1_;
	GtkButton* _tmp2_;
	AppSettings* app_settings = NULL;
	AppSettings* _tmp3_;
	GObject* font_button = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GtkWidget* font_hbox = NULL;
	GObject* _tmp6_;
	GtkWidget* _tmp7_;
	GObject* _tmp8_;
	GtkTreeView* _tmp9_;
	gchar* current_scheme_id = NULL;
	gchar* _tmp10_;
	GtkTreeSelection* _tmp11_;
	GtkTreeSelection* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_data25_->settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "default_font_checkbutton");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_button_get_type ()) ? ((GtkButton*) _tmp1_) : NULL);
	_data25_->default_font_checkbutton = _tmp2_;
	g_settings_bind (_data25_->settings, "use-default-font", (GObject*) _data25_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_system_font_label (self, _data25_->default_font_checkbutton);
	_tmp3_ = app_settings_get_default ();
	app_settings = _tmp3_;
	g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) ___lambda92__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp4_ = gtk_builder_get_object (builder, "font_button");
	_tmp5_ = _g_object_ref0 (_tmp4_);
	font_button = _tmp5_;
	g_settings_bind (_data25_->settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = gtk_builder_get_object (builder, "font_hbox");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp6_) : NULL);
	font_hbox = _tmp7_;
	preferences_dialog_set_sensitivity (self, _data25_->settings, "use-default-font", font_hbox, FALSE);
	_tmp8_ = gtk_builder_get_object (builder, "schemes_treeview");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_tree_view_get_type ()) ? ((GtkTreeView*) _tmp8_) : NULL);
	_data25_->schemes_treeview = _tmp9_;
	_tmp10_ = g_settings_get_string (_data25_->settings, "scheme");
	current_scheme_id = _tmp10_;
	preferences_dialog_init_schemes_treeview (self, _data25_->schemes_treeview, current_scheme_id);
	_tmp11_ = gtk_tree_view_get_selection (_data25_->schemes_treeview);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_data25_->schemes_select = _tmp12_;
	g_signal_connect_data (_data25_->schemes_select, "changed", (GCallback) ___lambda93__gtk_tree_selection_changed, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	g_signal_connect_data (_data25_->settings, "changed::scheme", (GCallback) ___lambda94__g_settings_changed, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_g_free0 (current_scheme_id);
	_g_object_unref0 (font_hbox);
	_g_object_unref0 (font_button);
	_g_object_unref0 (app_settings);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}


static const gchar*
__lambda95_ (PreferencesDialog* self, 
             gulong n)
{
	const gchar* result = NULL;
	result = ngettext ("character", "characters", n);
	return result;
}


static const gchar*
___lambda95__preferences_dialog_plural (gulong n, 
                                        gpointer self)
{
	const gchar* result;
	result = __lambda95_ ((PreferencesDialog*) self, n);
	return result;
}


static void
preferences_dialog_init_interactive_completion_setting (PreferencesDialog* self, 
                                                        GtkBuilder* builder)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GObject* interactive_comp_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkSpinButton* interactive_comp_spinbutton = NULL;
	GObject* _tmp3_;
	GtkSpinButton* _tmp4_;
	GtkLabel* interactive_comp_label = NULL;
	GObject* _tmp5_;
	GtkLabel* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "interactive_comp_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	interactive_comp_checkbutton = _tmp2_;
	g_settings_bind (settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "interactive_comp_spinbutton");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp3_) : NULL);
	interactive_comp_spinbutton = _tmp4_;
	preferences_dialog_set_spin_button_range (self, interactive_comp_spinbutton, settings, "interactive-completion-num");
	g_settings_bind (settings, "interactive-completion-num", (GObject*) interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "interactive-completion", (GtkWidget*) interactive_comp_spinbutton, TRUE);
	_tmp5_ = gtk_builder_get_object (builder, "interactive_comp_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp5_) : NULL);
	interactive_comp_label = _tmp6_;
	preferences_dialog_set_plural (self, interactive_comp_label, settings, "interactive-completion-num", ___lambda95__preferences_dialog_plural, self);
	_g_object_unref0 (interactive_comp_label);
	_g_object_unref0 (interactive_comp_spinbutton);
	_g_object_unref0 (interactive_comp_checkbutton);
	_g_object_unref0 (settings);
}


static void
preferences_dialog_init_spell_checking_settings (PreferencesDialog* self, 
                                                 GtkBuilder* builder)
{
	GSettings* editor_settings = NULL;
	GSettings* _tmp0_;
	GspellLanguageChooserButton* spell_language_button = NULL;
	GObject* _tmp1_;
	GspellLanguageChooserButton* _tmp2_;
	GObject* inline_spell_checkbutton = NULL;
	GObject* _tmp3_;
	GObject* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	editor_settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "spell_language_button");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gspell_language_chooser_button_get_type ()) ? ((GspellLanguageChooserButton*) _tmp1_) : NULL);
	spell_language_button = _tmp2_;
	g_settings_bind (editor_settings, "spell-checking-language", (GObject*) spell_language_button, "language-code", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "inline_spell_checkbutton");
	_tmp4_ = _g_object_ref0 (_tmp3_);
	inline_spell_checkbutton = _tmp4_;
	g_settings_bind (editor_settings, "highlight-misspelled-words", inline_spell_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (inline_spell_checkbutton);
	_g_object_unref0 (spell_language_button);
	_g_object_unref0 (editor_settings);
}


static void
preferences_dialog_init_other_tab (PreferencesDialog* self, 
                                   GtkBuilder* builder)
{
	GSettings* latex_settings = NULL;
	GSettings* _tmp0_;
	GObject* confirm_clean_up_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkWidget* auto_clean_up_checkbutton = NULL;
	GObject* _tmp3_;
	GtkWidget* _tmp4_;
	GObject* clean_up_entry = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	latex_settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "confirm_clean_up_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	confirm_clean_up_checkbutton = _tmp2_;
	g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "auto_clean_up_checkbutton");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp3_) : NULL);
	auto_clean_up_checkbutton = _tmp4_;
	g_settings_bind (latex_settings, "automatic-clean", (GObject*) auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, latex_settings, "no-confirm-clean", auto_clean_up_checkbutton, TRUE);
	_tmp5_ = gtk_builder_get_object (builder, "clean_up_entry");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	clean_up_entry = _tmp6_;
	g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (clean_up_entry);
	_g_object_unref0 (auto_clean_up_checkbutton);
	_g_object_unref0 (confirm_clean_up_checkbutton);
	_g_object_unref0 (latex_settings);
}


static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}


static void
__lambda89_ (Block26Data* _data26_, 
             GSettings* setting, 
             const gchar* k)
{
	PreferencesDialog* self;
	gboolean v = FALSE;
	gboolean _tmp0_ = FALSE;
	self = _data26_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	v = g_settings_get_boolean (setting, k);
	if (_data26_->must_be_enabled) {
		gboolean _tmp1_;
		_tmp1_ = v;
		_tmp0_ = _tmp1_;
	} else {
		gboolean _tmp2_;
		_tmp2_ = v;
		_tmp0_ = !_tmp2_;
	}
	gtk_widget_set_sensitive (_data26_->widget, _tmp0_);
}


static void
___lambda89__g_settings_changed (GSettings* _sender, 
                                 const gchar* key, 
                                 gpointer self)
{
	__lambda89_ (self, _sender, key);
}


static void
preferences_dialog_set_sensitivity (PreferencesDialog* self, 
                                    GSettings* settings, 
                                    const gchar* key, 
                                    GtkWidget* widget, 
                                    gboolean must_be_enabled)
{
	Block26Data* _data26_;
	GtkWidget* _tmp0_;
	gboolean val = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (widget != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data26_->widget);
	_data26_->widget = _tmp0_;
	_data26_->must_be_enabled = must_be_enabled;
	val = g_settings_get_boolean (settings, key);
	if (_data26_->must_be_enabled) {
		gboolean _tmp2_;
		_tmp2_ = val;
		_tmp1_ = _tmp2_;
	} else {
		gboolean _tmp3_;
		_tmp3_ = val;
		_tmp1_ = !_tmp3_;
	}
	gtk_widget_set_sensitive (_data26_->widget, _tmp1_);
	_tmp4_ = g_strconcat ("changed::", key, NULL);
	g_signal_connect_data (settings, _tmp4_, (GCallback) ___lambda89__g_settings_changed, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_g_free0 (_tmp4_);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


static void
preferences_dialog_set_system_font_label (PreferencesDialog* self, 
                                          GtkButton* button)
{
	AppSettings* app_settings = NULL;
	AppSettings* _tmp0_;
	gchar* label = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = app_settings_get_default ();
	app_settings = _tmp0_;
	_tmp1_ = app_settings_get_system_font (app_settings);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Use the system fixed width font (%s)"), _tmp2_);
	label = _tmp3_;
	gtk_button_set_label (button, label);
	_g_free0 (label);
	_g_object_unref0 (app_settings);
}


static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->label);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}


static void
__lambda90_ (Block27Data* _data27_, 
             GSettings* setting, 
             const gchar* k)
{
	PreferencesDialog* self;
	guint v = 0U;
	const gchar* _tmp0_;
	self = _data27_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	g_settings_get (setting, k, "u", &v);
	_tmp0_ = _data27_->plural ((gulong) v, _data27_->plural_target);
	gtk_label_set_label (_data27_->label, _tmp0_);
}


static void
___lambda90__g_settings_changed (GSettings* _sender, 
                                 const gchar* key, 
                                 gpointer self)
{
	__lambda90_ (self, _sender, key);
}


static void
preferences_dialog_set_plural (PreferencesDialog* self, 
                               GtkLabel* label, 
                               GSettings* settings, 
                               const gchar* key, 
                               PreferencesDialogPlural plural, 
                               void* plural_target)
{
	Block27Data* _data27_;
	GtkLabel* _tmp0_;
	guint val = 0U;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (label);
	_g_object_unref0 (_data27_->label);
	_data27_->label = _tmp0_;
	_data27_->plural = plural;
	_data27_->plural_target = plural_target;
	g_settings_get (settings, key, "u", &val);
	_tmp1_ = _data27_->plural ((gulong) val, _data27_->plural_target);
	gtk_label_set_label (_data27_->label, _tmp1_);
	_tmp2_ = g_strconcat ("changed::", key, NULL);
	g_signal_connect_data (settings, _tmp2_, (GCallback) ___lambda90__g_settings_changed, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	_g_free0 (_tmp2_);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


static void
preferences_dialog_set_spin_button_range (PreferencesDialog* self, 
                                          GtkSpinButton* spin_button, 
                                          GSettings* settings, 
                                          const gchar* key)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchema* _tmp0_;
	GSettingsSchema* _tmp1_;
	GVariant* range = NULL;
	GSettingsSchemaKey* _tmp2_;
	GSettingsSchemaKey* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* range_type = NULL;
	GVariant* range_contents = NULL;
	guint min = 0U;
	guint max = 0U;
	guint cur_value = 0U;
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin_button != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_object_get (settings, "settings-schema", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	schema = _tmp1_;
	_tmp2_ = g_settings_schema_get_key (schema, key);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_schema_key_get_range (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_settings_schema_key_unref0 (_tmp3_);
	range = _tmp5_;
	g_variant_get (range, "(sv)", &range_type, &range_contents, NULL);
	g_return_if_fail (g_strcmp0 (range_type, "range") == 0);
	g_variant_get (range_contents, "(uu)", &min, &max, NULL);
	g_settings_get (settings, key, "u", &cur_value);
	_tmp6_ = gtk_adjustment_new ((gdouble) cur_value, (gdouble) min, (gdouble) max, 1.0, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp6_);
	adjustment = _tmp6_;
	gtk_spin_button_set_adjustment (spin_button, adjustment);
	_g_object_unref0 (adjustment);
	_g_variant_unref0 (range_contents);
	_g_free0 (range_type);
	_g_variant_unref0 (range);
	_g_settings_schema_unref0 (schema);
}


static void
preferences_dialog_init_schemes_treeview (PreferencesDialog* self, 
                                          GtkTreeView* treeview, 
                                          const gchar* current_id)
{
	GtkListStore* list_store = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp3_;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GtkTreeViewColumn* _tmp6_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* _tmp9_;
	GtkSourceStyleSchemeManager* manager = NULL;
	GtkSourceStyleSchemeManager* _tmp10_;
	GtkSourceStyleSchemeManager* _tmp11_;
	GtkSourceStyleSchemeManager* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (treeview != NULL);
	g_return_if_fail (current_id != NULL);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	list_store = _tmp0_;
	_tmp1_ = list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, (gint) PREFERENCES_DIALOG_STYLE_SCHEMES_ID, GTK_SORT_ASCENDING);
	_tmp2_ = list_store;
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) _tmp2_);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	renderer = _tmp3_;
	_tmp4_ = renderer;
	_tmp5_ = gtk_tree_view_column_new_with_attributes ("Name and description", (GtkCellRenderer*) _tmp4_, "markup", PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, NULL, NULL);
	g_object_ref_sink (_tmp5_);
	column = _tmp5_;
	_tmp6_ = column;
	gtk_tree_view_append_column (treeview, _tmp6_);
	_tmp7_ = gtk_tree_view_get_selection (treeview);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	select = _tmp8_;
	_tmp9_ = select;
	gtk_tree_selection_set_mode (_tmp9_, GTK_SELECTION_SINGLE);
	_tmp10_ = gtk_source_style_scheme_manager_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	manager = _tmp11_;
	_tmp12_ = manager;
	_tmp14_ = _tmp13_ = gtk_source_style_scheme_manager_get_scheme_ids (_tmp12_);
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp14_;
		id_collection_length1 = _vala_array_length (_tmp13_);
		for (id_it = 0; id_it < _vala_array_length (_tmp13_); id_it = id_it + 1) {
			gchar* _tmp15_;
			gchar* id = NULL;
			_tmp15_ = g_strdup (id_collection[id_it]);
			id = _tmp15_;
			{
				GtkSourceStyleScheme* scheme = NULL;
				GtkSourceStyleSchemeManager* _tmp16_;
				const gchar* _tmp17_;
				GtkSourceStyleScheme* _tmp18_;
				GtkSourceStyleScheme* _tmp19_;
				gchar* desc = NULL;
				GtkSourceStyleScheme* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				GtkSourceStyleScheme* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp27_;
				GtkTreeIter _tmp28_ = {0};
				GtkListStore* _tmp29_;
				GtkTreeIter _tmp30_;
				GtkSourceStyleScheme* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp16_ = manager;
				_tmp17_ = id;
				_tmp18_ = gtk_source_style_scheme_manager_get_scheme (_tmp16_, _tmp17_);
				_tmp19_ = _g_object_ref0 (_tmp18_);
				scheme = _tmp19_;
				_tmp20_ = scheme;
				_tmp21_ = gtk_source_style_scheme_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = scheme;
				_tmp24_ = gtk_source_style_scheme_get_description (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup_printf ("<b>%s</b> - %s", _tmp22_, _tmp25_);
				desc = _tmp26_;
				_tmp27_ = list_store;
				gtk_list_store_append (_tmp27_, &_tmp28_);
				iter = _tmp28_;
				_tmp29_ = list_store;
				_tmp30_ = iter;
				_tmp31_ = scheme;
				_tmp32_ = gtk_source_style_scheme_get_id (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = desc;
				gtk_list_store_set (_tmp29_, &_tmp30_, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, _tmp33_, PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, _tmp34_, -1, -1);
				_tmp35_ = id;
				if (g_strcmp0 (_tmp35_, current_id) == 0) {
					GtkTreeSelection* _tmp36_;
					GtkTreeIter _tmp37_;
					_tmp36_ = select;
					_tmp37_ = iter;
					gtk_tree_selection_select_iter (_tmp36_, &_tmp37_);
				}
				_g_free0 (desc);
				_g_object_unref0 (scheme);
				_g_free0 (id);
			}
		}
	}
	_g_object_unref0 (manager);
	_g_object_unref0 (select);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (list_store);
}


static void
preferences_dialog_class_init (PreferencesDialogClass * klass)
{
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void
preferences_dialog_instance_init (PreferencesDialog * self)
{
}


static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



