/* clean_build_files.c generated by valac 0.39.1.3-7091, the Vala compiler
 * generated from clean_build_files.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011, 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>


#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _CleanBuildFilesPrivate CleanBuildFilesPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
enum  {
	CLEAN_BUILD_FILES_0_PROPERTY,
	CLEAN_BUILD_FILES_NUM_PROPERTIES
};
static GParamSpec* clean_build_files_properties[CLEAN_BUILD_FILES_NUM_PROPERTIES];

#define CLEAN_BUILD_FILES_TYPE_CLEAN_FILE_COLUMN (clean_build_files_clean_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _CleanBuildFiles {
	GObject parent_instance;
	CleanBuildFilesPrivate * priv;
};

struct _CleanBuildFilesClass {
	GObjectClass parent_class;
};

struct _CleanBuildFilesPrivate {
	MainWindow* _main_window;
	Document* _doc;
	GSettings* _settings;
};

typedef enum  {
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS
} CleanBuildFilesCleanFileColumn;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block11Data {
	int _ref_count_;
	CleanBuildFiles* self;
	GtkListStore* store;
};


static gpointer clean_build_files_parent_class = NULL;

GType clean_build_files_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
#define CLEAN_BUILD_FILES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesPrivate))
static GType clean_build_files_clean_file_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, 
                                        Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, 
                                              MainWindow* main_window, 
                                              Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
gboolean document_is_main_file_a_tex_file (Document* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, 
                   Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static GeeArrayList* clean_build_files_get_build_files_in_directory (CleanBuildFiles* self, 
                                                              GFile* directory);
GFile* document_get_location (Document* self);
static GeeArrayList* clean_build_files_get_build_files_simple (CleanBuildFiles* self);
static void clean_build_files_show_info_no_file (CleanBuildFiles* self);
void utils_delete_file (GFile* file);
static void clean_build_files_confirm_cleanup (CleanBuildFiles* self, 
                                        GeeArrayList* files_to_delete, 
                                        GFile* directory);
static GtkTreeView* clean_build_files_get_list_files (CleanBuildFiles* self, 
                                               GeeArrayList* files_to_delete, 
                                               GFile* directory);
static GtkDialog* clean_build_files_get_dialog (CleanBuildFiles* self, 
                                         GtkTreeView* list_files);
static void clean_build_files_run_dialog (CleanBuildFiles* self, 
                                   GtkDialog* dialog, 
                                   GtkTreeModel* list_store);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gint clean_build_files_on_sort_list_files (CleanBuildFiles* self, 
                                           GtkTreeModel* model, 
                                           GtkTreeIter* a, 
                                           GtkTreeIter* b);
static gint _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model, 
                                                                       GtkTreeIter* a, 
                                                                       GtkTreeIter* b, 
                                                                       gpointer self);
gchar* utils_get_relative_path (GFile* origin, 
                                GFile* target, 
                                GFile* common_dir);
static void __lambda17_ (Block11Data* _data11_, 
                  const gchar* path_str);
static void ___lambda17__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, 
                                                    const gchar* path, 
                                                    gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void _vala_array_add1 (GFile** * array, 
                       int* length, 
                       int* size, 
                       GFile* value);
static void clean_build_files_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType
clean_build_files_clean_file_column_get_type (void)
{
	static volatile gsize clean_build_files_clean_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_clean_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE", "delete"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME", "name"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE", "file"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType clean_build_files_clean_file_column_type_id;
		clean_build_files_clean_file_column_type_id = g_enum_register_static ("CleanBuildFilesCleanFileColumn", values);
		g_once_init_leave (&clean_build_files_clean_file_column_type_id__volatile, clean_build_files_clean_file_column_type_id);
	}
	return clean_build_files_clean_file_column_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


CleanBuildFiles*
clean_build_files_construct (GType object_type, 
                             MainWindow* main_window, 
                             Document* doc)
{
	CleanBuildFiles * self = NULL;
	Document* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	self = (CleanBuildFiles*) g_object_new (object_type, NULL);
	self->priv->_main_window = main_window;
	_tmp0_ = _g_object_ref0 (doc);
	_g_object_unref0 (self->priv->_doc);
	self->priv->_doc = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	return self;
}


CleanBuildFiles*
clean_build_files_new (MainWindow* main_window, 
                       Document* doc)
{
	return clean_build_files_construct (TYPE_CLEAN_BUILD_FILES, main_window, doc);
}


void
clean_build_files_clean (CleanBuildFiles* self)
{
	Document* _tmp0_;
	GeeArrayList* files_to_delete = NULL;
	GFile* directory = NULL;
	Project* project = NULL;
	Document* _tmp1_;
	Project* _tmp2_;
	Project* _tmp3_;
	gboolean no_confirm = FALSE;
	GSettings* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_doc;
	if (!document_is_main_file_a_tex_file (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->_doc;
	_tmp2_ = document_get_project (_tmp1_);
	project = _tmp2_;
	_tmp3_ = project;
	if (_tmp3_ != NULL) {
		Project* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GeeArrayList* _tmp8_;
		_tmp4_ = project;
		_tmp5_ = (*_tmp4_).directory;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (directory);
		directory = _tmp6_;
		_tmp7_ = directory;
		_tmp8_ = clean_build_files_get_build_files_in_directory (self, _tmp7_);
		_g_object_unref0 (files_to_delete);
		files_to_delete = _tmp8_;
	} else {
		Document* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GeeArrayList* _tmp13_;
		_tmp9_ = self->priv->_doc;
		_tmp10_ = document_get_location (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_get_parent (_tmp11_);
		_g_object_unref0 (directory);
		directory = _tmp12_;
		_tmp13_ = clean_build_files_get_build_files_simple (self);
		_g_object_unref0 (files_to_delete);
		files_to_delete = _tmp13_;
	}
	_tmp14_ = self->priv->_settings;
	no_confirm = g_settings_get_boolean (_tmp14_, "no-confirm-clean");
	_tmp15_ = files_to_delete;
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == 0) {
		gboolean _tmp18_;
		_tmp18_ = no_confirm;
		if (!_tmp18_) {
			clean_build_files_show_info_no_file (self);
		}
		_project_free0 (project);
		_g_object_unref0 (directory);
		_g_object_unref0 (files_to_delete);
		return;
	}
	_tmp19_ = no_confirm;
	if (_tmp19_) {
		{
			GeeArrayList* _file_to_delete_list = NULL;
			GeeArrayList* _tmp20_;
			GeeArrayList* _tmp21_;
			gint _file_to_delete_size = 0;
			GeeArrayList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _file_to_delete_index = 0;
			_tmp20_ = files_to_delete;
			_tmp21_ = _g_object_ref0 (_tmp20_);
			_file_to_delete_list = _tmp21_;
			_tmp22_ = _file_to_delete_list;
			_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_file_to_delete_size = _tmp24_;
			_file_to_delete_index = -1;
			while (TRUE) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				GFile* file_to_delete = NULL;
				GeeArrayList* _tmp28_;
				gint _tmp29_;
				gpointer _tmp30_;
				GFile* _tmp31_;
				_tmp25_ = _file_to_delete_index;
				_file_to_delete_index = _tmp25_ + 1;
				_tmp26_ = _file_to_delete_index;
				_tmp27_ = _file_to_delete_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _file_to_delete_list;
				_tmp29_ = _file_to_delete_index;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
				file_to_delete = (GFile*) _tmp30_;
				_tmp31_ = file_to_delete;
				utils_delete_file (_tmp31_);
				_g_object_unref0 (file_to_delete);
			}
			_g_object_unref0 (_file_to_delete_list);
		}
	} else {
		GeeArrayList* _tmp32_;
		GFile* _tmp33_;
		_tmp32_ = files_to_delete;
		_tmp33_ = directory;
		clean_build_files_confirm_cleanup (self, _tmp32_, _tmp33_);
	}
	_project_free0 (project);
	_g_object_unref0 (directory);
	_g_object_unref0 (files_to_delete);
}


static GeeArrayList*
clean_build_files_get_build_files_simple (CleanBuildFiles* self)
{
	GeeArrayList* result = NULL;
	GFile* location = NULL;
	Document* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* directory = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* exts = NULL;
	GSettings* _tmp6_;
	gchar* _tmp7_;
	gchar** extensions = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint extensions_length1;
	gint _extensions_size_;
	gchar* shortname = NULL;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GeeArrayList* files_to_delete = NULL;
	GeeArrayList* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_doc;
	_tmp1_ = document_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	location = _tmp3_;
	_tmp4_ = location;
	_tmp5_ = g_file_get_parent (_tmp4_);
	directory = _tmp5_;
	_tmp6_ = self->priv->_settings;
	_tmp7_ = g_settings_get_string (_tmp6_, "clean-extensions");
	exts = _tmp7_;
	_tmp8_ = exts;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
	extensions = _tmp10_;
	extensions_length1 = _vala_array_length (_tmp9_);
	_extensions_size_ = extensions_length1;
	_tmp11_ = location;
	_tmp12_ = g_file_get_basename (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = latexila_utils_get_shortname (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	shortname = _tmp15_;
	_tmp16_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	files_to_delete = _tmp16_;
	_tmp17_ = extensions;
	_tmp17__length1 = extensions_length1;
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = _tmp17_;
		extension_collection_length1 = _tmp17__length1;
		for (extension_it = 0; extension_it < _tmp17__length1; extension_it = extension_it + 1) {
			gchar* _tmp18_;
			gchar* extension = NULL;
			_tmp18_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp18_;
			{
				gchar* basename = NULL;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				GFile* file = NULL;
				GFile* _tmp22_;
				const gchar* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				_tmp19_ = shortname;
				_tmp20_ = extension;
				_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
				basename = _tmp21_;
				_tmp22_ = directory;
				_tmp23_ = basename;
				_tmp24_ = g_file_get_child (_tmp22_, _tmp23_);
				file = _tmp24_;
				_tmp25_ = file;
				if (g_file_query_exists (_tmp25_, NULL)) {
					GeeArrayList* _tmp26_;
					GFile* _tmp27_;
					_tmp26_ = files_to_delete;
					_tmp27_ = file;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
				}
				_g_object_unref0 (file);
				_g_free0 (basename);
				_g_free0 (extension);
			}
		}
	}
	result = files_to_delete;
	_g_free0 (shortname);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (exts);
	_g_object_unref0 (directory);
	_g_object_unref0 (location);
	return result;
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static GeeArrayList*
clean_build_files_get_build_files_in_directory (CleanBuildFiles* self, 
                                                GFile* directory)
{
	GeeArrayList* result = NULL;
	gchar* exts = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar** extensions = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint extensions_length1;
	gint _extensions_size_;
	GeeArrayList* files_to_delete = NULL;
	GeeArrayList* _tmp5_;
	GFileEnumerator* enumerator = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "clean-extensions");
	exts = _tmp1_;
	_tmp2_ = exts;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	extensions = _tmp4_;
	extensions_length1 = _vala_array_length (_tmp3_);
	_extensions_size_ = extensions_length1;
	_tmp5_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	files_to_delete = _tmp5_;
	{
		GFileEnumerator* _tmp6_ = NULL;
		GFileEnumerator* _tmp7_;
		GFileEnumerator* _tmp8_;
		_tmp7_ = g_file_enumerate_children (directory, "standard::type,standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp8_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("clean_build_files.vala:123: Clean build files: %s", _tmp10_);
		result = files_to_delete;
		_g_error_free0 (e);
		_g_object_unref0 (enumerator);
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (enumerator);
		_g_object_unref0 (files_to_delete);
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		GFileInfo* info = NULL;
		GFileInfo* _tmp17_;
		gchar* name = NULL;
		GFileInfo* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* file = NULL;
		const gchar* _tmp22_;
		GFile* _tmp23_;
		GFileType type = 0;
		GFileInfo* _tmp24_;
		GFileType _tmp25_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		info = NULL;
		{
			GFileInfo* _tmp11_ = NULL;
			GFileEnumerator* _tmp12_;
			GFileInfo* _tmp13_;
			GFileInfo* _tmp14_;
			_tmp12_ = enumerator;
			_tmp13_ = g_file_enumerator_next_file (_tmp12_, NULL, &_inner_error_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (info);
			info = _tmp14_;
			_g_object_unref0 (_tmp11_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("clean_build_files.vala:137: Clean build files: %s", _tmp16_);
			_g_error_free0 (e);
			_g_object_unref0 (info);
			break;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (files_to_delete);
			extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = info;
		if (_tmp17_ == NULL) {
			_g_object_unref0 (info);
			break;
		}
		_tmp18_ = info;
		_tmp19_ = g_file_info_get_name (_tmp18_);
		_tmp20_ = g_strdup (_tmp19_);
		name = _tmp20_;
		_tmp21_ = name;
		if (string_get (_tmp21_, (glong) 0) == '.') {
			_g_free0 (name);
			_g_object_unref0 (info);
			continue;
		}
		_tmp22_ = name;
		_tmp23_ = g_file_get_child (directory, _tmp22_);
		file = _tmp23_;
		_tmp24_ = info;
		type = g_file_info_get_file_type (_tmp24_);
		_tmp25_ = type;
		if (_tmp25_ == G_FILE_TYPE_DIRECTORY) {
			GeeArrayList* files_to_delete_in_dir = NULL;
			GFile* _tmp26_;
			GeeArrayList* _tmp27_;
			GeeArrayList* _tmp28_;
			GeeArrayList* _tmp29_;
			_tmp26_ = file;
			_tmp27_ = clean_build_files_get_build_files_in_directory (self, _tmp26_);
			files_to_delete_in_dir = _tmp27_;
			_tmp28_ = files_to_delete;
			_tmp29_ = files_to_delete_in_dir;
			gee_array_list_add_all (_tmp28_, (GeeCollection*) _tmp29_);
			_g_object_unref0 (files_to_delete_in_dir);
			_g_object_unref0 (file);
			_g_free0 (name);
			_g_object_unref0 (info);
			continue;
		}
		_tmp30_ = extensions;
		_tmp30__length1 = extensions_length1;
		{
			gchar** ext_collection = NULL;
			gint ext_collection_length1 = 0;
			gint _ext_collection_size_ = 0;
			gint ext_it = 0;
			ext_collection = _tmp30_;
			ext_collection_length1 = _tmp30__length1;
			for (ext_it = 0; ext_it < _tmp30__length1; ext_it = ext_it + 1) {
				gchar* _tmp31_;
				gchar* ext = NULL;
				_tmp31_ = g_strdup (ext_collection[ext_it]);
				ext = _tmp31_;
				{
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp32_ = name;
					_tmp33_ = ext;
					if (g_str_has_suffix (_tmp32_, _tmp33_)) {
						GeeArrayList* _tmp34_;
						GFile* _tmp35_;
						_tmp34_ = files_to_delete;
						_tmp35_ = file;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
						_g_free0 (ext);
						break;
					}
					_g_free0 (ext);
				}
			}
		}
		_g_object_unref0 (file);
		_g_free0 (name);
		_g_object_unref0 (info);
	}
	result = files_to_delete;
	_g_object_unref0 (enumerator);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (exts);
	return result;
}


static void
clean_build_files_confirm_cleanup (CleanBuildFiles* self, 
                                   GeeArrayList* files_to_delete, 
                                   GFile* directory)
{
	gint _tmp0_;
	gint _tmp1_;
	GtkTreeView* list_files = NULL;
	GtkTreeView* _tmp2_;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp3_;
	GtkTreeModel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (files_to_delete != NULL);
	g_return_if_fail (directory != NULL);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) files_to_delete);
	_tmp1_ = _tmp0_;
	g_return_if_fail (0 < _tmp1_);
	_tmp2_ = clean_build_files_get_list_files (self, files_to_delete, directory);
	list_files = _tmp2_;
	_tmp3_ = clean_build_files_get_dialog (self, list_files);
	dialog = _tmp3_;
	_tmp4_ = gtk_tree_view_get_model (list_files);
	clean_build_files_run_dialog (self, dialog, _tmp4_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (list_files);
}


static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		CleanBuildFiles* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->store);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}


static gint
_clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model, 
                                                                  GtkTreeIter* a, 
                                                                  GtkTreeIter* b, 
                                                                  gpointer self)
{
	gint result;
	result = clean_build_files_on_sort_list_files ((CleanBuildFiles*) self, model, a, b);
	return result;
}


static void
__lambda17_ (Block11Data* _data11_, 
             const gchar* path_str)
{
	CleanBuildFiles* self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeIter _tmp6_;
	self = _data11_->self;
	g_return_if_fail (path_str != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
	path = _tmp0_;
	_tmp1_ = _data11_->store;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp2_, path);
	iter = _tmp2_;
	_tmp3_ = _data11_->store;
	_tmp4_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &active, -1);
	_tmp5_ = _data11_->store;
	_tmp6_ = iter;
	gtk_list_store_set (_tmp5_, &_tmp6_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, !active, -1);
	_gtk_tree_path_free0 (path);
}


static void
___lambda17__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, 
                                               const gchar* path, 
                                               gpointer self)
{
	__lambda17_ (self, path);
}


static GtkTreeView*
clean_build_files_get_list_files (CleanBuildFiles* self, 
                                  GeeArrayList* files_to_delete, 
                                  GFile* directory)
{
	GtkTreeView* result = NULL;
	Block11Data* _data11_;
	GtkTreeView* treeview = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeView* _tmp25_;
	GtkListStore* _tmp26_;
	GtkCellRendererToggle* toggle_renderer = NULL;
	GtkCellRendererToggle* _tmp27_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp28_;
	GtkTreeView* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp31_;
	GtkTreeViewColumn* _tmp32_;
	GtkTreeView* _tmp33_;
	GtkTreeViewColumn* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (files_to_delete != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp0_);
	treeview = _tmp0_;
	_tmp1_ = treeview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, 260, 120);
	_tmp2_ = treeview;
	gtk_tree_view_set_headers_visible (_tmp2_, FALSE);
	_tmp3_ = treeview;
	gtk_tree_view_set_enable_search (_tmp3_, FALSE);
	_tmp4_ = gtk_list_store_new ((gint) CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, g_file_get_type (), -1);
	_data11_->store = _tmp4_;
	_tmp5_ = _data11_->store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp5_, 0, _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp6_ = _data11_->store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp6_, 0, GTK_SORT_ASCENDING);
	{
		GeeArrayList* _file_to_delete_list = NULL;
		GeeArrayList* _tmp7_;
		gint _file_to_delete_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _file_to_delete_index = 0;
		_tmp7_ = _g_object_ref0 (files_to_delete);
		_file_to_delete_list = _tmp7_;
		_tmp8_ = _file_to_delete_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_file_to_delete_size = _tmp10_;
		_file_to_delete_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GFile* file_to_delete = NULL;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gchar* relative_path = NULL;
			GFile* _tmp17_;
			gchar* _tmp18_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp19_;
			GtkTreeIter _tmp20_ = {0};
			GtkListStore* _tmp21_;
			GtkTreeIter _tmp22_;
			const gchar* _tmp23_;
			GFile* _tmp24_;
			_tmp11_ = _file_to_delete_index;
			_file_to_delete_index = _tmp11_ + 1;
			_tmp12_ = _file_to_delete_index;
			_tmp13_ = _file_to_delete_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _file_to_delete_list;
			_tmp15_ = _file_to_delete_index;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
			file_to_delete = (GFile*) _tmp16_;
			_tmp17_ = file_to_delete;
			_tmp18_ = utils_get_relative_path (directory, _tmp17_, directory);
			relative_path = _tmp18_;
			_tmp19_ = _data11_->store;
			gtk_list_store_append (_tmp19_, &_tmp20_);
			iter = _tmp20_;
			_tmp21_ = _data11_->store;
			_tmp22_ = iter;
			_tmp23_ = relative_path;
			_tmp24_ = file_to_delete;
			gtk_list_store_set (_tmp21_, &_tmp22_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, TRUE, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, _tmp23_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, _tmp24_, -1);
			_g_free0 (relative_path);
			_g_object_unref0 (file_to_delete);
		}
		_g_object_unref0 (_file_to_delete_list);
	}
	_tmp25_ = treeview;
	_tmp26_ = _data11_->store;
	gtk_tree_view_set_model (_tmp25_, (GtkTreeModel*) _tmp26_);
	_tmp27_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp27_);
	toggle_renderer = _tmp27_;
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda17__gtk_cell_renderer_toggle_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp28_ = gtk_tree_view_column_new_with_attributes ("Delete?", (GtkCellRenderer*) toggle_renderer, "active", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, NULL, NULL);
	g_object_ref_sink (_tmp28_);
	column = _tmp28_;
	_tmp29_ = treeview;
	_tmp30_ = column;
	gtk_tree_view_append_column (_tmp29_, _tmp30_);
	_tmp31_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp31_);
	text_renderer = _tmp31_;
	_tmp32_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) text_renderer, "text", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, NULL);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (column);
	column = _tmp32_;
	_tmp33_ = treeview;
	_tmp34_ = column;
	gtk_tree_view_append_column (_tmp33_, _tmp34_);
	result = treeview;
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (toggle_renderer);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


static GtkDialog*
clean_build_files_get_dialog (CleanBuildFiles* self, 
                              GtkTreeView* list_files)
{
	GtkDialog* result = NULL;
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_;
	GtkDialog* _tmp1_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp2_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkImage* image = NULL;
	GtkImage* _tmp5_;
	GtkLabel* primary_label = NULL;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* select_label = NULL;
	GtkLabel* _tmp11_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_files != NULL, NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	grid = _tmp2_;
	gtk_grid_set_column_spacing (grid, (guint) 12);
	gtk_grid_set_row_spacing (grid, (guint) 8);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 5);
	_tmp3_ = (GtkBox*) gtk_dialog_get_content_area (dialog);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	gtk_box_pack_start (content_area, (GtkWidget*) grid, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp5_);
	image = _tmp5_;
	gtk_widget_set_valign ((GtkWidget*) image, GTK_ALIGN_START);
	gtk_grid_attach (grid, (GtkWidget*) image, 0, 0, 1, 3);
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp6_);
	primary_label = _tmp6_;
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	gtk_widget_set_halign ((GtkWidget*) primary_label, GTK_ALIGN_START);
	gtk_label_set_selectable (primary_label, TRUE);
	gtk_widget_set_margin_bottom ((GtkWidget*) primary_label, 4);
	_tmp7_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _ ("Do you really want to delete these files?"), NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "</span>", NULL);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (primary_label, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	gtk_grid_attach (grid, (GtkWidget*) primary_label, 1, 0, 1, 1);
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Select the files you want to delete:"));
	g_object_ref_sink (_tmp11_);
	select_label = _tmp11_;
	gtk_label_set_line_wrap (select_label, TRUE);
	gtk_widget_set_halign ((GtkWidget*) select_label, GTK_ALIGN_START);
	gtk_grid_attach (grid, (GtkWidget*) select_label, 1, 1, 1, 1);
	_tmp12_ = utils_add_scrollbar ((GtkWidget*) list_files);
	sw = _tmp12_;
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	g_object_set ((GtkWidget*) sw, "expand", TRUE, NULL);
	gtk_grid_attach (grid, (GtkWidget*) sw, 1, 2, 1, 1);
	gtk_widget_show_all ((GtkWidget*) grid);
	result = dialog;
	_g_object_unref0 (sw);
	_g_object_unref0 (select_label);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (grid);
	return result;
}


static void
_vala_array_add1 (GFile** * array, 
                  int* length, 
                  int* size, 
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
clean_build_files_run_dialog (CleanBuildFiles* self, 
                              GtkDialog* dialog, 
                              GtkTreeModel* list_store)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (list_store != NULL);
	if (gtk_dialog_run (dialog) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile** selected_files = NULL;
		GFile** _tmp0_;
		gint selected_files_length1;
		gint _selected_files_size_;
		GtkTreeIter iter = {0};
		gboolean valid = FALSE;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		GFile** _tmp10_;
		gint _tmp10__length1;
		_tmp0_ = g_new0 (GFile*, 0 + 1);
		selected_files = _tmp0_;
		selected_files_length1 = 0;
		_selected_files_size_ = selected_files_length1;
		_tmp2_ = gtk_tree_model_get_iter_first (list_store, &_tmp1_);
		iter = _tmp1_;
		valid = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gboolean selected = FALSE;
			GFile* file_to_delete = NULL;
			GtkTreeIter _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp9_;
			_tmp3_ = valid;
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = iter;
			gtk_tree_model_get (list_store, &_tmp4_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &selected, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, &file_to_delete, -1);
			_tmp5_ = selected;
			if (_tmp5_) {
				GFile** _tmp6_;
				gint _tmp6__length1;
				GFile* _tmp7_;
				GFile* _tmp8_;
				_tmp6_ = selected_files;
				_tmp6__length1 = selected_files_length1;
				_tmp7_ = file_to_delete;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_vala_array_add1 (&selected_files, &selected_files_length1, &_selected_files_size_, _tmp8_);
			}
			_tmp9_ = gtk_tree_model_iter_next (list_store, &iter);
			valid = _tmp9_;
			_g_object_unref0 (file_to_delete);
		}
		_tmp10_ = selected_files;
		_tmp10__length1 = selected_files_length1;
		{
			GFile** file_to_delete_collection = NULL;
			gint file_to_delete_collection_length1 = 0;
			gint _file_to_delete_collection_size_ = 0;
			gint file_to_delete_it = 0;
			file_to_delete_collection = _tmp10_;
			file_to_delete_collection_length1 = _tmp10__length1;
			for (file_to_delete_it = 0; file_to_delete_it < _tmp10__length1; file_to_delete_it = file_to_delete_it + 1) {
				GFile* _tmp11_;
				GFile* file_to_delete = NULL;
				_tmp11_ = _g_object_ref0 (file_to_delete_collection[file_to_delete_it]);
				file_to_delete = _tmp11_;
				{
					GFile* _tmp12_;
					_tmp12_ = file_to_delete;
					utils_delete_file (_tmp12_);
					_g_object_unref0 (file_to_delete);
				}
			}
		}
		selected_files = (_vala_array_free (selected_files, selected_files_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	gtk_widget_destroy ((GtkWidget*) dialog);
}


static gint
clean_build_files_on_sort_list_files (CleanBuildFiles* self, 
                                      GtkTreeModel* model, 
                                      GtkTreeIter* a, 
                                      GtkTreeIter* b)
{
	gint result = 0;
	gchar* name_a = NULL;
	gchar* name_b = NULL;
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *a;
	gtk_tree_model_get (model, &_tmp0_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &name_a, -1);
	_tmp1_ = *b;
	gtk_tree_model_get (model, &_tmp1_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &name_b, -1);
	result = g_utf8_collate (name_a, name_b);
	_g_free0 (name_b);
	_g_free0 (name_a);
	return result;
}


static void
clean_build_files_show_info_no_file (CleanBuildFiles* self)
{
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", _ ("No build file to clean up."));
	g_object_ref_sink (_tmp1_);
	dialog = (GtkDialog*) _tmp1_;
	gtk_dialog_run (dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void
clean_build_files_class_init (CleanBuildFilesClass * klass)
{
	clean_build_files_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CleanBuildFilesPrivate));
	G_OBJECT_CLASS (klass)->finalize = clean_build_files_finalize;
}


static void
clean_build_files_instance_init (CleanBuildFiles * self)
{
	self->priv = CLEAN_BUILD_FILES_GET_PRIVATE (self);
}


static void
clean_build_files_finalize (GObject * obj)
{
	CleanBuildFiles * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLEAN_BUILD_FILES, CleanBuildFiles);
	_g_object_unref0 (self->priv->_doc);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (clean_build_files_parent_class)->finalize (obj);
}


GType
clean_build_files_get_type (void)
{
	static volatile gsize clean_build_files_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CleanBuildFilesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clean_build_files_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CleanBuildFiles), 0, (GInstanceInitFunc) clean_build_files_instance_init, NULL };
		GType clean_build_files_type_id;
		clean_build_files_type_id = g_type_register_static (G_TYPE_OBJECT, "CleanBuildFiles", &g_define_type_info, 0);
		g_once_init_leave (&clean_build_files_type_id__volatile, clean_build_files_type_id);
	}
	return clean_build_files_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



