/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/**
 * bonobo-property-listener.c: Property listener implementation.
 *
 * Author:
 *	Mike Kestner (mkestner@ameritech.net)
 *
 * Copyright 2000, Mike Kestner
 */
#ifndef _BONOBO_PROPERTY_LISTENER_H_
#define _BONOBO_PROPERTY_LISTENER_H_

#include <bonobo/bonobo-arg.h>
#include <bonobo/bonobo-object.h>

BEGIN_GNOME_DECLS

#define BONOBO_PROPERTY_LISTENER_TYPE        (bonobo_property_listener_get_type ())
#define BONOBO_PROPERTY_LISTENER(o)          (GTK_CHECK_CAST ((o), BONOBO_PROPERTY_LISTENER_TYPE, BonoboPropertyListener))
#define BONOBO_PROPERTY_LISTENER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_PROPERTY_LISTENER_TYPE, BonoboPropertyListenerClass))
#define BONOBO_IS_PROPERTY_LISTENER(o)       (GTK_CHECK_TYPE ((o), BONOBO_PROPERTY_LISTENER_TYPE))
#define BONOBO_IS_PROPERTY_LISTENER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_PROPERTY_LISTENER_TYPE))


typedef struct {
        BonoboObject		object;
} BonoboPropertyListener;

typedef struct {
	BonoboObjectClass parent_class;

	/* Signal definition */
	void (* prop_changed) (BonoboPropertyListener *listener, gchar *name, BonoboArg *event_data);
} BonoboPropertyListenerClass;

GtkType bonobo_property_listener_get_type (void);

POA_Bonobo_PropertyListener__epv *bonobo_property_listener_get_epv (void);

BonoboPropertyListener *bonobo_property_listener_new (void);


END_GNOME_DECLS

#endif /* _BONOBO_PROPERTY_LISTENER_H_ */

