/* This is -*- C -*- */
/* $Id: guppi-configure.h,v 1.5 2000/11/12 04:18:20 trow Exp $ */

/*
 * guppi-configure.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CONFIGURE_H
#define _INC_GUPPI_CONFIGURE_H

#include <gtk/gtk.h>
#include "guppi-config-item.h"
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiConfigure GuppiConfigure;
typedef struct _GuppiConfigureClass GuppiConfigureClass;

struct _GuppiConfigure {
  GtkHPaned parent;
  gpointer opaque_internals;
};

struct _GuppiConfigureClass {
  GtkHPanedClass parent_class;
};

#define GUPPI_TYPE_CONFIGURE (guppi_configure_get_type())
#define GUPPI_CONFIGURE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CONFIGURE,GuppiConfigure))
#define GUPPI_CONFIGURE0(obj) ((obj) ? (GUPPI_CONFIGURE(obj)) : NULL)
#define GUPPI_CONFIGURE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CONFIGURE,GuppiConfigureClass))
#define GUPPI_IS_CONFIGURE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CONFIGURE))
#define GUPPI_IS_CONFIGURE0(obj) (((obj) == NULL) || (GUPPI_IS_CONFIGURE(obj)))
#define GUPPI_IS_CONFIGURE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CONFIGURE))

GtkType guppi_configure_get_type (void);

void guppi_configure_construct (GuppiConfigure *);
GtkWidget *guppi_configure_new (void);

void guppi_configure_set_item_tree (GuppiConfigure *, GuppiConfigItem *);

void guppi_configure_select (GuppiConfigure *, GuppiConfigItem *);

gboolean guppi_configure_contains_tag (GuppiConfigure *, gconstpointer);
void guppi_configure_select_by_tag (GuppiConfigure *, gconstpointer);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_CONFIGURE_H */

/* $Id: guppi-configure.h,v 1.5 2000/11/12 04:18:20 trow Exp $ */
