/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: gnan.c,v 1.3 2000/12/16 16:57:37 mortenw Exp $ */

/*
 * gnan.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <glib.h>
#include "gnan.h"


union ieee754_big_endian_double {
  
  double d;

  struct {
    unsigned int signbit:1;
    unsigned int exp:11;
    unsigned int man0:20;
    unsigned int man1:32;
    
  } ieee;
};

union ieee754_little_endian_double {
  
  double d;

  struct {
    unsigned int man1:32;
    unsigned int man0:20;
    unsigned int exp:11;
    unsigned int signbit:1;
  } ieee;
};

/* little endian, but with big endian float word order */
union ieee754_mixed_endian_double {
  
  double d;

  struct {
    unsigned int man0:20;
    unsigned int exp:11;
    unsigned int signbit:1;
    unsigned int man1:32;
  } ieee;
};

#ifndef NAN
const double NAN;
#endif

#define NUMBER 1.0
#define SIGNBIT 0
#define MAN0 0
#define MAN1 0
#define EXP 1023

void
gnan_init (void)
{
#ifdef NAN
  g_assert (isnan (NAN));
#else
  union ieee754_big_endian_double be;
  union ieee754_little_endian_double le;
  union ieee754_mixed_endian_double me;
  double d;

  /* Note: we declared NAN const so we have to be a bit careful about
     changing it.  Otherwise we outsmart the compiler and thus
     ourselves.  Not good.  */

  be.d = NUMBER;
  if (sizeof (double) == 8
      && be.ieee.signbit == SIGNBIT
      && be.ieee.man0 == MAN0
      && be.ieee.man1 == MAN1
      && be.ieee.exp == EXP) {
    
    be.ieee.signbit = 0;
    be.ieee.man0 = 1;
    be.ieee.man1 = 1;
    be.ieee.exp = 2047;

    memcpy ((double *)&NAN, &be.d, sizeof (double));
    if (isnan (NAN)) return;
  }

  le.d = NUMBER;
  if (sizeof (double) == 8
      && le.ieee.signbit == SIGNBIT
      && le.ieee.man0 == MAN0
      && le.ieee.man1 == MAN1
      && le.ieee.exp == EXP) {
    
    le.ieee.signbit = 0;
    le.ieee.man0 = 1;
    le.ieee.man1 = 1;
    le.ieee.exp = 2047;

    memcpy ((double *)&NAN, &le.d, sizeof (double));
    if (isnan (NAN)) return;
  }

  me.d = NUMBER;
  if (sizeof (double) == 8
      && me.ieee.signbit == SIGNBIT
      && me.ieee.man0 == MAN0
      && me.ieee.man1 == MAN1
      && me.ieee.exp == EXP) {
    
    me.ieee.signbit = 0;
    me.ieee.man0 = 1;
    me.ieee.man1 = 1;
    me.ieee.exp = 2047;

    memcpy ((double *)&NAN, &me.d, sizeof (double));
    if (isnan (NAN)) return;
  }

  /* This is goofy, but is worth a try... */
  d = sqrt (-1.0);
  memcpy ((double *)&NAN, &d, sizeof (double));
  if (isnan (NAN)) return;

  g_error ("This system's floating point is seriously warped.");
  g_assert_not_reached ();
#endif /* NAN */
}



/* $Id: gnan.c,v 1.3 2000/12/16 16:57:37 mortenw Exp $ */
