/* This is -*- C -*- */
/* $Id: guppi-style.h,v 1.8 2000/10/27 18:23:00 trow Exp $ */

/*
 * guppi-style.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_STYLE_H
#define _INC_GUPPI_STYLE_H

#include <gnome.h>
#include "guppi-marker.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiStyle GuppiStyle;
typedef struct _GuppiStyleClass GuppiStyleClass;

struct _GuppiStyle {
  GtkObject parent;

  gchar *label;

  GuppiMarker marker;
  double marker_sz1, marker_sz2;

  guint32 color, color_dim, color_bright;
  double line_width;

  gint freeze_count;
  gboolean pending_change;
  guint pending_delayed_change;
};

struct _GuppiStyleClass {
  GtkObjectClass parent_class;

  GtkWidget *(*edit_widget) (GuppiStyle *);

  void (*changed) (GuppiStyle *);
};

#define GUPPI_TYPE_STYLE (guppi_style_get_type())
#define GUPPI_STYLE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_STYLE,GuppiStyle))
#define GUPPI_STYLE0(obj) ((obj) ? (GUPPI_STYLE(obj)) : NULL)
#define GUPPI_STYLE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_STYLE,GuppiStyleClass))
#define GUPPI_IS_STYLE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_STYLE))
#define GUPPI_IS_STYLE0(obj) (((obj) == NULL) || (GUPPI_IS_STYLE(obj)))
#define GUPPI_IS_STYLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_STYLE))

GtkType guppi_style_get_type (void);

GuppiStyle *guppi_style_new (void);

#define guppi_style_marker(x) ((x)->marker)
#define guppi_style_marker_size1(x) ((x)->marker_sz1)
#define guppi_style_marker_size2(x) ((x)->marker_sz2)
#define guppi_style_color(x) ((x)->color)
#define guppi_style_color_dim(x) ((x)->color_dim)
#define guppi_style_color_bright(x) ((x)->color_bright)
#define guppi_style_line_width(x) ((x)->line_width)

void guppi_style_set_marker (GuppiStyle *, GuppiMarker);
void guppi_style_set_marker_size1 (GuppiStyle *, double);
void guppi_style_set_marker_size2 (GuppiStyle *, double);
void guppi_style_set_color (GuppiStyle *, guint32);
void guppi_style_set_color_dim (GuppiStyle *, guint32);
void guppi_style_set_color_bright (GuppiStyle *, guint32);
void guppi_style_set_line_width (GuppiStyle *, double);

void guppi_style_copy (GuppiStyle * dest, const GuppiStyle * src);

void guppi_style_freeze (GuppiStyle *);
void guppi_style_thaw (GuppiStyle *);
void guppi_style_changed (GuppiStyle *);
void guppi_style_changed_delayed (GuppiStyle *);
void guppi_style_flush_changes (GuppiStyle *);

GuppiStyle *guppi_style_stock (gint i, gint which_collection);
GuppiStyle *guppi_style_stock_alien (gint i);

GtkWidget *guppi_style_edit_widget (GuppiStyle *);
void guppi_style_edit_window (GuppiStyle *);


END_GUPPI_DECLS

#endif /* _INC_GUPPI_STYLE_H */

/* $Id: guppi-style.h,v 1.8 2000/10/27 18:23:00 trow Exp $ */
