/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-seq-point.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_POINT_H
#define _INC_GUPPI_SEQ_POINT_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include "guppi-seq.h"

BEGIN_GUPPI_DECLS

typedef struct _GuppiSeqPoint GuppiSeqPoint;
typedef struct _GuppiSeqPointClass GuppiSeqPointClass;

struct _GuppiSeqPoint {
  GuppiSeq parent;
};

struct _GuppiSeqPointClass {
  GuppiSeqClass parent_class;
};

#define GUPPI_TYPE_SEQ_POINT (guppi_seq_point_get_type ())
#define GUPPI_SEQ_POINT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_POINT,GuppiSeqPoint))
#define GUPPI_SEQ_POINT0(obj) ((obj) ? (GUPPI_SEQ_POINT(obj)) : NULL)
#define GUPPI_SEQ_POINT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_POINT,GuppiSeqPointClass))
#define GUPPI_IS_SEQ_POINT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_POINT))
#define GUPPI_IS_SEQ_POINT0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_POINT(obj)))
#define GUPPI_IS_SEQ_POINT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_POINT))

GtkType guppi_seq_point_get_type (void);

GuppiData *guppi_seq_point_new (void);

void guppi_seq_point_get (GuppiSeqPoint *seq, gint i, double *x, double *y);
double guppi_seq_point_get_x (GuppiSeqPoint *seq, gint i);
double guppi_seq_point_get_y (GuppiSeqPoint *seq, gint i);

void guppi_seq_point_set (GuppiSeqPoint *seq, gint i, double x, double y);
void guppi_seq_point_set_x (GuppiSeqPoint *seq, gint, double x);
void guppi_seq_point_set_y (GuppiSeqPoint *seq, gint, double y);

void guppi_seq_point_prepend (GuppiSeqPoint *seq, double x, double y);

void guppi_seq_point_append (GuppiSeqPoint *seq, double x, double y);

void guppi_seq_point_insert (GuppiSeqPoint *seq, gint i, double x, double y);

void guppi_seq_point_get_many (GuppiSeqPoint *seq, gint i0, gint i1,
			       double *x_data, double *y_data);

gconstpointer guppi_seq_point_raw_x (GuppiSeqPoint *seq, gint *stride);
gconstpointer guppi_seq_point_raw_y (GuppiSeqPoint *seq, gint *stride);

#define guppi_seq_point_raw_get(ptr, str, i) \
(*(const double *)(((gchar *)pt)+(str)*(i)))

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_POINT_H */

/* $Id: guppi-seq-point.h,v 1.3 2000/11/22 21:42:50 trow Exp $ */
