/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-seq-point-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_POINT_IMPL_H
#define _INC_GUPPI_SEQ_POINT_IMPL_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include "guppi-seq-impl.h"

BEGIN_GUPPI_DECLS

typedef struct _GuppiSeqPointImpl GuppiSeqPointImpl;
typedef struct _GuppiSeqPointImplClass GuppiSeqPointImplClass;

struct _GuppiSeqPointImpl {
  GuppiSeqImpl parent;
};

struct _GuppiSeqPointImplClass {
  GuppiSeqImplClass parent_class;

  void (*bbox) (GuppiSeqPointImpl *impl, double *x0, double *y0,
		double *x1, double *y1);
  void (*get) (GuppiSeqPointImpl *impl, gint i, double *x, double *y);
  void (*set) (GuppiSeqPointImpl *impl, gint i, double x, double y);
  void (*insert) (GuppiSeqPointImpl *impl, gint i, double x, double y);

  void (*get_many) (GuppiSeqPointImpl *impl, gint i0, gint i1,
		    double *x_data, double *y_data);
  
  gconstpointer (*raw_x) (GuppiSeqPointImpl *impl, gint *stride);
  gconstpointer (*raw_y) (GuppiSeqPointImpl *impl, gint *stride);
};

#define GUPPI_TYPE_SEQ_POINT_IMPL (guppi_seq_point_impl_get_type ())
#define GUPPI_SEQ_POINT_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_POINT_IMPL,GuppiSeqPointImpl))
#define GUPPI_SEQ_POINT_IMPL0(obj) ((obj) ? (GUPPI_SEQ_POINT_IMPL(obj)) : NULL)
#define GUPPI_SEQ_POINT_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_POINT_IMPL,GuppiSeqPointImplClass))
#define GUPPI_IS_SEQ_POINT_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_POINT_IMPL))
#define GUPPI_IS_SEQ_POINT_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_POINT_IMPL(obj)))
#define GUPPI_IS_SEQ_POINT_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_POINT_IMPL))

GtkType guppi_seq_point_impl_get_type (void);

GtkObject *guppi_seq_point_impl_new (void);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_POINT_IMPL_H */

/* $Id: guppi-seq-point-impl.h,v 1.3 2000/11/22 21:42:50 trow Exp $ */
