/* This is -*- C -*- */
/* $Id: guppi-text-print.c,v 1.7 2000/12/12 23:11:57 trow Exp $ */

/*
 * guppi-text-print.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-convenient.h>
#include <guppi-useful.h>
#include "guppi-text-print.h"
#include "guppi-text-state.h"
#include "guppi-text-view.h"

static GtkObjectClass *parent_class = NULL;

static void
guppi_text_print_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/*****************************************************************************/

static void
print (GuppiElementPrint * ep)
{
  GuppiTextState *state = GUPPI_TEXT_STATE (guppi_element_print_state (ep));
  GnomeFont *font;
  const gchar *text;
  double w, x, y, x0, y0, x1, y1;

  font = gnome_font_new (gnome_font_get_name (guppi_text_state_font (state)),
			 guppi_text_state_font_size (state));

  text = guppi_text_state_text (state);

  w = gnome_font_get_width_string (font, text);

  x0 = ep->pt_x0 + guppi_text_state_left_margin (state);
  y0 = ep->pt_y0 + guppi_text_state_bottom_margin (state);
  x1 = ep->pt_x1 - guppi_text_state_right_margin (state);
  y1 = ep->pt_y1 - guppi_text_state_top_margin (state);

  x = (x0 + x1) / 2 - w / 2;
  y = (y0 + y1) / 2 - gnome_font_get_ascender (font) / 2;

  guppi_element_print_setrgbacolor_uint (ep, guppi_text_state_color (state));
  guppi_element_print_setfont (ep, font);
  guppi_element_print_moveto (ep, x, y);
  guppi_element_print_show (ep, text);

  guppi_unref (font);
}

/*****************************************************************************/

static void
guppi_text_print_class_init (GuppiTextPrintClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementPrintClass *ep_class = GUPPI_ELEMENT_PRINT_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_PRINT);

  object_class->finalize = guppi_text_print_finalize;

  ep_class->print = print;
}

static void
guppi_text_print_init (GuppiTextPrint * obj)
{

}

GtkType guppi_text_print_get_type (void)
{
  static GtkType guppi_text_print_type = 0;
  if (!guppi_text_print_type) {
    static const GtkTypeInfo guppi_text_print_info = {
      "GuppiTextPrint",
      sizeof (GuppiTextPrint),
      sizeof (GuppiTextPrintClass),
      (GtkClassInitFunc) guppi_text_print_class_init,
      (GtkObjectInitFunc) guppi_text_print_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_text_print_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_PRINT, &guppi_text_print_info);
  }
  return guppi_text_print_type;
}

/* $Id: guppi-text-print.c,v 1.7 2000/12/12 23:11:57 trow Exp $ */
