/* This is -*- C -*- */
/* $Id: guppi-scatter-style.h,v 1.8 2000/10/27 18:22:49 trow Exp $ */

/*
 * guppi-scatter-style.h
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCATTER_STYLE_H
#define _INC_GUPPI_SCATTER_STYLE_H

#include <gnome.h>
#include <guppi-style.h>
#include <guppi-color-gradient.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiScatterStyle GuppiScatterStyle;
typedef struct _GuppiScatterStyleClass GuppiScatterStyleClass;

struct _GuppiScatterStyle {
  GuppiStyle parent;

  gboolean allow_style_grad;
  gboolean rev_style_grad;
  GuppiStyle *grad_style;

  gboolean allow_color_grad;
  gboolean rev_color_grad;
  GuppiColorGradient *color_grad;

  gboolean allow_size1_grad;
  gboolean rev_size1_grad;
  double size1_range;

  gboolean allow_size2_grad;
  gboolean rev_size2_grad;
  double size2_range;

  gint freeze_count;
  gboolean pending_change;
  guint pending_delayed_change;
};

struct _GuppiScatterStyleClass {
  GtkStyleClass parent_class;
};

#define GUPPI_TYPE_SCATTER_STYLE (guppi_scatter_style_get_type())
#define GUPPI_SCATTER_STYLE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SCATTER_STYLE,GuppiScatterStyle))
#define GUPPI_SCATTER_STYLE0(obj) ((obj) ? (GUPPI_SCATTER_STYLE(obj)) : NULL)
#define GUPPI_SCATTER_STYLE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SCATTER_STYLE,GuppiScatterStyleClass))
#define GUPPI_IS_SCATTER_STYLE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SCATTER_STYLE))
#define GUPPI_IS_SCATTER_STYLE0(obj) (((obj) == NULL) || (GUPPI_IS_SCATTER_STYLE(obj)))
#define GUPPI_IS_SCATTER_STYLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SCATTER_STYLE))

GtkType guppi_scatter_style_get_type (void);

GuppiScatterStyle *guppi_scatter_style_new (void);
GuppiScatterStyle *guppi_scatter_style_stock (gint i);


#define guppi_scatter_style_allow_style_gradient(x) ((x)->allow_style_grad)
#define guppi_scatter_style_reverse_style_gradient(x) ((x)->rev_style_grad)
#define guppi_scatter_style_gradient_style(x) ((x)->grad_style)


#define guppi_scatter_style_allow_color_gradient(x) ((x)->allow_color_grad)
#define guppi_scatter_style_reverse_color_gradient(x) ((x)->rev_color_grad)
#define guppi_scatter_style_color_gradient(x) ((x)->color_grad)

#define guppi_scatter_style_allow_size1_gradient(x) ((x)->allow_size1_grad)
#define guppi_scatter_style_reverse_size1_gradient(x) ((x)->rev_size1_grad)
#define guppi_scatter_style_size1_gradient_range(x) ((x)->size1_range)

#define guppi_scatter_style_size1_gradient_min(x) ((1-(x)->size1_range) * guppi_style_marker_size1(GUPPI_STYLE(x)))
#define guppi_scatter_style_size1_gradient_max(x) ((1+(x)->size1_range) * guppi_style_marker_size1(GUPPI_STYLE(x)))

#define guppi_scatter_style_allow_size2_gradient(x) ((x)->allow_size2_grad)
#define guppi_scatter_style_reverse_size2_gradient(x) ((x)->rev_size2_grad)
#define guppi_scatter_style_size2_gradient_range(x) ((x)->size2_range)

#define guppi_scatter_style_size2_gradient_min(x) ((1-(x)->size2_range) * guppi_style_marker_size2(GUPPI_STYLE(x)))
#define guppi_scatter_style_size2_gradient_max(x) ((1+(x)->size2_range) * guppi_style_marker_size2(GUPPI_STYLE(x)))



void guppi_scatter_style_set_allow_style_gradient (GuppiScatterStyle *,
						   gboolean);
void guppi_scatter_style_set_reverse_style_gradient (GuppiScatterStyle *,
						     gboolean);
void guppi_scatter_style_set_gradient_style (GuppiScatterStyle *,
					     GuppiStyle *);


void guppi_scatter_style_set_allow_color_gradient (GuppiScatterStyle *,
						   gboolean);
void guppi_scatter_style_set_reverse_color_gradient (GuppiScatterStyle *,
						     gboolean);
void guppi_scatter_style_set_color_gradient (GuppiScatterStyle *,
					     GuppiColorGradient *);



void guppi_scatter_style_set_allow_size1_gradient (GuppiScatterStyle *,
						   gboolean);
void guppi_scatter_style_set_reverse_size1_gradient (GuppiScatterStyle *,
						     gboolean);
void guppi_scatter_style_set_size1_gradient_range (GuppiScatterStyle *,
						   double);


void guppi_scatter_style_set_allow_size2_gradient (GuppiScatterStyle *,
						   gboolean);
void guppi_scatter_style_set_reverse_size2_gradient (GuppiScatterStyle *,
						     gboolean);
void guppi_scatter_style_set_size2_gradient_range (GuppiScatterStyle *,
						   double);

guint32 guppi_scatter_style_calc_color_gradient (GuppiScatterStyle *, double);
double guppi_scatter_style_calc_size1_gradient (GuppiScatterStyle *, double);
double guppi_scatter_style_calc_size2_gradient (GuppiScatterStyle *, double);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SCATTER_STYLE_H */

/* $Id: guppi-scatter-style.h,v 1.8 2000/10/27 18:22:49 trow Exp $ */
