/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-pricebars-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-memory.h>
#include <guppi-rgb.h>
#include "guppi-pricebars-state.h"
#include "guppi-pricebars-view.h"

static GtkObjectClass * parent_class = NULL;

enum {
  ARG_0,
  ARG_DATA,
  ARG_COLOR
};

static void
guppi_pricebars_state_get_arg (GtkObject *obj, GtkArg *arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_pricebars_state_set_arg (GtkObject *obj, GtkArg *arg, guint arg_id)
{
  GuppiPricebarsState *state = GUPPI_PRICEBARS_STATE (obj);

  switch (arg_id) {

  case ARG_DATA:
    guppi_pricebars_state_set_data (state, GUPPI_PRICE_SERIES (GTK_VALUE_POINTER (*arg)));
    break;

  case ARG_COLOR:
    guppi_pricebars_state_set_color (state, GTK_VALUE_UINT (*arg));
    break;

  default:
    break;
  };
}

static void
guppi_pricebars_state_finalize (GtkObject *obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

#define add_arg(str, t, symb) \
gtk_object_add_arg_type("GuppiPricebarsState::" str, t, GTK_ARG_WRITABLE, symb)

static void
guppi_pricebars_state_class_init (GuppiPricebarsStateClass *klass)
{
  GtkObjectClass* object_class = (GtkObjectClass *)klass;
  GuppiElementStateClass *state_class = GUPPI_ELEMENT_STATE_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_STATE);

  object_class->get_arg = guppi_pricebars_state_get_arg;
  object_class->set_arg = guppi_pricebars_state_set_arg;
  object_class->finalize = guppi_pricebars_state_finalize;

  state_class->name = _("Price Bars");
  state_class->view_type = GUPPI_TYPE_PRICEBARS_VIEW;

  add_arg ("data", GTK_TYPE_POINTER, ARG_DATA);
  add_arg ("color", GTK_TYPE_UINT, ARG_COLOR);
}

static void
guppi_pricebars_state_init (GuppiPricebarsState *obj)
{
  GuppiElementState *es = GUPPI_ELEMENT_STATE (obj);

  obj->thickness = 10;
  obj->color = RGBA_BLUE;

  guppi_element_state_add_shared (es, SHARED_DATA, guppi_shared_data ());
}

GtkType
guppi_pricebars_state_get_type (void)
{
  static GtkType guppi_pricebars_state_type = 0;
  if (!guppi_pricebars_state_type) {
    static const GtkTypeInfo guppi_pricebars_state_info = {
      "GuppiPricebarsState",
      sizeof (GuppiPricebarsState),
      sizeof (GuppiPricebarsStateClass),
      (GtkClassInitFunc)guppi_pricebars_state_class_init,
      (GtkObjectInitFunc)guppi_pricebars_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_pricebars_state_type = gtk_type_unique (GUPPI_TYPE_ELEMENT_STATE, &guppi_pricebars_state_info);
  }
  return guppi_pricebars_state_type;
}

GuppiElementState *
guppi_pricebars_state_new (void)
{
  return GUPPI_ELEMENT_STATE (guppi_type_new (guppi_pricebars_state_get_type ()));
}

GuppiPriceSeries *
guppi_pricebars_state_data (GuppiPricebarsState *state)
{
  GtkObject *obj;

  g_return_val_if_fail (state && GUPPI_IS_PRICEBARS_STATE (state), NULL);

  obj = guppi_element_state_get_shared (GUPPI_ELEMENT_STATE (state),
					SHARED_DATA);

  return GUPPI_PRICE_SERIES0 (obj);
}

void
guppi_pricebars_state_set_data (GuppiPricebarsState *state,
				GuppiPriceSeries *ser)
{
  g_return_if_fail (state && GUPPI_IS_PRICEBARS_STATE (state));
  g_return_if_fail (ser && GUPPI_IS_PRICE_SERIES (ser));

  guppi_element_state_set_shared (GUPPI_ELEMENT_STATE (state),
				  SHARED_DATA, ser);
}

void
guppi_pricebars_state_set_thickness (GuppiPricebarsState *state,
				     double x)
{
  g_return_if_fail (state && GUPPI_IS_PRICEBARS_STATE (state));

  if (state->thickness != x) {
    state->thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_pricebars_state_set_color (GuppiPricebarsState *state,
				 guint32 x)
{
  g_return_if_fail (state && GUPPI_IS_PRICEBARS_STATE (state));

  if (state->color != x) {
    state->color = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}
