/* This is -*- C -*- */
/* $Id: guppi-pie-state.h,v 1.14 2000/10/27 18:22:48 trow Exp $ */

/*
 * guppi-pie-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PIE_STATE_H
#define _INC_GUPPI_PIE_STATE_H

#include <gnome.h>
#include <guppi-defs.h>
#include <libgnomeprint/gnome-font.h>
#include <guppi-element-state.h>
#include <guppi-seq-scalar.h>
#include <guppi-seq-style.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiPieState GuppiPieState;
typedef struct _GuppiPieStateClass GuppiPieStateClass;

struct _GuppiPieState {
  GuppiElementState parent;

  gboolean radius_lock, radius_maximize;
  double radius, edge_width;
  double base_offset, base_angle;

  guint32 default_slice_color, edge_color;
  guint32 use_stock_colors;

  gboolean show_percentage;

  GnomeFont *label_font;
  guint32 label_color;

  double data_abs_sum;

  GuppiSeqScalar *slice_offsets;

};

struct _GuppiPieStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_PIE_STATE (guppi_pie_state_get_type())
#define GUPPI_PIE_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PIE_STATE,GuppiPieState))
#define GUPPI_PIE_STATE0(obj) ((obj) ? (GUPPI_PIE_STATE(obj)) : NULL)
#define GUPPI_PIE_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PIE_STATE,GuppiPieStateClass))
#define GUPPI_IS_PIE_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PIE_STATE))
#define GUPPI_IS_PIE_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_PIE_STATE(obj)))
#define GUPPI_IS_PIE_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PIE_STATE))

GtkType guppi_pie_state_get_type (void);

GuppiElementState *guppi_pie_state_new (void);

GuppiData *guppi_pie_state_data (GuppiPieState *);
GuppiData *guppi_pie_state_labels (GuppiPieState *);
GuppiSeqStyle *guppi_pie_state_styles (GuppiPieState *);

#define guppi_pie_state_radius_lock(x) ((x)->radius_lock)
#define guppi_pie_state_radius_maximize(x) ((x)->radius_maximize)
#define guppi_pie_state_radius(x) ((x)->radius)
#define guppi_pie_state_edge_width(x) ((x)->edge_width)
#define guppi_pie_state_base_offset(x) ((x)->base_offset)
#define guppi_pie_state_base_angle(x) ((x)->base_angle)
#define guppi_pie_state_default_slice_color(x) ((x)->default_slice_color)
#define guppi_pie_state_use_stock_colors(x) ((x)->use_stock_colors)
#define guppi_pie_state_edge_color(x) ((x)->edge_color)
#define guppi_pie_state_show_percentages(x) ((x)->show_percentage)
#define guppi_pie_state_label_font(x) ((x)->label_font)
#define guppi_pie_state_label_color(x) ((x)->label_color)

void guppi_pie_state_set_data (GuppiPieState *, GuppiData *);
void guppi_pie_state_set_labels (GuppiPieState *, GuppiData *);
void guppi_pie_state_set_styles (GuppiPieState *, GuppiSeqStyle *);

void guppi_pie_state_set_radius_lock (GuppiPieState *, gboolean);
void guppi_pie_state_set_radius_maximize (GuppiPieState *, gboolean);
void guppi_pie_state_set_radius (GuppiPieState *, double);
void guppi_pie_state_set_edge_width (GuppiPieState *, double);
void guppi_pie_state_set_base_offset (GuppiPieState *, double);
void guppi_pie_state_set_base_angle (GuppiPieState *, double);
void guppi_pie_state_set_default_slice_color (GuppiPieState *, guint32);
void guppi_pie_state_set_use_stock_colors (GuppiPieState * state, guint32 x);
void guppi_pie_state_set_edge_color (GuppiPieState *, guint32);
void guppi_pie_state_set_show_percentages (GuppiPieState *, gboolean);
void guppi_pie_state_set_label_font (GuppiPieState *, GnomeFont *);
void guppi_pie_state_set_label_color (GuppiPieState *, guint32);


/* Front-end for accessing data */

void guppi_pie_state_slice_bounds (GuppiPieState * pie,
				   gint * i0, gint * i1);

double guppi_pie_state_slice_percentage (GuppiPieState * pie, gint i);

gboolean guppi_pie_state_need_separate_label_data (GuppiPieState * pie);
const gchar *guppi_pie_state_slice_label (GuppiPieState *, gint i);

guint32 guppi_pie_state_slice_color (GuppiPieState *, gint i);

double guppi_pie_state_slice_offset (GuppiPieState *, gint i);
void guppi_pie_state_set_slice_offset (GuppiPieState *, gint i, double x);


END_GUPPI_DECLS

#endif /* _INC_GUPPI_PIE_STATE_H */

/* $Id: guppi-pie-state.h,v 1.14 2000/10/27 18:22:48 trow Exp $ */
