/* This is -*- C -*- */
/* $Id: guppi-linegraph-state.h,v 1.4 2000/11/26 21:48:00 trow Exp $ */

/*
 * guppi-linegraph-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_LINEGRAPH_STATE_H
#define _INC_GUPPI_LINEGRAPH_STATE_H

#include <gnome.h>
#include <guppi-defs.h>
#include <guppi-element-state.h>
#include <guppi-seq-scalar.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiLinegraphState GuppiLinegraphState;
typedef struct _GuppiLinegraphStateClass GuppiLinegraphStateClass;

struct _GuppiLinegraphState {
  GuppiElementState parent;

  double width;
  guint32 color;
};

struct _GuppiLinegraphStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_LINEGRAPH_STATE (guppi_linegraph_state_get_type())
#define GUPPI_LINEGRAPH_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_LINEGRAPH_STATE,GuppiLinegraphState))
#define GUPPI_LINEGRAPH_STATE0(obj) ((obj) ? (GUPPI_LINEGRAPH_STATE(obj)) : NULL)
#define GUPPI_LINEGRAPH_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_LINEGRAPH_STATE,GuppiLinegraphStateClass))
#define GUPPI_IS_LINEGRAPH_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_LINEGRAPH_STATE))
#define GUPPI_IS_LINEGRAPH_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_LINEGRAPH_STATE(obj)))
#define GUPPI_IS_LINEGRAPH_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_LINEGRAPH_STATE))

GtkType guppi_linegraph_state_get_type (void);

GuppiElementState *guppi_linegraph_state_new (void);

GuppiData *guppi_linegraph_state_data (GuppiLinegraphState *);
void guppi_linegraph_state_set_data (GuppiLinegraphState *, GuppiData *);

GuppiSeqScalar *guppi_linegraph_state_x_data (GuppiLinegraphState *);
void guppi_linegraph_state_set_x_data (GuppiLinegraphState *,
				       GuppiSeqScalar *);

GuppiSeqScalar *guppi_linegraph_state_y_data (GuppiLinegraphState *);
void guppi_linegraph_state_set_y_data (GuppiLinegraphState *,
				       GuppiSeqScalar *);

#define guppi_linegraph_state_width(x) ((x)->width)
#define guppi_linegraph_state_color(x) ((x)->color)

void guppi_linegraph_state_set_width (GuppiLinegraphState *, double);
void guppi_linegraph_state_set_color (GuppiLinegraphState *, guint32);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_LINEGRAPH_STATE_H */

/* $Id: guppi-linegraph-state.h,v 1.4 2000/11/26 21:48:00 trow Exp $ */
