/* This is -*- C -*- */
/* $Id: guppi-linegraph-item.c,v 1.9 2000/12/19 04:53:44 trow Exp $ */

/*
 * guppi-linegraph-item.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <math.h>
#include <guppi-useful.h>
#include "guppi-linegraph-item.h"
#include "guppi-linegraph-view.h"
#include "guppi-linegraph-state.h"

static GtkObjectClass *parent_class = NULL;

static void
guppi_linegraph_item_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_linegraph_item_finalize (GtkObject * obj)
{
  GuppiLinegraphItem *item = GUPPI_LINEGRAPH_ITEM (obj);

  if (item->path) {
    guppi_free (item->path);
    item->path = NULL;
  }

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/****************************************************************************/

static void
state_changed (GuppiCanvasItem * gci)
{
  guppi_canvas_item_request_update (gci);
}

static void
view_changed (GuppiCanvasItem * gci)
{
  guppi_canvas_item_request_update (gci);
}

/****************************************************************************/

static void
update (GuppiCanvasItem * gci, double aff[6], ArtSVP * svp, gint flags)
{
  GuppiLinegraphItem *item = GUPPI_LINEGRAPH_ITEM (gci);
  GuppiLinegraphView *view = GUPPI_LINEGRAPH_VIEW (guppi_canvas_item_view (gci));

  if (item->path) {
    guppi_free (item->path);
    item->path = NULL;
  }

  item->path = guppi_linegraph_view_build_path (view);

  /* Sweep through and change coordinates in our path. */
  if (item->path)
    guppi_canvas_item_vpath_vp2c (gci, item->path);
}

static void
render (GuppiCanvasItem * gci, GnomeCanvasBuf * buf)
{
  GuppiLinegraphItem *item = GUPPI_LINEGRAPH_ITEM (gci);
  GuppiLinegraphState *state =
    GUPPI_LINEGRAPH_STATE (guppi_canvas_item_state (gci));
  double sc = guppi_canvas_item_scale (gci);
  double w;

  w = guppi_pt2px (guppi_linegraph_state_width (state) * sc);

  if (item->path) 
    guppi_paint_wide_curve (buf, item->path, w,
			    guppi_linegraph_state_color (state));
}

/****************************************************************************/

static void
guppi_linegraph_item_class_init (GuppiLinegraphItemClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiCanvasItemClass *item_class = GUPPI_CANVAS_ITEM_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_CANVAS_ITEM);

  object_class->destroy = guppi_linegraph_item_destroy;
  object_class->finalize = guppi_linegraph_item_finalize;

  item_class->state_changed = state_changed;
  item_class->view_changed = view_changed;
  item_class->guppi_update = update;
  item_class->guppi_render = render;
}

static void
guppi_linegraph_item_init (GuppiLinegraphItem * obj)
{

}

GtkType guppi_linegraph_item_get_type (void)
{
  static GtkType guppi_linegraph_item_type = 0;
  if (!guppi_linegraph_item_type) {
    static const GtkTypeInfo guppi_linegraph_item_info = {
      "GuppiLinegraphItem",
      sizeof (GuppiLinegraphItem),
      sizeof (GuppiLinegraphItemClass),
      (GtkClassInitFunc) guppi_linegraph_item_class_init,
      (GtkObjectInitFunc) guppi_linegraph_item_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_linegraph_item_type =
      gtk_type_unique (GUPPI_TYPE_CANVAS_ITEM, &guppi_linegraph_item_info);
  }
  return guppi_linegraph_item_type;
}

/* $Id: guppi-linegraph-item.c,v 1.9 2000/12/19 04:53:44 trow Exp $ */
