/* This is -*- C -*- */
/* $Id: guppi-legend-state.h,v 1.7 2000/10/27 18:22:46 trow Exp $ */

/*
 * guppi-legend-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_LEGEND_STATE_H
#define _INC_GUPPI_LEGEND_STATE_H

#include <gnome.h>
#include <guppi-defs.h>
#include <guppi-data.h>
#include <guppi-seq-style.h>
#include <libgnomeprint/gnome-font.h>
#include <guppi-element-state.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiLegendState GuppiLegendState;
typedef struct _GuppiLegendStateClass GuppiLegendStateClass;

struct _GuppiLegendState {
  GuppiElementState parent;

  double box_width, box_height;
  double box_edge_thickness;
  guint32 box_edge_color;
  double edge_margin, label_offset;

  GnomeFont *label_font;
  guint32 label_color;

};

struct _GuppiLegendStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_LEGEND_STATE (guppi_legend_state_get_type())
#define GUPPI_LEGEND_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_LEGEND_STATE,GuppiLegendState))
#define GUPPI_LEGEND_STATE0(obj) ((obj) ? (GUPPI_LEGEND_STATE(obj)) : NULL)
#define GUPPI_LEGEND_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_LEGEND_STATE,GuppiLegendStateClass))
#define GUPPI_IS_LEGEND_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_LEGEND_STATE))
#define GUPPI_IS_LEGEND_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_LEGEND_STATE(obj)))
#define GUPPI_IS_LEGEND_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_LEGEND_STATE))

GtkType guppi_legend_state_get_type (void);

GuppiElementState *guppi_legend_state_new (void);

GuppiData *guppi_legend_state_labels (GuppiLegendState *);
GuppiSeqStyle *guppi_legend_state_styles (GuppiLegendState *);

#define guppi_legend_state_box_width(x) ((x)->box_width)
#define guppi_legend_state_box_height(x) ((x)->box_height)
#define guppi_legend_state_box_edge_thickness(x) ((x)->box_edge_thickness)
#define guppi_legend_state_box_edge_color(x) ((x)->box_edge_color)
#define guppi_legend_state_edge_margin(x) ((x)->edge_margin)
#define guppi_legend_state_label_offset(x) ((x)->label_offset)
#define guppi_legend_state_label_font(x) ((x)->label_font)
#define guppi_legend_state_label_color(x) ((x)->label_color)

void guppi_legend_state_set_labels (GuppiLegendState *, GuppiData *);
void guppi_legend_state_set_styles (GuppiLegendState *, GuppiSeqStyle *);

void guppi_legend_state_set_box_width (GuppiLegendState *, double);
void guppi_legend_state_set_box_height (GuppiLegendState *, double);
void guppi_legend_state_set_box_edge_thickness (GuppiLegendState *, double);
void guppi_legend_state_set_box_edge_color (GuppiLegendState *, guint32);
void guppi_legend_state_set_edge_margin (GuppiLegendState *, double);
void guppi_legend_state_set_label_offset (GuppiLegendState *, double);
void guppi_legend_state_set_label_font (GuppiLegendState *, GnomeFont *);
void guppi_legend_state_set_label_color (GuppiLegendState *, guint32);


void guppi_legend_state_entry_bounds (GuppiLegendState *,
				      gint * i0, gint * i1);
guint32 guppi_legend_state_entry_color (GuppiLegendState *, gint i);
const gchar *guppi_legend_state_entry_text (GuppiLegendState *, gint i);

double guppi_legend_state_max_label_width (GuppiLegendState *);
double guppi_legend_state_natural_width (GuppiLegendState *);
double guppi_legend_state_natural_height (GuppiLegendState *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_LEGEND_STATE_H */

/* $Id: guppi-legend-state.h,v 1.7 2000/10/27 18:22:46 trow Exp $ */
