/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-boxplot-register.c
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include <config.h>
#include <guppi-root-group-view.h>
#include "guppi-XLplots-common.h"
#include "guppi-chart-type.h"
#include "guppi-boxplot-register.h"
#include "boxplot.xpm"

typedef struct
{
  int dummy;
} BoxChartDescriptor;

static GuppiRootGroupView *
guppi_boxplot_factory (GuppiMinorChartType const *t,
		       GuppiSeqData   *series,
		       GuppiSeqData   *labels,
		       GuppiSeqString *series_names)
{
  return guppi_unimplemented_plot ();
}

void
guppi_boxplot_register ()
{
  GuppiMajorChartType *boxplot_types =
      guppi_major_chart_type_register ( _("Stock"), boxplot_icon, NULL);

  {
    static BoxChartDescriptor const desc = { };
    guppi_minor_chart_type_register (boxplot_types,
      _("3 series"), "chart_stock_1_1.png",
      _("High, Low, Close."),
      1, 1, &guppi_boxplot_factory, &desc);
  }

  {
    static BoxChartDescriptor const desc = { };
    guppi_minor_chart_type_register (boxplot_types,
      _("4 series"), "chart_stock_1_2.png",
      _("open, High, Low, Close."),
      1, 2, &guppi_boxplot_factory, &desc);
  }

  { static BoxChartDescriptor const desc = { };
    guppi_minor_chart_type_register (boxplot_types,
      _("4 series (2)"), "chart_stock_2_1.png",
      _("Volume, High, Low, Close,"),
      2, 1, &guppi_boxplot_factory, &desc);
  }

  { static BoxChartDescriptor const desc = { };
    guppi_minor_chart_type_register (boxplot_types,
      _("5 series"), "chart_stock_2_2.png",
      _("Volume, Open, High, Low, Close,"),
      2, 2, &guppi_boxplot_factory, &desc);
  }
}
