/* This is -*- C -*- */
/* $Id: func.h,v 1.4 2000/11/12 04:23:11 trow Exp $ */

/*
 * func.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_FUNC_H
#define _INC_FUNC_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include <guppi-fn-wrapper.h>
#include <guppi-seq-scalar.h>
#include <guppi-seq-scalar-impl.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiSeqScalarFuncImpl GuppiSeqScalarFuncImpl;
typedef struct _GuppiSeqScalarFuncImplClass GuppiSeqScalarFuncImplClass;

struct _GuppiSeqScalarFuncImpl {
  GuppiSeqScalarImpl parent;

  double (*basic_unary) (double, gpointer);
  GuppiFnWrapper *basic_unary_wrapper;

  double (*basic_binary) (double, double, gpointer);
  GuppiFnWrapper *basic_binary_wrapper;

  gpointer user_data;

  GuppiSeqScalar *arg1;
  GuppiSeqScalar *arg2;
};

struct _GuppiSeqScalarFuncImplClass {
  GuppiSeqScalarImplClass parent_class;
};

#define GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL (guppi_seq_scalar_func_impl_get_type())
#define GUPPI_SEQ_SCALAR_FUNC_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL,GuppiSeqScalarFuncImpl))
#define GUPPI_SEQ_SCALAR_FUNC_IMPL0(obj) ((obj) ? (GUPPI_SEQ_SCALAR_FUNC_IMPL(obj)) : NULL)
#define GUPPI_SEQ_SCALAR_FUNC_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL,GuppiSeqScalarFuncImplClass))
#define GUPPI_IS_SEQ_SCALAR_FUNC_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL))
#define GUPPI_IS_SEQ_SCALAR_FUNC_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_SCALAR_FUNC_IMPL(obj)))
#define GUPPI_IS_SEQ_SCALAR_FUNC_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL))

GtkType guppi_seq_scalar_func_impl_get_type (void);

GuppiData *guppi_seq_scalar_new_func (GuppiFnWrapper * fn,
				      GuppiSeqScalar * arg);

GuppiData *guppi_seq_scalar_new_binary_func (GuppiFnWrapper * fn,
					     GuppiSeqScalar * arg1,
					     GuppiSeqScalar * arg2);


END_GUPPI_DECLS

#endif /* _INC_FUNC_H */

/* $Id: func.h,v 1.4 2000/11/12 04:23:11 trow Exp $ */
