/* This is -*- C -*- */
/* $Id: func.h,v 1.3 2000/11/12 04:23:11 trow Exp $ */

/*
 * guppi-curve-func-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CURVE_FUNC_IMPL_H
#define _INC_GUPPI_CURVE_FUNC_IMPL_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include <guppi-data.h>
#include <guppi-curve.h>
#include <guppi-fn-wrapper.h>
#include <guppi-curve-impl.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiCurveFuncImpl GuppiCurveFuncImpl;
typedef struct _GuppiCurveFuncImplClass GuppiCurveFuncImplClass;

struct _GuppiCurveFuncImpl {
  GuppiCurveImpl parent;

  gboolean reparameterize;
  double t0, t1;
  GuppiFnWrapper *t_fn_wrapper;

  GuppiFnWrapper *x_fn_wrapper;
  GuppiFnWrapper *y_fn_wrapper;
  GuppiFnWrapper *x_binary_fn_wrapper;
  GuppiFnWrapper *y_binary_fn_wrapper;

  double use_2x2_matrix;
  double a, b, c, d;

  GuppiCurve *base_curve;
};

struct _GuppiCurveFuncImplClass {
  GuppiCurveImplClass parent_class;
};

#define GUPPI_TYPE_CURVE_FUNC_IMPL (guppi_curve_func_impl_get_type())
#define GUPPI_CURVE_FUNC_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CURVE_FUNC_IMPL,GuppiCurveFuncImpl))
#define GUPPI_CURVE_FUNC_IMPL0(obj) ((obj) ? (GUPPI_CURVE_FUNC_IMPL(obj)) : NULL)
#define GUPPI_CURVE_FUNC_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CURVE_FUNC_IMPL,GuppiCurveFuncImplClass))
#define GUPPI_IS_CURVE_FUNC_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CURVE_FUNC_IMPL))
#define GUPPI_IS_CURVE_FUNC_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_CURVE_FUNC_IMPL(obj)))
#define GUPPI_IS_CURVE_FUNC_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CURVE_FUNC_IMPL))

GtkType guppi_curve_func_impl_get_type (void);

GuppiData *guppi_curve_new_reparameterize_linearly (double t0, double t1,
						    GuppiCurve *c);
GuppiData *guppi_curve_new_reparameterize (double t0, double t1,
					   GuppiFnWrapper *fn,
					   GuppiCurve *c);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_CURVE_FUNC_IMPL_H */

/* $Id: func.h,v 1.3 2000/11/12 04:23:11 trow Exp $ */
