/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.webdav.frames;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.w3c.cvs.CvsAddException;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.cvs.UpToDateCheckFailedException;
import org.w3c.jigedit.cvs.CvsFrame;
import org.w3c.jigedit.cvs.CvsModule;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.webdav.DAVFrame;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.util.IO;
import org.w3c.www.mime.MimeType;

public class CvsDAVFileFrame
extends DAVFrame {
    public static final boolean debug = true;
    private static int ATTR_AUTOUPDATE = -1;
    protected File resDirectory = null;

    static {
        BooleanAttribute booleanAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.webdav.frames.CvsDAVFileFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        booleanAttribute = new BooleanAttribute("autoupdate", Boolean.FALSE, 2);
        ATTR_AUTOUPDATE = AttributeRegistry.registerAttribute(clazz, (Attribute)booleanAttribute);
    }

    protected void add(Request request) throws CvsException {
        String string = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string, "LOGNAME=" + string};
        String[] stringArray2 = null;
        MimeType mimeType = request.getContentType();
        stringArray2 = mimeType != null && mimeType.match(MimeType.TEXT) != 3 ? new String[]{"-kb", this.getFileResource().getFile().getName()} : new String[]{this.getFileResource().getFile().getName()};
        CvsDirectory cvsDirectory = null;
        cvsDirectory = this.getCvsManager();
        cvsDirectory.add(stringArray2, stringArray);
    }

    protected boolean checkCvsManager() {
        try {
            return this.getCvsManager() != null;
        }
        catch (CvsException cvsException) {
            return false;
        }
    }

    protected void commit(Request request) throws CvsException {
        this.commit(request, "Changed through Jigsaw.");
    }

    protected void commit(Request request, String string) throws CvsException {
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string2, "LOGNAME=" + string2};
        String string3 = "(" + string2 + ") " + string;
        CvsDirectory cvsDirectory = null;
        cvsDirectory = this.getCvsManager();
        cvsDirectory.commit(this.getFileResource().getFile().getName(), string3, stringArray);
    }

    protected Reply deleteFileResource(Request request) throws ProtocolException, ResourceException {
        String string;
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string2, "LOGNAME=" + string2};
        ((HTTPFrame)this).fresource.getFile().delete();
        String[] stringArray2 = new String[]{((HTTPFrame)this).fresource.getFilename()};
        if (stringArray2[0] == null) {
            stringArray2[0] = ((HTTPFrame)this).fresource.getIdentifier();
        }
        try {
            if (this.getCvsManager().status(stringArray2[0]) != 7) {
                this.getCvsManager().remove(stringArray2, "Deleted via HTTP delete method.", stringArray);
            }
        }
        catch (CvsException cvsException) {
            string = "Cvs remove failed : " + cvsException.getMessage();
            this.getServer().errlog((Resource)this, string);
        }
        try {
            ((HTTPFrame)this).fresource.delete();
        }
        catch (MultipleLockException multipleLockException) {
            String string3 = "Can't delete resource: " + ((ResourceFrame)this).resource.getIdentifier() + " is locked. Try again later.";
            string = CvsDAVFileFrame.error(request, 403, "Error", string3);
            throw new HTTPException((Reply)string);
        }
        return request.makeReply(204);
    }

    protected static Reply error(Request request, int n, String string, String string2) {
        Reply reply = request.makeReply(n);
        HtmlGenerator htmlGenerator = CvsFrame.getHtmlGenerator(string);
        htmlGenerator.append("<span class=\"title\">", string, "</span>\n");
        htmlGenerator.append("<p>", string2);
        reply.setStream(htmlGenerator);
        return reply;
    }

    protected File getBackupFile() {
        File file = this.getFileResource().getFile();
        return new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
    }

    protected synchronized CvsDirectory getCvsManager() throws CvsException {
        return CvsModule.getCvsManager(this.getResourceDirectory(), this.getContext(), (Properties)this.getServer().getProperties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized File getResourceDirectory() {
        if (this.resDirectory != null) return this.resDirectory;
        ResourceReference resourceReference = this.getFileResource().getParent();
        ResourceReference resourceReference2 = null;
        Resource resource = null;
        while (true) {
            Object var6_4;
            block10: {
                block9: {
                    File file;
                    block8: {
                        try {
                            try {
                                if (resourceReference == null) {
                                    file = null;
                                    var6_4 = null;
                                    if (resourceReference == null) return file;
                                    break block8;
                                }
                                resource = resourceReference.lock();
                                if (resource instanceof DirectoryResource) {
                                    this.resDirectory = ((DirectoryResource)resource).getDirectory();
                                    break block9;
                                }
                                resourceReference2 = resource.getParent();
                                break block10;
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                File file2 = null;
                                var6_4 = null;
                                if (resourceReference == null) return file2;
                                resourceReference.unlock();
                                return file2;
                            }
                        }
                        catch (Throwable throwable) {
                            var6_4 = null;
                            if (resourceReference == null) throw throwable;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                    resourceReference.unlock();
                    return file;
                }
                var6_4 = null;
                if (resourceReference == null) return this.resDirectory;
                resourceReference.unlock();
                return this.resDirectory;
            }
            var6_4 = null;
            if (resourceReference != null) {
                resourceReference.unlock();
            }
            resourceReference = resourceReference2;
        }
    }

    public boolean isAutoUpdatable() {
        return this.getBoolean(ATTR_AUTOUPDATE, false);
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        block3: {
            if (!this.checkRequest(requestInterface)) {
                return null;
            }
            String string = ((Request)requestInterface).getMethod();
            if (!string.equals("GET") && !string.equals("HEAD") && !string.equals("POST") && !string.equals("PUT") || !this.isAutoUpdatable() || ((HTTPFrame)this).fresource == null) break block3;
            try {
                this.update();
            }
            catch (CvsException cvsException) {
                String string2 = "cvs update \"" + this.getFileResource().getFile().getName() + "\" failed.";
                this.getServer().errlog((Resource)this, string2);
            }
        }
        return super.perform(requestInterface);
    }

    protected Reply putFileResource(Request request) throws ProtocolException, ResourceException {
        System.out.println("Put on " + this.getResource().getIdentifier() + "...");
        if (this.getResourceDirectory() != null) {
            if (this.checkCvsManager()) {
                File file = this.getFileResource().getFile();
                int n = -1;
                try {
                    n = this.status();
                }
                catch (CvsException cvsException) {
                    n = 7;
                }
                System.out.println("... with a cvs status equals to : " + this.statusToString(n));
                if (n == 5) {
                    String string = "Conflict between working revision and repository revision.<br> Please update the file manually or use the CVS form.";
                    return CvsDAVFileFrame.error(request, 409, "Conflict", string);
                }
                if (n == 8) {
                    String string = "File already in the repository (added independently by second party).<br>Please update the file manually or use the CVS form.";
                    return CvsDAVFileFrame.error(request, 409, "Conflict", string);
                }
                if (file.exists() && n != 7) {
                    File file2 = this.getBackupFile();
                    try {
                        if (n == 1) {
                            try {
                                IO.copy((File)file, (File)file2);
                            }
                            catch (IOException iOException) {
                                file2.delete();
                                file.renameTo(file2);
                            }
                            Reply reply = super.putFileResource(request);
                            int n2 = reply.getStatus();
                            if (n2 / 100 == 2) {
                                this.commit(request);
                            }
                            file2.delete();
                            this.getFileResource().checkContent();
                            if (n2 / 100 == 2) {
                                return this.createDefaultReply(request, reply.getStatus());
                            }
                            return reply;
                        }
                        String string = "File is not up to date, please update the file manually or use the CVS form.";
                        return CvsDAVFileFrame.error(request, 409, "Error", string);
                    }
                    catch (UpToDateCheckFailedException upToDateCheckFailedException) {
                        file.delete();
                        file2.renameTo(file);
                        String string = String.valueOf(upToDateCheckFailedException.getFilename()) + " is not up to date, " + "please update the file manually " + "or use the CVS form.";
                        return CvsDAVFileFrame.error(request, 409, "Error", string);
                    }
                    catch (CvsException cvsException) {
                        file2.delete();
                        String string = "CvsException : " + cvsException.getMessage();
                        this.getServer().errlog(String.valueOf(this.getIdentifier()) + " : " + cvsException.getMessage());
                        return CvsDAVFileFrame.error(request, 503, "Error", string);
                    }
                }
                Reply reply = super.putFileResource(request);
                try {
                    this.add(request);
                    this.commit(request);
                    this.getFileResource().checkContent();
                }
                catch (CvsAddException cvsAddException) {
                    String string = "Cvs add failed : <br>'" + cvsAddException.getMessage() + "'<br>please update the file manually " + "or use the CVS form";
                    return CvsDAVFileFrame.error(request, 503, "Error", string);
                }
                catch (CvsException cvsException) {
                    cvsException.printStackTrace();
                    String string = "Problem during cvs process : " + cvsException.getMessage();
                    this.getServer().errlog(String.valueOf(this.getIdentifier()) + " : " + string);
                    return CvsDAVFileFrame.error(request, 500, "Internal Server Error", string);
                }
                if (reply.getStatus() == 201) {
                    Reply reply2 = request.makeReply(reply.getStatus());
                    reply2.setContent("<P>Resource succesfully created");
                    if (request.hasState("org.w3c.jigsaw.frames.HTTPFrame.cl")) {
                        reply2.setContentLocation(this.getURL(request).toExternalForm());
                    }
                    reply = this.createDefaultReply(request, 201);
                    reply2.setETag(reply.getETag());
                    return reply2;
                }
                return this.createDefaultReply(request, reply.getStatus());
            }
            return super.putFileResource(request);
        }
        String string = "Server misconfigured : unable to find resource directory";
        this.getServer().errlog(String.valueOf(this.getIdentifier()) + " : " + string);
        return CvsDAVFileFrame.error(request, 500, "Internal Server Error", string);
    }

    protected int status() throws CvsException {
        CvsDirectory cvsDirectory = this.getCvsManager();
        return cvsDirectory.status(this.getFileResource().getFile().getName());
    }

    protected String statusToString(int n) {
        return CvsDirectory.statusToString((int)n);
    }

    protected void update() throws CvsException {
        CvsDirectory cvsDirectory = this.getCvsManager();
        cvsDirectory.update(this.getFileResource().getFile().getName());
    }
}

