/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.AttributesHelper;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.Utilities;

public class RealmsServerHelper
extends JPanel
implements ServerHelperInterface {
    protected static final String ADD_USER_AC = "add_user";
    protected static final String DEL_USER_AC = "del_user";
    protected static final String DEL_REALM_AC = "del_realm";
    protected String name = null;
    protected String tooltip = null;
    protected RemoteResourceWrapper root = null;
    protected RemoteResourceWrapper realmrrw = null;
    protected RemoteResourceWrapper userrrw = null;
    protected Vector realms = null;
    protected Vector users = null;
    protected JComboBox combo = null;
    protected JPanel usersPanel = null;
    protected JPanel userPanel = null;
    protected JList usersList = null;
    protected JTextField userT = null;
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == RealmsServerHelper.this.combo) {
                String string = (String)RealmsServerHelper.this.combo.getSelectedItem();
                if (RealmsServerHelper.this.realms.contains(string)) {
                    RealmsServerHelper.this.selectRealm(string);
                } else if (string.length() > 0) {
                    RealmsServerHelper.this.addRealm(string);
                }
            } else if (actionEvent.getActionCommand().equals(RealmsServerHelper.ADD_USER_AC) || object == RealmsServerHelper.this.userT) {
                String string = RealmsServerHelper.this.userT.getText();
                if (string.length() > 0 && !RealmsServerHelper.this.users.contains(string)) {
                    RealmsServerHelper.this.addUser(string);
                }
            } else if (actionEvent.getActionCommand().equals(RealmsServerHelper.DEL_USER_AC)) {
                Thread thread = new Thread(RealmsServerHelper.this){
                    private final /* synthetic */ RealmsServerHelper this$0;
                    {
                        this.this$0 = realmsServerHelper;
                    }

                    public void run() {
                        this.this$0.deleteCurrentUser();
                    }
                };
                thread.start();
            } else if (actionEvent.getActionCommand().equals(RealmsServerHelper.DEL_REALM_AC)) {
                Thread thread = new Thread(RealmsServerHelper.this){
                    private final /* synthetic */ RealmsServerHelper this$0;
                    {
                        this.this$0 = realmsServerHelper;
                    }

                    public void run() {
                        this.this$0.deleteCurrentRealm();
                    }
                };
                thread.start();
            }
        }
    };
    ListSelectionListener lsl = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = RealmsServerHelper.this.usersList.getSelectedIndex();
                RealmsServerHelper.this.selectUser((String)RealmsServerHelper.this.users.elementAt(n));
            }
        }
    };

    protected void addRealm(String string) {
        try {
            this.root.getResource().registerResource(string, "org.w3c.jigsaw.auth.AuthRealm");
            this.combo.invalidate();
            this.combo.addItem(string);
            this.combo.validate();
            this.selectRealm(string);
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void addUser(String string) {
        try {
            if (this.realmrrw == null) {
                return;
            }
            this.realmrrw.getResource().registerResource(string, "org.w3c.jigsaw.auth.AuthUser");
            this.selectRealm((String)this.combo.getSelectedItem());
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void build() {
        this.removeAll();
        var1_1 = null;
        try {
            var1_1 = this.root.getResource().enumerateResourceIdentifiers();
        }
        catch (RemoteAccessException var2_2) {
            ** while (this.root.getServerBrowser().shouldRetry((RemoteAccessException)var2_3))
        }
lbl-1000:
        // 1 sources

        {
            try {
                var1_1 = this.root.getResource().enumerateResourceIdentifiers();
                break;
            }
            catch (RemoteAccessException var3_5) {
                var2_3 = var3_5;
            }
            continue;
        }
lbl14:
        // 3 sources

        if (var1_1 == null) {
            return;
        }
        Sorter.sortStringArray((String[])var1_1, (boolean)true);
        this.realms = new Vector<E>(var1_1.length);
        var2_4 = 0;
        while (var2_4 < var1_1.length) {
            this.realms.addElement(var1_1[var2_4]);
            ++var2_4;
        }
        this.setLayout(new BorderLayout());
        var3_6 = new JPanel();
        this.combo = new JComboBox<E>(this.realms);
        this.combo.setEditable(true);
        this.combo.addActionListener(this.al);
        var4_7 = new JLabel("Enter the realm name or");
        var5_8 = new JLabel("select one from the list:");
        var4_7.setAlignmentX(0.5f);
        var5_8.setAlignmentX(0.5f);
        var3_6.setLayout(new BoxLayout(var3_6, 1));
        var3_6.add(var4_7);
        var3_6.add(var5_8);
        var3_6.add(this.combo);
        var6_9 = BorderFactory.createTitledBorder("Realms");
        var6_9.setTitleFont(Utilities.mediumBoldFont);
        var3_6.setBorder(var6_9);
        this.usersPanel = new JPanel(new BorderLayout(4, 4));
        var6_9 = BorderFactory.createTitledBorder("Realm");
        var6_9.setTitleFont(Utilities.mediumBoldFont);
        this.usersPanel.setBorder(var6_9);
        var7_10 = new JPanel(new BorderLayout());
        var7_10.add((Component)var3_6, "North");
        var7_10.add((Component)this.usersPanel, "Center");
        this.userPanel = new JPanel(new BorderLayout());
        this.initUserPanel();
        this.add((Component)var7_10, "West");
        this.add((Component)this.userPanel, "Center");
    }

    protected void deleteCurrentRealm() {
        if (this.realmrrw == null) {
            return;
        }
        try {
            this.realmrrw.getResource().delete();
            this.invalidate();
            this.build();
            this.validate();
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void deleteCurrentUser() {
        if (this.userrrw == null) {
            return;
        }
        try {
            this.userrrw.getResource().delete();
            this.selectRealm((String)this.combo.getSelectedItem());
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    public Component getComponent() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    protected void initUserPanel() {
        this.userPanel.removeAll();
        this.userPanel.invalidate();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("User");
        titledBorder.setTitleFont(Utilities.mediumBoldFont);
        this.userPanel.setBorder(titledBorder);
        this.userPanel.validate();
    }

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.root = remoteResourceWrapper;
        this.name = string;
        this.tooltip = (String)((Hashtable)properties).get("tooltip");
        this.build();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void selectRealm(String var1_1) {
        this.initUserPanel();
        this.usersPanel.removeAll();
        this.users = null;
        this.realmrrw = null;
        try {
            this.realmrrw = this.root.getChildResource(var1_1);
        }
        catch (RemoteAccessException var2_2) {
            ** while (this.root.getServerBrowser().shouldRetry((RemoteAccessException)var2_3))
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.realmrrw = this.root.getChildResource(var1_1);
                break;
            }
            catch (RemoteAccessException var3_5 /* !! */ ) {
                var2_3 = var3_5 /* !! */ ;
            }
            continue;
        }
lbl16:
        // 3 sources

        if (this.realmrrw == null) {
            return;
        }
        try {
            var2_3 = this.realmrrw.getResource().enumerateResourceIdentifiers();
            Sorter.sortStringArray((String[])var2_3, (boolean)true);
            this.users = new Vector<E>(((String[])var2_3).length);
            var3_6 = 0;
            while (var3_6 < ((String[])var2_3).length) {
                this.users.addElement(var2_3[var3_6]);
                ++var3_6;
            }
        }
        catch (RemoteAccessException var2_4) {
            Message.showErrorMessage((Component)this, var2_4);
        }
        if (this.users == null) {
            return;
        }
        this.usersPanel.invalidate();
        if (this.usersList != null) {
            this.usersList.removeListSelectionListener(this.lsl);
        }
        this.usersList = new JList<E>(this.users);
        this.usersList.addListSelectionListener(this.lsl);
        this.usersList.setSelectionMode(0);
        this.usersList.setBorder(BorderFactory.createLoweredBevelBorder());
        var2_3 = new JButton("Add user");
        var2_3.setMargin(Utilities.insets0);
        var2_3.setActionCommand("add_user");
        var2_3.addActionListener(this.al);
        var3_7 = new JButton("Delete " + var1_1);
        var3_7.setMargin(Utilities.insets0);
        var3_7.setActionCommand("del_realm");
        var3_7.addActionListener(this.al);
        this.userT = new JTextField(8);
        this.userT.addActionListener(this.al);
        var4_8 = new JPanel(new BorderLayout(1, 4));
        var4_8.add((Component)this.userT, "West");
        var4_8.add((Component)var2_3, "Center");
        var5_9 = new JPanel(new GridLayout(2, 1));
        var5_9.add(var4_8);
        var5_9.add(var3_7);
        var6_10 = BorderFactory.createTitledBorder("Realm: " + var1_1);
        var6_10.setTitleFont(Utilities.mediumBoldFont);
        this.usersPanel.setBorder(var6_10);
        this.usersPanel.add((Component)new JScrollPane(this.usersList), "Center");
        this.usersPanel.add((Component)var5_9, "South");
        this.usersPanel.validate();
    }

    protected void selectUser(String string) {
        try {
            if (this.realmrrw == null) {
                return;
            }
            this.root.getServerBrowser().setCursor(3);
            this.userrrw = this.realmrrw.getChildResource(string);
            this.userPanel.removeAll();
            this.userPanel.invalidate();
            TitledBorder titledBorder = BorderFactory.createTitledBorder("User: " + string);
            titledBorder.setTitleFont(Utilities.mediumBoldFont);
            this.userPanel.setBorder(titledBorder);
            AttributesHelper attributesHelper = new AttributesHelper();
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Properties properties = propertyManager.getEditorProperties(this.userrrw);
            attributesHelper.initialize(this.userrrw, properties);
            JButton jButton = new JButton("Delete user " + string);
            jButton.setMargin(Utilities.insets0);
            jButton.setActionCommand(DEL_USER_AC);
            jButton.addActionListener(this.al);
            this.userPanel.add(attributesHelper.getComponent(), "Center");
            this.userPanel.add((Component)jButton, "South");
            this.userPanel.validate();
            this.root.getServerBrowser().setCursor(0);
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }
}

