/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.jigadmin.editors.MyHTMLEditorKit;
import org.w3c.jigadmin.widgets.ClosableFrame;
import org.w3c.tools.widgets.Utilities;

public class MiniBrowser
extends ClosableFrame {
    private static MiniBrowser mbrowser = null;
    private Vector prevurls = null;
    private Vector nexturls = null;
    protected static final String NEXT_AC = "next";
    protected static final String PREV_AC = "prev";
    protected static final String TEXT_AC = "text";
    protected JLabel statusBar = null;
    protected JTextField urlField = null;
    protected JEditorPane editor = null;
    protected JButton next_B = null;
    protected JButton prev_B = null;
    protected History history = null;
    protected URL currentURL = null;
    HyperlinkListener hll = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ENTERED) {
                MiniBrowser.this.editor.setCursor(Cursor.getPredefinedCursor(12));
                MiniBrowser.this.statusBar.setText(hyperlinkEvent.getURL().toString());
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                MiniBrowser.this.editor.setCursor(Cursor.getDefaultCursor());
                MiniBrowser.this.statusBar.setText(" ");
            } else {
                try {
                    if (MiniBrowser.this.currentURL != null) {
                        MiniBrowser.this.history.add(MiniBrowser.this.currentURL);
                    }
                    MiniBrowser.this.setPage(hyperlinkEvent.getURL());
                    if (MiniBrowser.this.urlField != null) {
                        MiniBrowser.this.urlField.setText(hyperlinkEvent.getURL().toString());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    };
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                String string;
                block10: {
                    block8: {
                        string = actionEvent.getActionCommand();
                        if (!string.equals(MiniBrowser.PREV_AC)) break block8;
                        try {
                            MiniBrowser.this.setPage((URL)MiniBrowser.this.history.getPrev(MiniBrowser.this.currentURL));
                        }
                        catch (NoSuchElementException noSuchElementException) {
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        break block9;
                    }
                    if (!string.equals(MiniBrowser.NEXT_AC)) break block10;
                    try {
                        MiniBrowser.this.setPage((URL)MiniBrowser.this.history.getNext(MiniBrowser.this.currentURL));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break block9;
                }
                if (!string.equals(MiniBrowser.TEXT_AC)) break block9;
                MiniBrowser.this.history.add(MiniBrowser.this.currentURL);
                try {
                    MiniBrowser.this.setPage(MiniBrowser.this.urlField.getText());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    };

    public MiniBrowser(String string) throws MalformedURLException, IOException {
        super(string);
        this.history = new History();
        this.build("");
    }

    public MiniBrowser(String string, String string2) throws MalformedURLException, IOException {
        super(string2);
        this.history = new History();
        this.build(string);
        this.setPage(string);
    }

    protected void build(String string) {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.prev_B = new JButton("Prev");
        this.prev_B.setActionCommand(PREV_AC);
        this.prev_B.addActionListener(this.al);
        this.prev_B.setEnabled(false);
        this.next_B = new JButton("Next");
        this.next_B.setActionCommand(NEXT_AC);
        this.next_B.addActionListener(this.al);
        this.next_B.setEnabled(false);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.prev_B);
        jPanel.add(this.next_B);
        this.urlField = new JTextField(40);
        this.urlField.setActionCommand(TEXT_AC);
        this.urlField.addActionListener(this.al);
        this.urlField.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel jLabel = new JLabel("  Location:");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.urlField, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.setBorder(BorderFactory.createRaisedBevelBorder());
        this.statusBar = new JLabel(string);
        this.statusBar.setFont(Utilities.smallFont);
        this.statusBar.setBorder(BorderFactory.createRaisedBevelBorder());
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setEditorKitForContentType("text/html", new MyHTMLEditorKit());
        this.editor.addHyperlinkListener(this.hll);
        container.add((Component)jPanel3, "North");
        container.add((Component)new JScrollPane(this.editor), "Center");
        container.add((Component)this.statusBar, "South");
    }

    protected void close() {
        mbrowser = null;
    }

    public static void main(String[] stringArray) {
        try {
            MiniBrowser miniBrowser = null;
            miniBrowser = stringArray.length > 0 ? new MiniBrowser(stringArray[0], "Mini Browser") : new MiniBrowser("Mini Browser");
            miniBrowser.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)miniBrowser).setSize(600, 600);
            ((Component)miniBrowser).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setPage(String string) throws MalformedURLException, IOException {
        this.currentURL = new URL(string);
        this.editor.setPage(this.currentURL);
        this.urlField.setText(string);
    }

    public void setPage(URL uRL) throws IOException {
        this.currentURL = uRL;
        this.editor.setPage(uRL);
        this.urlField.setText(uRL.toExternalForm());
    }

    public static void showDocumentationURL(String string, String string2) throws MalformedURLException, IOException {
        if (mbrowser == null) {
            mbrowser = new MiniBrowser(string, string2);
            ((Component)mbrowser).setSize(600, 600);
            ((Component)mbrowser).setVisible(true);
        } else {
            MiniBrowser.mbrowser.history.add(MiniBrowser.mbrowser.currentURL);
            mbrowser.setPage(string);
        }
    }

    class History {
        private Vector prevurls = new Vector(10);
        private Vector nexturls = new Vector(10);

        History() {
        }

        protected synchronized void add(Object object) {
            this.prevurls.addElement(object);
            this.nexturls.clear();
            MiniBrowser.this.prev_B.setEnabled(true);
            MiniBrowser.this.next_B.setEnabled(false);
        }

        protected synchronized Object getNext(Object object) throws NoSuchElementException {
            Object e = this.nexturls.lastElement();
            this.nexturls.removeElementAt(this.nexturls.size() - 1);
            this.prevurls.addElement(object);
            MiniBrowser.this.prev_B.setEnabled(true);
            if (this.nexturls.size() > 0) {
                MiniBrowser.this.next_B.setEnabled(true);
            } else {
                MiniBrowser.this.next_B.setEnabled(false);
            }
            return e;
        }

        protected synchronized Object getPrev(Object object) throws NoSuchElementException {
            Object e = this.prevurls.lastElement();
            this.prevurls.removeElementAt(this.prevurls.size() - 1);
            this.nexturls.addElement(object);
            if (this.prevurls.size() > 0) {
                MiniBrowser.this.prev_B.setEnabled(true);
            } else {
                MiniBrowser.this.prev_B.setEnabled(false);
            }
            MiniBrowser.this.next_B.setEnabled(true);
            return e;
        }
    }
}

