/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.micp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.w3c.www.protocol.http.micp.MICPMessage;
import org.w3c.www.protocol.http.micp.MICPReadWrite;
import org.w3c.www.protocol.http.micp.Stats;

class MICPReader
extends Thread {
    InetAddress addr = null;
    int port = -1;
    Stats stats = null;
    MulticastSocket socket = null;
    MICPReadWrite micprw = new MICPReadWrite();

    MICPReader(InetAddress inetAddress, int n, Stats stats) throws UnknownHostException, IOException {
        this.addr = inetAddress;
        this.port = n;
        this.stats = stats;
        this.socket = new MulticastSocket(n);
        this.socket.joinGroup(inetAddress);
        this.setName("mICP listener");
        this.start();
    }

    public void run() {
        byte[] byArray = new byte[4096];
        MICPMessage mICPMessage = new MICPMessage();
        while (true) {
            try {
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    this.socket.receive(datagramPacket);
                    this.micprw.decode(datagramPacket.getData(), datagramPacket.getLength(), mICPMessage);
                    this.stats.handle(mICPMessage.op, mICPMessage.url);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }
}

