/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache.push;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.w3c.www.protocol.http.cache.push.PushCacheProtocol;

public class Client {
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int FAILED = -1;
    public static final int MAX_TRIES = 10;
    public static final String DEFAULT_SERVER = "localhost";
    public static final String VC_REVISION = "$Revision: 1.2 $";
    public static final String VC_ID = "$Id: Client.java,v 1.2 2001/10/05 08:07:52 ylafon Exp $";
    private int _verbose = 0;
    private int _port = -1;
    private String _host_name = "";
    private byte[] _buffer = null;
    private byte[] _text_buffer = null;
    private Socket _socket = null;
    private InputStream _in = null;
    private OutputStream _out = null;
    private DataInputStream _data_stream = null;
    private ByteArrayOutputStream _baos = null;
    private DataOutputStream _dos = null;
    private int _reply_com = -1;
    private String _reply_command;

    public Client() {
        this._host_name = DEFAULT_SERVER;
        this._port = 9876;
    }

    public Client(String string, int n) {
        this._host_name = string;
        this._port = n;
    }

    public Client(String[] stringArray) throws IOException {
        this.handleArgs(stringArray);
    }

    public void add(String string, String string2) throws IOException, IllegalArgumentException {
        if (string2 == null || string2.length() == 0 || string == null || string.length() == 0) {
            throw new IllegalArgumentException("Zero length path or url");
        }
        this.connect();
        this.writeHeader();
        this._dos.writeBytes("ADD\u0000");
        this._dos.writeInt(string2.length() + string.length() + 10);
        this._dos.writeInt(string.length() + 1);
        this._dos.writeInt(string2.length() + 1);
        this._dos.writeBytes(String.valueOf(string) + "\u0000");
        this._dos.writeBytes(String.valueOf(string2) + "\u0000");
        this._baos.writeTo(this._out);
        this.readReply();
        switch (this._reply_com) {
            case 0: {
                this.serverError();
                break;
            }
            default: {
                this.unexpectedReply();
            }
            case 6: 
        }
    }

    protected void checkCommand(String string) throws IllegalArgumentException {
        if (string.length() != 4) {
            throw new IllegalArgumentException("Command \"" + string + "\" is wrong length");
        }
        if (string.charAt(3) != '\u0000') {
            throw new IllegalArgumentException("Command \"" + string + "\" is not null terminated");
        }
    }

    public void clean() throws IOException {
        this.simpleCommand("CLN\u0000");
    }

    protected void cleanup() {
        try {
            if (this._in != null) {
                this._in.close();
                this._in = null;
            }
            if (this._out != null) {
                this._out.close();
                this._out = null;
            }
            if (this._socket != null) {
                this._socket.close();
                this._socket = null;
            }
        }
        catch (IOException iOException) {}
    }

    protected void connect() throws UnknownHostException, IOException {
        int n = 0;
        while (this._socket == null) {
            try {
                this._socket = new Socket(this._host_name, this._port);
                this._in = this._socket.getInputStream();
                this._out = this._socket.getOutputStream();
            }
            catch (ConnectException connectException) {
                System.err.println("Failed to connect to " + this._host_name + " on port " + this._port + ": " + connectException.getMessage());
                if (++n > 10) {
                    throw new ConnectException("Failed to connect to " + this._host_name + " on port " + this._port + " after " + 10 + " attempts:\n" + connectException);
                }
                System.err.println("Retrying....");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void del(String string) throws IOException {
        this.urlCommand("DEL\u0000", string);
        this.readReply();
        switch (this._reply_com) {
            case 0: {
                this.serverError();
                break;
            }
            default: {
                this.unexpectedReply();
            }
            case 6: 
        }
    }

    protected void handleArgs(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-' || stringArray[n].length() != 2) {
                bl2 = true;
                break;
            }
            char c = stringArray[n].charAt(1);
            switch (c) {
                case 'c': {
                    if (n == stringArray.length - 1) {
                        System.err.println("Missing argument for -" + c);
                        bl2 = true;
                        break;
                    }
                    string3 = String.valueOf(stringArray[++n].toUpperCase()) + "\u0000";
                    bl = true;
                    break;
                }
                case 'u': {
                    if (n == stringArray.length - 1) {
                        System.err.println("Missing argument for -" + c);
                        bl2 = true;
                        break;
                    }
                    string = stringArray[++n];
                    break;
                }
                case 'p': {
                    if (n == stringArray.length - 1) {
                        System.err.println("Missing argument for -" + c);
                        bl2 = true;
                        break;
                    }
                    string2 = stringArray[++n];
                    break;
                }
                case 's': {
                    if (n == stringArray.length - 1) {
                        System.err.println("Missing argument for -" + c);
                        bl2 = true;
                        break;
                    }
                    this._host_name = stringArray[++n];
                    break;
                }
                case 'P': {
                    if (n == stringArray.length - 1) {
                        System.err.println("Missing argument for -" + c);
                        bl2 = true;
                        break;
                    }
                    try {
                        this._port = Integer.parseInt(stringArray[++n]);
                    }
                    catch (Exception exception) {
                        System.err.println("Invalid port number \"" + stringArray[n] + "\"");
                        this._port = -1;
                        bl2 = true;
                    }
                    break;
                }
                case 'v': {
                    ++this._verbose;
                    break;
                }
                case 'h': {
                    this.usage();
                    System.exit(0);
                }
                case 'V': {
                    this.version();
                    System.exit(0);
                }
                default: {
                    bl2 = true;
                }
            }
            ++n;
        }
        if (!bl) {
            System.err.println("No command specified");
            bl2 = true;
        }
        if (bl2) {
            this.usage();
            System.exit(-1);
        }
        if (this._port == -1) {
            this._port = 9876;
        }
        if (this._host_name.length() == 0) {
            this._host_name = DEFAULT_SERVER;
        }
        int n2 = 0;
        try {
            switch (PushCacheProtocol.instance().parseCommand(string3)) {
                case 1: {
                    this.add(string2, string);
                    break;
                }
                case 2: {
                    this.del(string);
                    break;
                }
                case 4: {
                    if (!this.isPresent(string)) {
                        n2 = 1;
                    }
                    break;
                }
                default: {
                    this.simpleCommand(string3);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            this.usage();
            n2 = -1;
        }
        this.sendBye();
        System.exit(n2);
    }

    public boolean isPresent(String string) throws IOException {
        this.urlCommand("PRS\u0000", string);
        this.readReply();
        switch (this._reply_com) {
            case 6: {
                if (this._verbose > 0) {
                    System.err.println(String.valueOf(string) + " is present");
                }
                return true;
            }
            case 7: {
                if (this._verbose > 0) {
                    System.err.println(String.valueOf(string) + " is not present");
                }
                return false;
            }
            case 0: {
                this.serverError();
                break;
            }
            default: {
                this.unexpectedReply();
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            Client client = new Client(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void nop() throws IOException {
        this.simpleCommand("NOP\u0000");
    }

    protected void readPayload() throws IOException {
        this._data_stream.skipBytes(4);
        int n = this._data_stream.readInt();
        if (n == 0) {
            return;
        }
        this._text_buffer = new byte[n];
        int n2 = 0;
        int n3 = n;
        n2 = 0;
        n3 = n;
        int n4 = -1;
        while (n3 > 0) {
            n4 = this._in.read(this._text_buffer, n2, n3);
            if (n4 < 0) {
                throw new IOException("read returned " + n4);
            }
            n2 += n4;
            n3 -= n4;
        }
        this._data_stream = new DataInputStream(new ByteArrayInputStream(this._text_buffer));
    }

    protected void readReply() throws IOException {
        this._buffer = new byte[16];
        int n = this._in.read(this._buffer);
        if (n < 0) {
            throw new IOException("read returned " + n);
        }
        if (n < 16) {
            throw new IOException("read returned less than PACKET_LEN bytes " + n);
        }
        if (!PushCacheProtocol.instance().isValidProtocolTag(this._buffer)) {
            throw new IOException("Bad protocol tag");
        }
        this._data_stream = new DataInputStream(new ByteArrayInputStream(this._buffer));
        this._data_stream.skipBytes(4);
        short s = this._data_stream.readShort();
        short s2 = this._data_stream.readShort();
        if (s != 1 || s2 > 2) {
            throw new IOException("Bad protocol version");
        }
        this._reply_command = new String(this._buffer, 8, 4);
        this._reply_com = PushCacheProtocol.instance().parseCommand(this._reply_command);
        this.readPayload();
    }

    public void sendBye() throws IOException {
        if (this._out != null) {
            this.writeHeader();
            this._dos.writeBytes("BYE\u0000");
            this._dos.writeInt(0);
            this._baos.writeTo(this._out);
            this.cleanup();
        }
    }

    protected void serverError() throws IOException {
        this.cleanup();
        throw new IOException("Recieved error message from server:\n" + new String(this._text_buffer));
    }

    public void simpleCommand(String string) throws IOException {
        this.checkCommand(string);
        this.connect();
        this.writeHeader();
        this._dos.writeBytes(string);
        this._dos.writeInt(0);
        this._baos.writeTo(this._out);
        this.readReply();
        switch (this._reply_com) {
            case 0: {
                this.serverError();
                break;
            }
            default: {
                this.unexpectedReply();
            }
            case 6: 
        }
    }

    protected void unexpectedReply() throws IOException {
        this.sendBye();
        throw new IOException("Unexpected reply from server " + this._reply_command);
    }

    public void urlCommand(String string, String string2) throws IOException, IllegalArgumentException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Zero length url");
        }
        this.checkCommand(string);
        this.connect();
        this.writeHeader();
        this._dos.writeBytes(string);
        this._dos.writeInt(string2.length() + 1);
        this._dos.writeBytes(String.valueOf(string2) + "\u0000");
        this._baos.writeTo(this._out);
    }

    protected void usage() {
        System.err.println("Usage: -c <command> [-u <url>] [ -p <path>] [ -s <server>] [ -P <port> ] [ -v ] [ -h ] [ -V ]\n\t-s\t\t connect to specified server, default is localhost.\n\t-P\t\t connect to specified port, default is 9876.\n\t-v\t\t verbose operation, repeat for more verbosity.\n\t-h\t\t show this help message.\n\t-V\t\t show version information.\n\nCommands recognised:\n\tADD\t\t add <path> to cache as if downloaded from <url>.\n\tDEL\t\t delete <url> from cache.\n\tPRS\t\t check if <url> is present in cache.\n\tCLN\t\t clean cache.\n\tNOP\t\t do nothing.\n\nNotes:\n\tURLs should be fully qualified including trailing slashes\n\tfor directories, e.g.:\n\t\thttp://www.fantastic.com/\n\trather than:\n\t\thttp://www.fantastic.com\n\n\tBy default the operation of the PRS command is silent, \n\tuse the -v flag to display a text message indicating the\n\tpresence of a URL in the cache.\n\n\tWhen ADDing a file only the <path> is sent to the server\n\tNOT the contents of the file, this means that files can\n\tbe added to remote caches only if the client and server\n\tshare a file system via NFS or similar.\n\nExit Value:\n\tThis program exits with one of the following values:\n\t0\t OK, command successful (PRS: URL present)\n\t1\t (PRS only) command successful, URL not present\n\t255\t command unsuccessful\n");
    }

    protected void version() {
        System.err.println("Jigsaw Push Cache Java Client 1.0 by Paul Henshaw, The Fantastic Corporation\n$Revision: 1.2 $\n$Id: Client.java,v 1.2 2001/10/05 08:07:52 ylafon Exp $\n");
    }

    protected void writeHeader() throws IOException {
        this._baos = new ByteArrayOutputStream();
        this._dos = new DataOutputStream(this._baos);
        this._dos.write(PushCacheProtocol.instance().header(), 0, PushCacheProtocol.instance().header().length);
    }
}

