/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.protocol.http.ConnectedEvent;
import org.w3c.www.protocol.http.ContinueEvent;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.HttpMuxConnection;
import org.w3c.www.protocol.http.HttpServer;
import org.w3c.www.protocol.http.HttpServerState;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestEvent;
import org.w3c.www.protocol.http.RequestObserver;

public class HttpMuxServer
extends HttpServer {
    private static final String PROTOCOL = "http|mux";
    protected HttpMuxConnection conn = null;
    protected HttpManager manager = null;
    protected String host = null;
    protected int port = -1;
    protected int timeout = 300000;

    protected synchronized void acquireConnection() throws IOException {
        if (this.conn != null) {
            return;
        }
        this.conn = new HttpMuxConnection(this, this.host, this.port);
        if (this.conn.incrUseCount()) {
            this.manager.notifyUse(this.conn);
        }
    }

    public synchronized void deleteConnection(HttpConnection httpConnection) {
        httpConnection.close();
        httpConnection = null;
    }

    public short getMajorVersion() {
        return 1;
    }

    public short getMinorVersion() {
        return 1;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public void initialize(HttpManager httpManager, HttpServerState httpServerState, String string, int n, int n2) {
        this.state = httpServerState;
        this.manager = httpManager;
        this.host = string;
        this.port = n;
        this.timeout = n2;
    }

    protected void interruptRequest(Request request) {
        System.out.println("HttpMuxConnection.interruptRequest: not implemented.");
    }

    protected boolean isTwoStage(Request request) {
        return request.hasOutputStream();
    }

    protected void notifyObserver(RequestObserver requestObserver, Request request, int n) {
        RequestEvent requestEvent = new RequestEvent(this, request, n);
        requestObserver.notifyProgress(requestEvent);
    }

    protected void notifyObserver(RequestObserver requestObserver, RequestEvent requestEvent) {
        requestObserver.notifyProgress(requestEvent);
    }

    protected synchronized void releaseConnection() {
        if (this.conn != null && this.conn.decrUseCount()) {
            this.manager.notifyIdle(this.conn);
        }
    }

    public Reply runRequest(Request request) throws HttpException {
        Reply reply = null;
        MuxSession muxSession = null;
        RequestObserver requestObserver = request.getObserver();
        try {
            try {
                this.acquireConnection();
                muxSession = this.conn.connect(80);
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(muxSession.getOutputStream()));
                MimeParser mimeParser = new MimeParser(muxSession.getInputStream(), this.manager.getReplyFactory());
                if (this.isTwoStage(request)) {
                    request.emit(dataOutputStream, 1);
                    ((OutputStream)dataOutputStream).flush();
                    if (requestObserver != null) {
                        this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, dataOutputStream));
                    }
                    if ((reply = (Reply)mimeParser.parse()).getStatus() / 100 == 1) {
                        if (requestObserver != null) {
                            this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                        }
                        request.emit(dataOutputStream, 12);
                        ((OutputStream)dataOutputStream).flush();
                        reply = (Reply)mimeParser.parse();
                    }
                } else {
                    request.emit(dataOutputStream, 1);
                    ((OutputStream)dataOutputStream).flush();
                    if (requestObserver != null) {
                        this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, dataOutputStream));
                    }
                    reply = (Reply)mimeParser.parse();
                    while (reply.getStatus() / 100 == 1) {
                        if (requestObserver != null) {
                            this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                        }
                        request.emit(dataOutputStream, 12);
                        ((OutputStream)dataOutputStream).flush();
                        reply = (Reply)mimeParser.parse();
                    }
                }
                ((OutputStream)dataOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new HttpException(request, iOException);
            }
            catch (MimeParserException mimeParserException) {
                mimeParserException.printStackTrace();
                throw new HttpException(request, mimeParserException);
            }
            Object var6_9 = null;
            this.releaseConnection();
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.releaseConnection();
            throw throwable;
        }
        return reply;
    }

    public synchronized void setTimeout(int n) {
        this.timeout = n;
    }
}

