/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.util.LRUList;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.SyncLRUList;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeParserFactory;
import org.w3c.www.protocol.http.DebugFilter;
import org.w3c.www.protocol.http.FilterEngine;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpServer;
import org.w3c.www.protocol.http.HttpServerState;
import org.w3c.www.protocol.http.ManagerDescription;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.ReplyFactory;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestFilter;
import org.w3c.www.protocol.http.cookies.CookieFilter;

public class HttpManager
implements PropertyMonitoring {
    private static final boolean debug = false;
    private static final String DEFAULT_SERVER_CLASS = "org.w3c.www.protocol.http.HttpBasicServer";
    public static final String SERVER_CLASS_P = "org.w3c.www.protocol.http.server";
    public static final String FILTERS_PROP_P = "org.w3c.www.protocol.http.filters";
    public static final String CONN_MAX_P = "org.w3c.www.protocol.http.connections.max";
    public static final String TIMEOUT_P = "org.w3c.www.protocol.http.connections.timeout";
    public static final String MAX_STALE_P = "org.w3c.www.protocol.http.cacheControl.maxStale";
    public static final String MIN_FRESH_P = "org.w3c.www.protocol.http.cacheControl.minFresh";
    public static final String ONLY_IF_CACHED_P = "org.w3c.www.protocol.http.cacheControl.onlyIfCached";
    public static final String USER_AGENT_P = "org.w3c.www.protocol.http.userAgent";
    public static final String ACCEPT_P = "org.w3c.www.protocol.http.accept";
    public static final String ACCEPT_LANGUAGE_P = "org.w3c.www.protocol.http.acceptLanguage";
    public static final String ACCEPT_ENCODING_P = "org.w3c.www.protocol.http.acceptEncoding";
    public static final String LENIENT_P = "org.w3c.www.protocol.http.lenient";
    public static final String PROXY_SET_P = "proxySet";
    public static final String PROXY_HOST_P = "proxyHost";
    public static final String PROXY_PORT_P = "proxyPort";
    public static final String DEFAULT_ACCEPT = "*/*";
    public static final String DEFAULT_USER_AGENT = "Jigsaw/2.2.1";
    private static ManagerDescription[] managers = new ManagerDescription[4];
    protected Class serverclass = null;
    ObservableProperties props = null;
    protected Hashtable servers = null;
    protected Request template = new Request(this);
    protected LRUList connectionsLru = null;
    FilterEngine filteng = null;
    protected int timeout = 300000;
    protected int conn_count = 0;
    protected int conn_max = 5;
    protected boolean lenient = true;
    MimeParserFactory factory = null;
    static /* synthetic */ Class class$org$w3c$www$protocol$http$HttpManager;

    protected HttpManager() {
        this.servers = new Hashtable();
        this.filteng = new FilterEngine();
        this.connectionsLru = new SyncLRUList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected boolean closeAnyConnection() {
        boolean bl = false;
        int n = Math.max(this.conn_max / 3, 1);
        int n2 = 0;
        while (n2 < n) {
            HttpConnection httpConnection = (HttpConnection)this.connectionsLru.removeTail();
            if (httpConnection == null) break;
            httpConnection.close();
            this.deleteConnection(httpConnection);
            bl = true;
            ++n2;
        }
        return bl;
    }

    public Request createRequest() {
        return (Request)this.template.getClone();
    }

    protected final synchronized void decrConnCount(HttpServer httpServer) {
        --this.conn_count;
    }

    protected void deleteConnection(HttpConnection httpConnection) {
        HttpServerState httpServerState = httpConnection.getServer().getState();
        httpServerState.deleteConnection(httpConnection);
        HttpManager httpManager = this;
        synchronized (httpManager) {
            --this.conn_count;
            this.notifyAll();
        }
    }

    protected HttpConnection getConnection(HttpServer httpServer) {
        HttpServerState httpServerState = httpServer.getState();
        return httpServerState.getConnection();
    }

    public RequestFilter getGlobalFilter(Class clazz) {
        return this.filteng.getGlobalFilter(clazz);
    }

    public String getGlobalHeader(String string) {
        return this.template.getValue(string);
    }

    public static HttpManager getManager() {
        return HttpManager.getManager(System.getProperties());
    }

    protected static synchronized HttpManager getManager(Class clazz, Properties properties) {
        Object object;
        Object object2;
        int n = 0;
        while (n < managers.length) {
            if (managers[n] != null && managers[n].sameProperties(properties)) {
                return managers[n].getManager();
            }
            ++n;
        }
        ObservableProperties observableProperties = null;
        observableProperties = properties instanceof ObservableProperties ? (ObservableProperties)properties : new ObservableProperties(properties);
        HttpManager httpManager = null;
        try {
            object2 = clazz.newInstance();
            httpManager = object2 instanceof HttpManager ? (HttpManager)object2 : new HttpManager();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            httpManager = new HttpManager();
        }
        httpManager.props = observableProperties;
        object2 = observableProperties.getStringArray(FILTERS_PROP_P, null);
        if (object2 != null) {
            int n2 = 0;
            while (n2 < ((T)object2).length) {
                try {
                    object = Class.forName(object2[n2]);
                    PropRequestFilter propRequestFilter = null;
                    propRequestFilter = (PropRequestFilter)((Class)object).newInstance();
                    propRequestFilter.initialize(httpManager);
                }
                catch (PropRequestFilterException propRequestFilterException) {
                    System.out.println("Couldn't initialize filter \"" + object2[n2] + "\" init failed: " + propRequestFilterException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println("Error initializing prop filters:");
                    System.err.println("Coulnd't initialize [" + object2[n2] + "]: " + exception.getMessage());
                    exception.printStackTrace();
                    System.exit(1);
                }
                ++n2;
            }
        }
        httpManager.factory = httpManager.getReplyFactory();
        String string = observableProperties.getString(SERVER_CLASS_P, DEFAULT_SERVER_CLASS);
        try {
            httpManager.serverclass = Class.forName(string);
        }
        catch (Exception exception) {
            System.err.println("Unable to initialize HttpManager: ");
            System.err.println("Class \"" + string + "\" not found, from property " + SERVER_CLASS_P);
            exception.printStackTrace();
            System.exit(1);
        }
        object = httpManager.template;
        httpManager.updateProxy();
        ((HttpMessage)object).setOnlyIfCached(observableProperties.getBoolean(ONLY_IF_CACHED_P, false));
        int n3 = observableProperties.getInteger(MAX_STALE_P, -1);
        if (n3 >= 0) {
            ((HttpRequestMessage)object).setMaxStale(n3);
        }
        if ((n3 = observableProperties.getInteger(MIN_FRESH_P, -1)) >= 0) {
            ((HttpRequestMessage)object).setMinFresh(n3);
        }
        httpManager.lenient = observableProperties.getBoolean(LENIENT_P, true);
        ((HttpMessage)object).setValue("user-agent", observableProperties.getString(USER_AGENT_P, DEFAULT_USER_AGENT));
        ((HttpMessage)object).setValue("accept", observableProperties.getString(ACCEPT_P, DEFAULT_ACCEPT));
        String string2 = observableProperties.getString(ACCEPT_LANGUAGE_P, null);
        if (string2 != null && string2.trim().length() > 0) {
            ((HttpMessage)object).setValue("accept-language", string2);
        }
        if ((string2 = observableProperties.getString(ACCEPT_ENCODING_P, null)) != null && string2.trim().length() > 0) {
            ((HttpMessage)object).setValue("accept-encoding", string2);
        }
        httpManager.conn_max = observableProperties.getInteger(CONN_MAX_P, 5);
        httpManager.timeout = observableProperties.getInteger(TIMEOUT_P, httpManager.timeout);
        observableProperties.registerObserver(httpManager);
        int n4 = 0;
        while (n4 < managers.length) {
            if (managers[n4] == null) {
                HttpManager.managers[n4] = new ManagerDescription(httpManager, properties);
                return httpManager;
            }
            ++n4;
        }
        ManagerDescription[] managerDescriptionArray = new ManagerDescription[managers.length << 1];
        System.arraycopy(managers, 0, managerDescriptionArray, 0, managers.length);
        managerDescriptionArray[HttpManager.managers.length] = new ManagerDescription(httpManager, properties);
        managers = managerDescriptionArray;
        return httpManager;
    }

    public static synchronized HttpManager getManager(Properties properties) {
        return HttpManager.getManager(class$org$w3c$www$protocol$http$HttpManager != null ? class$org$w3c$www$protocol$http$HttpManager : (class$org$w3c$www$protocol$http$HttpManager = HttpManager.class$("org.w3c.www.protocol.http.HttpManager")), properties);
    }

    public final ObservableProperties getProperties() {
        return this.props;
    }

    public MimeParserFactory getReplyFactory() {
        if (this.factory == null) {
            this.factory = new ReplyFactory();
        }
        return this.factory;
    }

    public final String getServerKey(Request request) {
        URL uRL = request.getProxy();
        URL uRL2 = request.getURL();
        Object var4_4 = null;
        if (uRL != null) {
            return uRL.getPort() == 80 ? uRL.getHost().toLowerCase() : String.valueOf(uRL.getHost().toLowerCase()) + ":" + uRL.getPort();
        }
        return uRL2.getPort() == 80 ? uRL2.getHost().toLowerCase() : String.valueOf(uRL2.getHost().toLowerCase()) + ":" + uRL2.getPort();
    }

    protected final synchronized void incrConnCount(HttpServer httpServer) {
        if (++this.conn_count > this.conn_max) {
            this.closeAnyConnection();
        }
    }

    public boolean isLenient() {
        return this.lenient;
    }

    protected synchronized HttpServer lookupServer(String string, int n) throws HttpException {
        int n2 = n == -1 ? 80 : n;
        String string2 = n2 == 80 ? string.toLowerCase() : String.valueOf(string.toLowerCase()) + ":" + n2;
        HttpServer httpServer = (HttpServer)this.servers.get(string2);
        if (httpServer != null) {
            return httpServer;
        }
        try {
            httpServer = (HttpServer)this.serverclass.newInstance();
        }
        catch (Exception exception) {
            String string3 = "Unable to create an instance of \"" + this.serverclass.getName() + "\", invalid config, check the " + SERVER_CLASS_P + " property.";
            throw new HttpException(exception, string3);
        }
        httpServer.initialize(this, new HttpServerState(httpServer), string, n2, this.timeout);
        this.servers.put(string2, httpServer);
        return httpServer;
    }

    public static void main(String[] stringArray) {
        try {
            HttpManager httpManager = HttpManager.getManager();
            httpManager.setGlobalHeader("User-Agent", "Jigsaw/1.0a");
            httpManager.setGlobalHeader("Accept", "*/*;q=1.0");
            httpManager.setGlobalHeader("Accept-Encoding", "gzip");
            CookieFilter cookieFilter = new CookieFilter();
            cookieFilter.initialize(httpManager);
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.initialize(httpManager);
            Request request = httpManager.createRequest();
            request.setURL(new URL(stringArray[0]));
            request.setMethod("GET");
            Reply reply = httpManager.runRequest(request);
            System.out.println("last-modified: " + reply.getLastModified());
            System.out.println("length       : " + reply.getContentLength());
            InputStream inputStream = reply.getInputStream();
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                System.out.print(new String(byArray, 0, n));
            }
            System.out.println("-");
            inputStream.close();
            httpManager.sync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    protected boolean negotiateConnection(HttpServer httpServer) {
        HttpServerState httpServerState = httpServer.getState();
        if (!this.tooManyConnections()) {
            return true;
        }
        if (httpServerState.notEnoughConnections()) {
            return this.closeAnyConnection();
        }
        if (this.servers.size() > this.conn_max) {
            return this.closeAnyConnection();
        }
        return false;
    }

    protected synchronized void notifyConnection(HttpConnection httpConnection) {
        if (++this.conn_count > this.conn_max) {
            this.closeAnyConnection();
        }
    }

    public synchronized void notifyIdle(HttpConnection httpConnection) {
        this.connectionsLru.toHead(httpConnection);
        HttpServerState httpServerState = httpConnection.getServer().getState();
        httpServerState.registerConnection(httpConnection);
        this.notifyAll();
    }

    public void notifyUse(HttpConnection httpConnection) {
        this.connectionsLru.remove(httpConnection);
    }

    public boolean propertyChanged(String string) {
        Request request = this.template;
        if (string.equals(FILTERS_PROP_P)) {
            return true;
        }
        if (string.equals(TIMEOUT_P)) {
            this.setTimeout(this.props.getInteger(TIMEOUT_P, this.timeout));
            return true;
        }
        if (string.equals(CONN_MAX_P)) {
            this.setMaxConnections(this.props.getInteger(CONN_MAX_P, this.conn_max));
            return true;
        }
        if (string.equals(MAX_STALE_P)) {
            int n = this.props.getInteger(MAX_STALE_P, -1);
            if (n >= 0) {
                request.setMaxStale(n);
            }
            return true;
        }
        if (string.equals(MIN_FRESH_P)) {
            int n = this.props.getInteger(MIN_FRESH_P, -1);
            if (n >= 0) {
                request.setMinFresh(n);
            }
            return true;
        }
        if (string.equals(LENIENT_P)) {
            this.lenient = this.props.getBoolean(ONLY_IF_CACHED_P, this.lenient);
            return true;
        }
        if (string.equals(ONLY_IF_CACHED_P)) {
            request.setOnlyIfCached(this.props.getBoolean(ONLY_IF_CACHED_P, false));
            return true;
        }
        if (string.equals(USER_AGENT_P)) {
            request.setValue("user-agent", this.props.getString(USER_AGENT_P, DEFAULT_USER_AGENT));
            return true;
        }
        if (string.equals(ACCEPT_P)) {
            request.setValue("accept", this.props.getString(ACCEPT_P, DEFAULT_ACCEPT));
            return true;
        }
        if (string.equals(ACCEPT_LANGUAGE_P)) {
            String string2 = this.props.getString(ACCEPT_LANGUAGE_P, null);
            if (string2 != null) {
                request.setValue("accept-language", string2);
            }
            return true;
        }
        if (string.equals(ACCEPT_ENCODING_P)) {
            String string3 = this.props.getString(ACCEPT_ENCODING_P, null);
            if (string3 != null) {
                request.setValue("accept-encoding", string3);
            }
            return true;
        }
        if (string.equals(PROXY_SET_P) || string.equals(PROXY_HOST_P) || string.equals(PROXY_PORT_P)) {
            return this.updateProxy();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public Reply runRequest(Request var1_1) throws HttpException {
        var2_2 = null;
        var3_3 = 0;
        var4_4 = this.filteng.run(var1_1);
        if (var4_4 != null) {
            var5_5 = 0;
            while (var5_5 < var4_4.length) {
                var2_2 = var4_4[var3_3].ingoingFilter(var1_1);
                if (var2_2 != null) break;
                ++var3_3;
                ++var5_5;
            }
        }
        var5_6 = var1_1.getURL();
        if (var2_2 == null) {
            var6_7 = null;
            do {
                var7_8 = false;
                try {
                    block12: {
                        try {
                            var10_10 = var1_1.getProxy();
                            var6_7 = var10_10 != null ? this.lookupServer(var10_10.getHost(), var10_10.getPort()) : this.lookupServer(var5_6.getHost(), var5_6.getPort());
                            var1_1.setServer((HttpServer)var6_7);
                            var2_2 = var6_7.runRequest(var1_1);
                            break block12;
                        }
                        catch (HttpException var10_11) {
                            var11_12 = 0;
                            ** while (var11_12 < var3_3)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var7_8 = var7_8 != false || var4_4[var11_12].exceptionFilter(var1_1, var10_11) != false;
                            ++var11_12;
                            continue;
                        }
lbl30:
                        // 1 sources

                        if (!var7_8) {
                            throw var10_11;
                        }
                    }
                    var9_9 = null;
                    var1_1.unsetServer();
                }
                catch (Throwable var8_13) {
                    var9_9 = null;
                    var1_1.unsetServer();
                    throw var8_13;
                }
            } while (var7_8);
        }
        if (var4_4 != null) {
            while (--var3_3 >= 0) {
                var6_7 = var4_4[var3_3].outgoingFilter(var1_1, var2_2);
                if (var6_7 == null) continue;
                var2_2 = var6_7;
                break;
            }
        }
        return var2_2;
    }

    public void setAllowUserInteraction(boolean bl) {
        this.template.setAllowUserInteraction(bl);
    }

    public void setFilter(RequestFilter requestFilter) {
        this.filteng.setFilter(requestFilter);
    }

    public void setFilter(URL[] uRLArray, URL[] uRLArray2, RequestFilter requestFilter) {
        int n;
        if (uRLArray != null) {
            n = 0;
            while (n < uRLArray.length) {
                this.filteng.setFilter(uRLArray[n], true, requestFilter);
                ++n;
            }
        }
        if (uRLArray2 != null) {
            n = 0;
            while (n < uRLArray2.length) {
                this.filteng.setFilter(uRLArray2[n], false, requestFilter);
                ++n;
            }
        }
    }

    public void setGlobalHeader(String string, String string2) {
        this.template.setValue(string, string2);
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public synchronized void setMaxConnections(int n) {
        this.conn_max = n;
    }

    public void setProxy(URL uRL) {
        this.template.setProxy(uRL);
    }

    public void setRequestTimeout(int n) {
    }

    public synchronized void setTimeout(int n) {
        this.timeout = n;
        Enumeration enumeration = this.servers.elements();
        while (enumeration.hasMoreElements()) {
            ((HttpServer)enumeration.nextElement()).setTimeout(n);
        }
    }

    public void sync() {
        this.filteng.sync();
    }

    protected synchronized boolean tooManyConnections() {
        return this.conn_count >= this.conn_max;
    }

    protected boolean updateProxy() {
        boolean bl = this.props.getBoolean(PROXY_SET_P, false);
        if (bl) {
            String string = this.props.getString(PROXY_HOST_P, null);
            int n = this.props.getInteger(PROXY_PORT_P, -1);
            URL uRL = null;
            try {
                uRL = new URL("http", string, n, "/");
            }
            catch (Exception exception) {
                return false;
            }
            if (uRL != null && uRL.getHost() != null) {
                this.template.setProxy(uRL);
            }
        } else {
            this.template.setProxy(null);
        }
        return true;
    }

    public boolean usingProxy() {
        return this.template.hasProxy();
    }

    protected synchronized void waitForConnection(HttpServer httpServer) throws InterruptedException {
        this.wait();
    }
}

