/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestFilter;
import org.w3c.www.protocol.http.ScopeNode;

class FilterEngine {
    ScopeNode root = new ScopeNode("_root_");

    FilterEngine() {
    }

    synchronized RequestFilter getGlobalFilter(Class clazz) {
        RequestFilter[] requestFilterArray = this.root.filters;
        int n = 0;
        while (n < requestFilterArray.length) {
            if (requestFilterArray[n] != null) {
                Class<?> clazz2 = requestFilterArray[n].getClass();
                while (clazz2 != null) {
                    if (clazz2 == clazz) {
                        return requestFilterArray[n];
                    }
                    clazz2 = clazz2.getSuperclass();
                }
            }
            ++n;
        }
        return null;
    }

    RequestFilter[] run(Request request) {
        String[] stringArray = this.urlParts(request.getURL());
        int n = 0;
        ScopeNode scopeNode = this.root;
        Vector vector = new Vector();
        while (scopeNode != null) {
            scopeNode.resolve(vector);
            if (n >= stringArray.length) break;
            scopeNode = scopeNode.lookup(stringArray[n++]);
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new RequestFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    synchronized void setFilter(URL uRL, boolean bl, RequestFilter requestFilter) {
        String[] stringArray = this.urlParts(uRL);
        ScopeNode scopeNode = this.root;
        int n = 0;
        while (n < stringArray.length) {
            ScopeNode scopeNode2 = scopeNode.lookup(stringArray[n]);
            if (scopeNode2 == null) {
                scopeNode2 = scopeNode.create(stringArray[n]);
            }
            scopeNode = scopeNode2;
            ++n;
        }
        scopeNode.setFilter(bl, requestFilter);
    }

    synchronized void setFilter(RequestFilter requestFilter) {
        this.root.setFilter(true, requestFilter);
    }

    synchronized void sync() {
        this.root.sync();
    }

    private String[] urlParts(URL uRL) {
        Vector<Object> vector = new Vector<Object>(8);
        vector.addElement(uRL.getProtocol());
        if (uRL.getPort() == -1 || uRL.getPort() == 80) {
            vector.addElement(uRL.getHost());
        } else {
            vector.addElement(String.valueOf(uRL.getHost()) + ":" + uRL.getPort());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(uRL.getFile(), "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

