/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.www.mux.MUX;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxWriter;

public class MuxInputStream
extends InputStream
implements MUX {
    private static final boolean debugPush = false;
    protected MuxSession session = null;
    protected MuxWriter writer = null;
    protected byte[] buffer = null;
    protected int bufptr = -1;
    protected int markptr = -1;
    protected int buflen = -1;
    protected boolean closed = false;
    protected int consumed_credit = 0;
    protected int avail_credit = 4096;
    protected boolean pushpending = false;
    protected String errmsg = null;

    protected MuxInputStream(MuxSession muxSession) {
        this.session = muxSession;
        this.writer = muxSession.getMuxStream().getMuxWriter();
        this.buffer = new byte[muxSession.getInputBufferSize()];
        this.bufptr = 0;
        this.buflen = 0;
    }

    private void addCredit(int n) throws IOException {
        this.consumed_credit += n;
        if (this.consumed_credit > this.avail_credit >> 1) {
            this.writer.ctrlSendCredit(this.session.getIdentifier(), this.consumed_credit);
            this.writer.flush();
            this.consumed_credit = 0;
        }
        this.notifyAll();
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            if (this.errmsg != null) {
                throw new IOException(this.errmsg);
            }
            return -1;
        }
        return this.buflen;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.pushpending = false;
        this.notifyAll();
    }

    protected synchronized void error(String string) {
        this.errmsg = string;
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public synchronized void mark(int n) {
        this.markptr = this.bufptr;
    }

    protected synchronized void push(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (this.closed) {
            return;
        }
        int n3 = -1;
        int n4 = -1;
        while (n2 > 0) {
            n3 = this.bufptr + this.buflen;
            n4 = this.buffer.length - n3;
            if (n4 < n2 && this.bufptr > 0) {
                System.arraycopy(this.buffer, this.bufptr, this.buffer, 0, this.buflen);
                if (this.markptr >= 0) {
                    this.markptr = this.markptr >= this.bufptr ? this.markptr - this.bufptr : -1;
                }
                this.bufptr = 0;
                n3 = this.buflen;
                n4 = this.buffer.length - n3;
            }
            while (n4 <= 0) {
                if (this.buflen > 0) {
                    this.notifyAll();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Interrupted read");
                }
                if (this.buflen != 0) {
                    n3 = this.bufptr + this.buflen;
                    n4 = this.buffer.length - n3;
                    continue;
                }
                n3 = 0;
                this.bufptr = 0;
                this.buflen = 0;
                n4 = this.buffer.length;
            }
            if (n2 < n4) {
                System.arraycopy(byArray, n, this.buffer, n3, n2);
                this.buflen += n2;
                n2 = 0;
            } else {
                System.arraycopy(byArray, n, this.buffer, n3, n4);
                n += n4;
                n2 -= n4;
                this.buflen += n4;
            }
            this.pushpending = bl;
            if (this.pushpending) continue;
            this.notifyAll();
        }
    }

    public synchronized int read() throws IOException {
        while (true) {
            if (this.buflen > 0) {
                byte by = this.buffer[this.bufptr++];
                --this.buflen;
                this.addCredit(1);
                return by & 0xFF;
            }
            if (this.closed) {
                if (this.errmsg != null) {
                    throw new IOException(this.errmsg);
                }
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted read.");
            }
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            if (this.buflen > 0 && !this.pushpending) {
                int n3 = Math.min(n2, this.buflen);
                System.arraycopy(this.buffer, this.bufptr, byArray, n, n3);
                this.bufptr += n3;
                this.buflen -= n3;
                this.addCredit(n3);
                return n3;
            }
            if (this.closed) {
                if (this.errmsg != null) {
                    throw new IOException(this.errmsg);
                }
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted read.");
            }
        }
    }

    public synchronized void reset() throws IOException {
        if (this.markptr <= this.bufptr) {
            this.buflen += this.bufptr - this.markptr;
        } else {
            throw new IOException("invalid mark.");
        }
        this.bufptr = this.markptr;
    }
}

