/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.EmptyEnumeration;
import org.w3c.www.http.HTTP;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpBag;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpExt;
import org.w3c.www.http.HttpExtException;
import org.w3c.www.http.HttpExtList;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpSetCookieList;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.http.headerEnumerator;
import org.w3c.www.mime.MimeHeaderHolder;
import org.w3c.www.mime.MimeParser;

public class HttpMessage
implements MimeHeaderHolder,
Cloneable,
HTTP {
    public static final int EMIT_HEADERS = 1;
    public static final int EMIT_BODY = 4;
    public static final int EMIT_FOOTERS = 8;
    public static final int EMIT_ALL = 7;
    public static int H_CACHE_CONTROL = 0;
    public static int H_CONNECTION = 1;
    public static int H_PROXY_CONNECTION = 2;
    public static int H_DATE = 3;
    public static int H_PRAGMA = 4;
    public static int H_TRANSFER_ENCODING = 5;
    public static int H_UPGRADE = 6;
    public static int H_VIA = 7;
    public static int H_PROTOCOL = 8;
    public static int H_PROTOCOL_REQUEST = 9;
    public static int H_PROTOCOL_INFO = 10;
    public static int H_PROTOCOL_QUERY = 11;
    public static int H_SET_COOKIE = 12;
    public static int H_COOKIE = 13;
    public static int H_TRAILER = 14;
    public static int H_MAN_EXT = 15;
    public static int H_OPT_EXT = 16;
    public static int H_CMAN_EXT = 17;
    public static int H_COPT_EXT = 18;
    public static int MAX_HEADERS = 61;
    protected static Hashtable factory = new Hashtable(23);
    protected Dictionary headers = null;
    protected short major = 1;
    protected short minor = 1;
    protected long emitdate = -1L;
    protected ArrayDictionary state = null;
    private int extCurrentNamespace = 10;
    protected HeaderValue[] values = new HeaderValue[MAX_HEADERS];
    protected static HeaderDescription[] descriptors = new HeaderDescription[MAX_HEADERS];

    static {
        HttpMessage.registerHeader("Cache-Control", "org.w3c.www.http.HttpCacheControl", H_CACHE_CONTROL);
        HttpMessage.registerHeader("Connection", "org.w3c.www.http.HttpTokenList", H_CONNECTION);
        HttpMessage.registerHeader("Proxy-Connection", "org.w3c.www.http.HttpTokenList", H_PROXY_CONNECTION);
        HttpMessage.registerHeader("Date", "org.w3c.www.http.HttpDate", H_DATE);
        HttpMessage.registerHeader("Pragma", "org.w3c.www.http.HttpTokenList", H_PRAGMA);
        HttpMessage.registerHeader("Transfer-Encoding", "org.w3c.www.http.HttpTokenList", H_TRANSFER_ENCODING);
        HttpMessage.registerHeader("Upgrade", "org.w3c.www.http.HttpTokenList", H_UPGRADE);
        HttpMessage.registerHeader("Via", "org.w3c.www.http.HttpCaseTokenList", H_VIA);
        HttpMessage.registerHeader("Trailer", "org.w3c.www.http.HttpTokenList", H_TRAILER);
        HttpMessage.registerHeader("Protocol", "org.w3c.www.http.HttpBag", H_PROTOCOL);
        HttpMessage.registerHeader("Protocol-Request", "org.w3c.www.http.HttpBag", H_PROTOCOL_REQUEST);
        HttpMessage.registerHeader("Protocol-Query", "org.w3c.www.http.HttpBag", H_PROTOCOL_QUERY);
        HttpMessage.registerHeader("Protocol-Info", "org.w3c.www.http.HttpBag", H_PROTOCOL_INFO);
        HttpMessage.registerHeader("Set-Cookie", "org.w3c.www.http.HttpSetCookieList", H_SET_COOKIE);
        HttpMessage.registerHeader("Cookie", "org.w3c.www.http.HttpCookieList", H_COOKIE);
        HttpMessage.registerHeader("Man", "org.w3c.www.http.HttpExtList", H_MAN_EXT);
        HttpMessage.registerHeader("Opt", "org.w3c.www.http.HttpExtList", H_OPT_EXT);
        HttpMessage.registerHeader("C-Man", "org.w3c.www.http.HttpExtList", H_CMAN_EXT);
        HttpMessage.registerHeader("C-Opt", "org.w3c.www.http.HttpExtList", H_COPT_EXT);
    }

    public HttpMessage() {
    }

    public HttpMessage(MimeParser mimeParser) {
    }

    public void addConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_CONNECTION);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_CONNECTION, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addNoCache(String string) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.addNoCache(string);
    }

    public void addPragma(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PRAGMA);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_PRAGMA, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addProxyConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PROXY_CONNECTION);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_PROXY_CONNECTION, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addTransferEncoding(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_TRANSFER_ENCODING);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_TRANSFER_ENCODING, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addVia(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_VIA);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string};
            this.setVia(stringArray);
        } else {
            httpTokenList.addToken(string, true);
        }
    }

    public boolean checkNoStore() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkNoStore();
    }

    public boolean checkOnlyIfCached() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkOnlyIfCached();
    }

    public void delState(String string) {
        if (this.state != null) {
            this.state.remove(string);
        }
    }

    public void dump(OutputStream outputStream) {
        try {
            this.emitHeaders(outputStream, 1);
        }
        catch (Exception exception) {}
    }

    public void emit(OutputStream outputStream) throws IOException {
        this.startEmit(outputStream, 7);
        if (this.major > 0) {
            this.emitHeaders(outputStream, 7);
        }
        this.endEmit(outputStream, 7);
    }

    public void emit(OutputStream outputStream, int n) throws IOException {
        this.startEmit(outputStream, n);
        this.emitHeaders(outputStream, n);
        this.endEmit(outputStream, n);
    }

    protected void emitHeaders(OutputStream outputStream, int n) throws IOException {
        String string;
        Object object;
        Object object2;
        Enumeration enumeration;
        int n2;
        Object[] objectArray;
        if ((n & 1) != 1) {
            return;
        }
        this.emitdate = System.currentTimeMillis();
        if (!this.hasHeader(H_DATE)) {
            this.setHeaderValue(H_DATE, (HeaderValue)new HttpDate(true, this.emitdate));
        }
        String[] stringArray = this.getConnection();
        HttpTokenList httpTokenList = null;
        httpTokenList = stringArray != null ? new HttpTokenList(stringArray) : new HttpTokenList(new String[0]);
        HttpExtList httpExtList = this.getHttpCManExtDecl();
        if (httpExtList != null) {
            httpTokenList.addToken("C-Man", false);
            objectArray = httpExtList.getHttpExts();
            n2 = 0;
            while (n2 < objectArray.length) {
                enumeration = objectArray[n2];
                object2 = this.getExtensionHeaders((HttpExt)((Object)enumeration));
                object = ((Dictionary)object2).keys();
                while (object.hasMoreElements()) {
                    string = ((HttpExt)((Object)enumeration)).getRealHeader((String)object.nextElement());
                    httpTokenList.addToken(string, false);
                }
                ++n2;
            }
        }
        if ((httpExtList = this.getHttpCOptExtDecl()) != null) {
            httpTokenList.addToken("C-Opt", false);
            objectArray = httpExtList.getHttpExts();
            n2 = 0;
            while (n2 < objectArray.length) {
                enumeration = objectArray[n2];
                object2 = this.getExtensionHeaders((HttpExt)((Object)enumeration));
                object = ((Dictionary)object2).keys();
                while (object.hasMoreElements()) {
                    string = ((HttpExt)((Object)enumeration)).getRealHeader((String)object.nextElement());
                    httpTokenList.addToken(string, false);
                }
                ++n2;
            }
        }
        if (this.hasHeader("C-Ext")) {
            httpTokenList.addToken("C-Ext", false);
        }
        if ((objectArray = (String[])httpTokenList.getValue()) != null && objectArray.length > 0) {
            this.setHeaderValue(H_CONNECTION, (HeaderValue)httpTokenList);
        }
        if (this.hasHeader("Ext")) {
            this.addNoCache("Ext");
        }
        n2 = 0;
        while (n2 < MAX_HEADERS) {
            enumeration = descriptors[n2];
            object2 = this.values[n2];
            if (object2 instanceof HttpSetCookieList) {
                object = (HttpSetCookieList)object2;
                int n3 = ((HttpSetCookieList)object).length();
                if (n3 == 0) {
                    outputStream.write(((HeaderDescription)((Object)enumeration)).getTitle());
                    outputStream.write(58);
                    outputStream.write(32);
                    object2.emit(outputStream);
                    outputStream.write(13);
                    outputStream.write(10);
                } else {
                    int n4 = 0;
                    while (n4 < n3) {
                        outputStream.write(((HeaderDescription)((Object)enumeration)).getTitle());
                        outputStream.write(58);
                        outputStream.write(32);
                        ((HttpSetCookieList)object).emitCookie(outputStream, n4);
                        outputStream.write(13);
                        outputStream.write(10);
                        ++n4;
                    }
                }
            } else if (object2 != null) {
                outputStream.write(((HeaderDescription)((Object)enumeration)).getTitle());
                outputStream.write(58);
                outputStream.write(32);
                object2.emit(outputStream);
                outputStream.write(13);
                outputStream.write(10);
            }
            ++n2;
        }
        if (this.headers != null) {
            enumeration = this.headers.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (HeaderDescription)factory.get(object2);
                HeaderValue headerValue = (HeaderValue)this.headers.get(object2);
                if (headerValue == null) continue;
                outputStream.write(((HeaderDescription)object).getTitle());
                outputStream.write(58);
                outputStream.write(32);
                headerValue.emit(outputStream);
                outputStream.write(13);
                outputStream.write(10);
            }
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    protected void endEmit(OutputStream outputStream, int n) throws IOException {
    }

    public Enumeration enumerateHeaderDescriptions() {
        return new headerEnumerator(this, false);
    }

    public Enumeration enumerateHeaderDescriptions(boolean bl) {
        return new headerEnumerator(this, bl);
    }

    protected synchronized String generateExtNamespace() {
        return String.valueOf(this.extCurrentNamespace++);
    }

    public String getCManExtHeader(String string, String string2) {
        return this.getExtHeader(this.getHttpCManExtDecl(), string, string2);
    }

    public String getCOptExtHeader(String string, String string2) {
        return this.getExtHeader(this.getHttpCOptExtDecl(), string, string2);
    }

    public HttpCacheControl getCacheControl() {
        HeaderValue headerValue = this.getHeaderValue(H_CACHE_CONTROL);
        return headerValue != null ? (HttpCacheControl)headerValue.getValue() : null;
    }

    public HttpMessage getClone() {
        try {
            HttpMessage httpMessage = (HttpMessage)this.clone();
            httpMessage.values = new HeaderValue[MAX_HEADERS];
            System.arraycopy(this.values, 0, httpMessage.values, 0, MAX_HEADERS);
            if (httpMessage.headers != null) {
                httpMessage.headers = (ArrayDictionary)((ArrayDictionary)this.headers).clone();
            }
            if (httpMessage.state != null) {
                httpMessage.state = (ArrayDictionary)this.state.clone();
            }
            return httpMessage;
        }
        catch (Exception exception) {
            throw new RuntimeException("Clone not supported !");
        }
    }

    public String[] getConnection() {
        HeaderValue headerValue = this.getHeaderValue(H_CONNECTION);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public HttpCookieList getCookie() {
        HeaderValue headerValue = this.getHeaderValue(H_COOKIE);
        return headerValue != null ? (HttpCookieList)headerValue.getValue() : null;
    }

    public long getDate() {
        HeaderValue headerValue = this.getHeaderValue(H_DATE);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public long getEmitDate() {
        return this.emitdate;
    }

    public String getExtHeader(String string, String string2) {
        String string3 = this.getManExtHeader(string, string2);
        if (string3 == null && (string3 = this.getCManExtHeader(string, string2)) == null && (string3 = this.getOptExtHeader(string, string2)) == null) {
            string3 = this.getCOptExtHeader(string, string2);
        }
        return string3;
    }

    private String getExtHeader(HttpExtList httpExtList, String string, String string2) {
        if (httpExtList == null) {
            return null;
        }
        HttpExt httpExt = httpExtList.getHttpExt(string);
        if (httpExt != null) {
            String string3 = String.valueOf(httpExt.getNamespace()) + "-" + string2;
            return this.getValue(string3);
        }
        return null;
    }

    public HttpExtList getExtList(String string) {
        HttpExt httpExt;
        HttpExtList httpExtList = this.getHttpManExtDecl();
        HttpExt httpExt2 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
        if (httpExt == null) {
            httpExtList = this.getHttpCManExtDecl();
            HttpExt httpExt3 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
            if (httpExt == null) {
                httpExtList = this.getHttpOptExtDecl();
                HttpExt httpExt4 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
                if (httpExt == null) {
                    httpExtList = this.getHttpCOptExtDecl();
                    HttpExt httpExt5 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
                    if (httpExt == null) {
                        httpExtList = null;
                    }
                }
            }
        }
        return httpExtList;
    }

    public Dictionary getExtensionHeaders(HttpExt httpExt) {
        ArrayDictionary arrayDictionary = new ArrayDictionary(5, 5);
        if (this.headers != null) {
            Enumeration enumeration = this.headers.keys();
            String string = httpExt.getNamespace();
            if (string == null) {
                return arrayDictionary;
            }
            string = String.valueOf(string) + "-";
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                String string3 = string2.substring(3);
                arrayDictionary.put(string3, this.headers.get(string2));
            }
        }
        return arrayDictionary;
    }

    public final HeaderValue getHeaderValue(int n) {
        return this.values[n];
    }

    public final HeaderValue getHeaderValue(String string) {
        return this.getHeaderValue(string.toLowerCase(), null);
    }

    public HeaderValue getHeaderValue(String string, HeaderValue headerValue) {
        HeaderValue headerValue2 = null;
        HeaderDescription headerDescription = (HeaderDescription)factory.get(string);
        if (headerDescription != null && headerDescription.offset >= 0) {
            headerValue2 = this.values[headerDescription.offset];
        } else if (this.headers != null) {
            headerValue2 = (HeaderValue)this.headers.get(string);
        }
        return headerValue2 == null ? headerValue : headerValue2;
    }

    public HeaderValue getHeaderValue(HeaderDescription headerDescription) {
        if (headerDescription.offset >= 0) {
            return this.values[headerDescription.offset];
        }
        return this.headers != null ? (HeaderValue)this.headers.get(headerDescription.getName()) : null;
    }

    public HttpExtList getHttpCManExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_CMAN_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(1);
        }
        return httpExtList;
    }

    public HttpExtList getHttpCOptExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_COPT_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(3);
        }
        return httpExtList;
    }

    public HttpExtList getHttpManExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_MAN_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(0);
        }
        return httpExtList;
    }

    public HttpExtList getHttpOptExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_OPT_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(2);
        }
        return httpExtList;
    }

    public short getMajorVersion() {
        return this.major;
    }

    public String getManExtHeader(String string, String string2) {
        return this.getExtHeader(this.getHttpManExtDecl(), string, string2);
    }

    public int getMaxAge() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getMaxAge();
    }

    public short getMinorVersion() {
        return this.minor;
    }

    public String[] getNoCache() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? null : httpCacheControl.getNoCache();
    }

    public String getOptExtHeader(String string, String string2) {
        return this.getExtHeader(this.getHttpOptExtDecl(), string, string2);
    }

    public String[] getPragma() {
        HeaderValue headerValue = this.getHeaderValue(H_PRAGMA);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public HttpBag getProtocol() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public HttpBag getProtocolInfo() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL_INFO);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public HttpBag getProtocolQuery() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL_QUERY);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public HttpBag getProtocolRequest() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL_REQUEST);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public String[] getProxyConnection() {
        HeaderValue headerValue = this.getHeaderValue(H_PROXY_CONNECTION);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public int getSMaxAge() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getSMaxAge();
    }

    public HttpSetCookieList getSetCookie() {
        HeaderValue headerValue = this.getHeaderValue(H_SET_COOKIE);
        return headerValue != null ? (HttpSetCookieList)headerValue.getValue() : null;
    }

    public Object getState(String string) {
        return this.state == null ? null : this.state.get(string);
    }

    public Enumeration getStateNames() {
        return this.state != null ? this.state.keys() : new EmptyEnumeration();
    }

    public String[] getTrailer() {
        HeaderValue headerValue = this.getHeaderValue(H_TRAILER);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String[] getTransferEncoding() {
        HeaderValue headerValue = this.getHeaderValue(H_TRANSFER_ENCODING);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String[] getUpgrade() {
        HeaderValue headerValue = this.getHeaderValue(H_UPGRADE);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String getValue(String string) {
        HeaderValue headerValue = this.getHeaderValue(string);
        return headerValue != null ? headerValue.toExternalForm() : null;
    }

    public String getValue(HeaderDescription headerDescription) {
        HeaderValue headerValue = this.getHeaderValue(headerDescription);
        return headerValue == null ? null : headerValue.toString();
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public String getVersion() {
        switch (this.major) {
            case 0: {
                switch (this.minor) {
                    case 9: {
                        return "HTTP/0.9";
                    }
                    default: {
                        return "HTTP/" + this.major + "." + this.minor;
                    }
                }
            }
            case 1: {
                switch (this.minor) {
                    case 0: {
                        return "HTTP/1.0";
                    }
                    case 1: {
                        return "HTTP/1.1";
                    }
                }
                return "HTTP/" + this.major + "." + this.minor;
            }
        }
        return "HTTP/" + this.major + "." + this.minor;
    }

    public String[] getVia() {
        HeaderValue headerValue = this.getHeaderValue(H_VIA);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public boolean hasConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_CONNECTION);
        return httpTokenList == null ? false : httpTokenList.hasToken(string, false);
    }

    public boolean hasHeader(int n) {
        return this.values[n] != null;
    }

    public boolean hasHeader(String string) {
        return this.getHeaderValue(string) != null;
    }

    public boolean hasPragma(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PRAGMA);
        return httpTokenList != null ? httpTokenList.hasToken(string, false) : false;
    }

    public boolean hasProxyConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PROXY_CONNECTION);
        return httpTokenList == null ? false : httpTokenList.hasToken(string, false);
    }

    public boolean hasState(String string) {
        return this.state != null && this.state.get(string) != null;
    }

    public boolean hasTransferEncoding(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_TRANSFER_ENCODING);
        return httpTokenList != null ? httpTokenList.hasToken(string, false) : false;
    }

    public boolean notifyBeginParsing(MimeParser mimeParser) throws HttpParserException, IOException {
        return false;
    }

    public void notifyEndParsing(MimeParser mimeParser) throws HttpParserException, IOException {
    }

    public void notifyHeader(String string, byte[] byArray, int n, int n2) {
        String string2 = string.toLowerCase();
        HeaderValue headerValue = this.getHeaderValue(string2);
        if (headerValue == null) {
            HeaderDescription headerDescription = (HeaderDescription)factory.get(string2);
            if (headerDescription == null) {
                headerValue = new HttpString();
                if (this.headers == null) {
                    this.headers = new ArrayDictionary(5, 5);
                }
                HttpMessage.registerHeader(string, "org.w3c.www.http.HttpString");
                this.headers.put(string2, headerValue);
            } else {
                headerValue = headerDescription.getHolder();
                if (headerDescription.offset >= 0) {
                    this.values[headerDescription.offset] = headerValue;
                } else {
                    if (this.headers == null) {
                        this.headers = new ArrayDictionary(5, 5);
                    }
                    this.headers.put(string2, headerValue);
                }
            }
        }
        headerValue.addBytes(byArray, n, n2);
    }

    public static final void registerExtHeader(String string, String string2) {
        HttpMessage.registerHeader(string, string2);
    }

    protected static final void registerHeader(String string, String string2) {
        HeaderDescription headerDescription = new HeaderDescription(string, string2);
        factory.put(headerDescription.getName(), headerDescription);
    }

    protected static final void registerHeader(String string, String string2, int n) {
        HeaderDescription headerDescription;
        HttpMessage.descriptors[n] = headerDescription = new HeaderDescription(string, string2, n);
        factory.put(headerDescription.getName(), headerDescription);
    }

    public final void removeHeader(int n) {
        if (n >= 0 && n < MAX_HEADERS) {
            this.values[n] = null;
        }
    }

    public void removeHeader(String string) {
        String string2 = string.toLowerCase();
        HeaderDescription headerDescription = (HeaderDescription)factory.get(string2);
        if (headerDescription != null) {
            if (headerDescription.offset >= 0) {
                this.values[headerDescription.offset] = null;
            } else if (this.headers != null) {
                this.headers.remove(string2);
            }
        }
    }

    public void setCacheControl(HttpCacheControl httpCacheControl) {
        this.setHeaderValue(H_CACHE_CONTROL, (HeaderValue)httpCacheControl);
    }

    public void setConnection(String[] stringArray) {
        this.setHeaderValue(H_CONNECTION, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setCookie(HttpCookieList httpCookieList) {
        this.setHeaderValue(H_COOKIE, (HeaderValue)httpCookieList);
    }

    public void setDate(long l) {
        this.setHeaderValue(H_DATE, (HeaderValue)(l == -1L ? null : new HttpDate(true, l)));
    }

    public void setEnd2EndExtensionAcknowledgmentHeader() {
        this.setValue("Ext", "");
    }

    public synchronized void setExtensionHeader(HttpExt httpExt, String string, String string2) {
        if (httpExt.isGenerated()) {
            throw new HttpExtException("This extension Object is already associated to an HttpMessage: " + httpExt.getName());
        }
        String string3 = httpExt.getNamespace();
        if (string3 == null) {
            string3 = this.generateExtNamespace();
            httpExt.setNamespace(string3);
        }
        this.setValue(String.valueOf(string3) + "-" + string, string2);
    }

    public final void setHeaderValue(int n, HeaderValue headerValue) {
        this.values[n] = headerValue;
    }

    public void setHeaderValue(String string, HeaderValue headerValue) {
        String string2 = string.toLowerCase();
        HeaderDescription headerDescription = (HeaderDescription)factory.get(string2);
        if (headerDescription != null && headerDescription.offset >= 0) {
            this.values[headerDescription.offset] = headerValue;
        } else {
            if (this.headers == null) {
                this.headers = new ArrayDictionary(5, 5);
            }
            this.headers.put(string2, headerValue);
        }
    }

    public void setHeaderValue(HeaderDescription headerDescription, HeaderValue headerValue) {
        if (headerDescription.offset >= 0) {
            this.values[headerDescription.offset] = headerValue;
        } else {
            if (this.headers == null) {
                this.headers = new ArrayDictionary(5, 5);
            }
            this.headers.put(headerDescription.getName(), headerValue);
        }
    }

    public void setHopByHopExtensionAcknowledgmentHeader() {
        this.setValue("C-Ext", "");
    }

    public void setHttpCManExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(1);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_CMAN_EXT, (HeaderValue)httpExtList);
    }

    public void setHttpCOptExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(3);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_COPT_EXT, (HeaderValue)httpExtList);
    }

    public void setHttpExtDecl(HttpExtList httpExtList) {
        this.setNamespaces(httpExtList);
        switch (httpExtList.getManOptFlag()) {
            case 0: {
                this.setHeaderValue(H_MAN_EXT, (HeaderValue)httpExtList);
                break;
            }
            case 1: {
                this.setHeaderValue(H_CMAN_EXT, (HeaderValue)httpExtList);
                break;
            }
            case 2: {
                this.setHeaderValue(H_OPT_EXT, (HeaderValue)httpExtList);
                break;
            }
            case 3: {
                this.setHeaderValue(H_COPT_EXT, (HeaderValue)httpExtList);
                break;
            }
            default: {
                this.setHeaderValue(H_MAN_EXT, (HeaderValue)httpExtList);
            }
        }
    }

    public void setHttpManExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(0);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_MAN_EXT, (HeaderValue)httpExtList);
    }

    public void setHttpOptExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(2);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_OPT_EXT, (HeaderValue)httpExtList);
    }

    public void setMaxAge(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (n == -1) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setMaxAge(n);
    }

    protected void setNamespaces(HttpExtList httpExtList) {
        HttpExt[] httpExtArray = httpExtList.getHttpExts();
        int n = 0;
        while (n < httpExtArray.length) {
            if (httpExtArray[n].isGenerated()) {
                throw new HttpExtException("This extension Object is already associated to an HttpMessage: " + httpExtArray[n].getName());
            }
            if (httpExtArray[n].needsHeaders()) {
                httpExtArray[n].setNamespace(this.generateExtNamespace());
            }
            ++n;
        }
    }

    public void setNoCache() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setNoCache();
    }

    public void setNoCache(String[] stringArray) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (stringArray == null) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setNoCache(stringArray);
    }

    public void setNoStore(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (!bl) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setNoStore(bl);
    }

    public void setOnlyIfCached(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (!bl) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setOnlyIfCached(bl);
    }

    public void setPragma(String[] stringArray) {
        this.setHeaderValue(H_PRAGMA, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setProtocol(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL, (HeaderValue)httpBag);
    }

    public void setProtocolInfo(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL_INFO, (HeaderValue)httpBag);
    }

    public void setProtocolQuery(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL_QUERY, (HeaderValue)httpBag);
    }

    public void setProtocolRequest(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL_REQUEST, (HeaderValue)httpBag);
    }

    public void setProxyConnection(String[] stringArray) {
        this.setHeaderValue(H_PROXY_CONNECTION, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setSMaxAge(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setSMaxAge(n);
    }

    public void setSetCookie(HttpSetCookieList httpSetCookieList) {
        this.setHeaderValue(H_SET_COOKIE, (HeaderValue)httpSetCookieList);
    }

    public void setState(String string, Object object) {
        if (object != null) {
            if (this.state == null) {
                this.state = new ArrayDictionary(4, 4);
            }
            this.state.put(string, object);
        } else if (this.state != null) {
            this.state.remove(string);
        }
    }

    public void setTrailer(String[] stringArray) {
        this.setHeaderValue(H_TRAILER, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setTransferEncoding(String[] stringArray) {
        this.setHeaderValue(H_TRANSFER_ENCODING, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setUpgrade(String[] stringArray) {
        this.setHeaderValue(H_UPGRADE, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setValue(String string, String string2) {
        String string3 = string.toLowerCase();
        HeaderDescription headerDescription = null;
        if (string2 == null) {
            headerDescription = (HeaderDescription)factory.get(string3);
            if (headerDescription != null) {
                if (headerDescription.offset >= 0) {
                    this.values[headerDescription.offset] = null;
                } else if (this.headers != null) {
                    this.headers.remove(string3);
                }
            }
            return;
        }
        HeaderValue headerValue = this.getHeaderValue(string3);
        if (headerValue == null) {
            if (headerDescription == null) {
                headerDescription = (HeaderDescription)factory.get(string3);
            }
            if (headerDescription == null) {
                HttpMessage.registerHeader(string, "org.w3c.www.http.HttpString");
                headerValue = new HttpString();
            } else {
                headerValue = headerDescription.getHolder();
            }
        }
        byte[] byArray = new byte[string2.length()];
        string2.getBytes(0, byArray.length, byArray, 0);
        headerValue.setBytes(byArray, 0, byArray.length);
        this.setHeaderValue(string3, headerValue);
    }

    public void setVia(String[] stringArray) {
        this.setHeaderValue(H_VIA, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    protected void startEmit(OutputStream outputStream, int n) throws IOException {
    }
}

