/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.ParseState;

public class HttpEntityTagList
extends BasicValue {
    HttpEntityTag[] etags = null;

    HttpEntityTagList() {
        this.isValid = false;
    }

    HttpEntityTagList(HttpEntityTag[] httpEntityTagArray) {
        this.isValid = true;
        this.etags = httpEntityTagArray;
    }

    public void addTag(HttpEntityTag httpEntityTag) {
        if (this.etags == null) {
            this.etags = new HttpEntityTag[1];
            this.etags[0] = httpEntityTag;
        } else {
            int n = this.etags.length;
            HttpEntityTag[] httpEntityTagArray = new HttpEntityTag[n + 1];
            System.arraycopy(this.etags, 0, httpEntityTagArray, 0, n);
            httpEntityTagArray[n] = httpEntityTag;
            this.etags = httpEntityTagArray;
        }
    }

    public Object getValue() {
        this.validate();
        return this.etags;
    }

    protected void parse() {
        Vector<HttpEntityTag> vector = new Vector<HttpEntityTag>(8);
        ParseState parseState = new ParseState();
        parseState.ioff = 0;
        parseState.bufend = this.raw.length;
        parseState.separator = (byte)44;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            HttpEntityTag httpEntityTag = new HttpEntityTag(this, this.raw, parseState.start, parseState.end);
            vector.addElement(httpEntityTag);
            parseState.prepare();
        }
        this.etags = new HttpEntityTag[vector.size()];
        vector.copyInto(this.etags);
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        if (this.etags != null) {
            int n = 0;
            while (n < this.etags.length) {
                if (n > 0) {
                    httpBuffer.append(',');
                }
                this.etags[n].appendValue(httpBuffer);
                ++n;
            }
            this.raw = httpBuffer.getByteCopy();
            this.roff = 0;
            this.rlen = this.raw.length;
        } else {
            this.raw = new byte[0];
            this.roff = 0;
            this.rlen = 0;
        }
    }
}

