/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpCacheControl
extends BasicValue {
    private static final String[] EMPTY_LIST = new String[0];
    private String[] nocache = null;
    private boolean nostore = false;
    private int maxage = -1;
    private int maxstale = -1;
    private int minfresh = -1;
    private boolean onlyifcached = false;
    private boolean pub = false;
    private String[] priv = null;
    private boolean notransform = false;
    private boolean mustrevalidate = false;
    private boolean proxyrevalidate = false;
    private int s_maxage = -1;
    private static final int NOCACHE = 1;
    private static final int NOSTORE = 2;
    private static final int MAXAGE = 4;
    private static final int MINVERS = 8;
    private static final int ONLYIFCACHED = 16;
    private static final int PUB = 32;
    private static final int PRIV = 64;
    private static final int NOTRANSFORM = 128;
    private static final int MUSTREVALIDATE = 256;
    private static final int PROXYREVALIDATE = 512;
    private static final int MAXSTALE = 1024;
    private static final int MINFRESH = 2048;
    private static final int S_MAXAGE = 4096;
    private int defined = 0;
    private static byte[] bnocache = new byte[]{110, 111, 45, 99, 97, 99, 104, 101};
    private static byte[] bnostore = new byte[]{110, 111, 45, 115, 116, 111, 114, 101};
    private static final byte[] bmaxage = new byte[]{109, 97, 120, 45, 97, 103, 101};
    private static final byte[] bs_maxage = new byte[]{115, 45, 109, 97, 120, 97, 103, 101};
    private static final byte[] bmaxstale = new byte[]{109, 97, 120, 45, 115, 116, 97, 108, 101};
    private static final byte[] bminfresh = new byte[]{109, 105, 110, 45, 102, 114, 101, 115, 104};
    private static final byte[] bonlyifcached = new byte[]{111, 110, 108, 121, 45, 105, 102, 45, 99, 97, 99, 104, 101, 100};
    private static final byte[] bpublic = new byte[]{112, 117, 98, 108, 105, 99};
    private static final byte[] bprivate = new byte[]{112, 114, 105, 118, 97, 116, 101};
    private static final byte[] bnotransform = new byte[]{110, 111, 45, 116, 114, 97, 110, 115, 102, 111, 114, 109};
    private static final byte[] bmustrevalidate = new byte[]{109, 117, 115, 116, 45, 114, 101, 118, 97, 108, 105, 100, 97, 116, 101};
    private static final byte[] bproxyrevalidate = new byte[]{112, 114, 111, 120, 121, 45, 114, 101, 118, 97, 108, 105, 100, 97, 116, 101};

    public HttpCacheControl() {
        this(false);
    }

    HttpCacheControl(boolean bl) {
        this.raw = null;
        this.isValid = bl;
    }

    public void addNoCache(String string) {
        this.validate();
        if (this.checkDirective(1) && this.nocache.length == 0) {
            return;
        }
        if (this.nocache != null) {
            int n = 0;
            while (n < this.nocache.length) {
                if (this.nocache[n].equalsIgnoreCase(string)) {
                    return;
                }
                ++n;
            }
            this.invalidateByteValue();
            String[] stringArray = new String[this.nocache.length + 1];
            System.arraycopy(this.nocache, 0, stringArray, 0, this.nocache.length);
            stringArray[this.nocache.length] = string;
            this.nocache = stringArray;
        } else {
            this.invalidateByteValue();
            this.nocache = new String[1];
            this.nocache[0] = string;
        }
        this.setDirective(1);
    }

    private final boolean checkDirective(int n) {
        return (this.defined & n) != 0;
    }

    public boolean checkMustRevalidate() {
        this.validate();
        return this.mustrevalidate;
    }

    public boolean checkNoStore() {
        this.validate();
        return this.checkDirective(2) ? this.nostore : false;
    }

    public boolean checkNoTransform() {
        this.validate();
        return this.notransform;
    }

    public boolean checkOnlyIfCached() {
        this.validate();
        return this.onlyifcached;
    }

    public boolean checkProxyRevalidate() {
        this.validate();
        return this.proxyrevalidate;
    }

    public boolean checkPublic() {
        this.validate();
        return this.pub;
    }

    public final int getMaxAge() {
        this.validate();
        return this.checkDirective(4) ? this.maxage : -1;
    }

    public int getMaxStale() {
        this.validate();
        return this.checkDirective(1024) ? this.maxstale : -1;
    }

    public int getMinFresh() {
        this.validate();
        return this.checkDirective(2048) ? this.minfresh : -1;
    }

    public String[] getNoCache() {
        this.validate();
        return this.checkDirective(1) ? this.nocache : null;
    }

    public String[] getPrivate() {
        this.validate();
        return this.priv == null ? null : this.priv;
    }

    public final int getSMaxAge() {
        this.validate();
        return this.checkDirective(4096) ? this.s_maxage : -1;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(0);
        parseState.ioff = 0;
        parseState.bufend = this.raw.length;
        parseState.separator = (byte)44;
        parseState.spaceIsSep = false;
        ParseState parseState2 = new ParseState(0);
        parseState2.separator = (byte)61;
        parseState2.spaceIsSep = false;
        HttpParser.unquote(this.raw, parseState);
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            parseState2.bufend = parseState.end;
            parseState2.ioff = parseState.start;
            if (HttpParser.nextItem(this.raw, parseState2) >= 0) {
                int n = parseState2.start;
                int n2 = parseState2.end;
                parseState2.prepare();
                if (HttpParser.nextItem(this.raw, parseState2) >= 0) {
                    this.parseDirective(n, n2, parseState2);
                } else {
                    this.parseDirective(n, n2);
                }
            } else {
                this.parseDirective(parseState.start, parseState.end);
            }
            parseState.prepare();
        }
    }

    private final void parseDirective(int n, int n2) throws HttpParserException {
        if (HttpParser.compare(this.raw, n, n2, bnocache) == 0) {
            this.setDirective(1);
            this.nocache = EMPTY_LIST;
        } else if (HttpParser.compare(this.raw, n, n2, bnostore) == 0) {
            this.setDirective(2);
            this.nostore = true;
        } else if (HttpParser.compare(this.raw, n, n2, bonlyifcached) == 0) {
            this.setDirective(16);
            this.onlyifcached = true;
        } else if (HttpParser.compare(this.raw, n, n2, bpublic) == 0) {
            this.setDirective(32);
            this.pub = true;
        } else if (HttpParser.compare(this.raw, n, n2, bprivate) == 0) {
            this.setDirective(64);
            this.priv = EMPTY_LIST;
        } else if (HttpParser.compare(this.raw, n, n2, bnotransform) == 0) {
            this.setDirective(128);
            this.notransform = true;
        } else if (HttpParser.compare(this.raw, n, n2, bmustrevalidate) == 0) {
            this.setDirective(256);
            this.mustrevalidate = true;
        } else if (HttpParser.compare(this.raw, n, n2, bproxyrevalidate) == 0) {
            this.setDirective(512);
            this.proxyrevalidate = true;
        } else {
            this.error("Unknown or invalid directive: " + new String(this.raw, 0, n, n2));
        }
    }

    private final void parseDirective(int n, int n2, ParseState parseState) throws HttpParserException {
        if (HttpParser.compare(this.raw, n, n2, bmaxage) == 0) {
            parseState.ioff = parseState.start;
            parseState.bufend = parseState.end;
            this.maxage = HttpParser.parseInt(this.raw, parseState);
            this.setDirective(4);
        } else if (HttpParser.compare(this.raw, n, n2, bmaxstale) == 0) {
            parseState.ioff = parseState.start;
            parseState.bufend = parseState.end;
            this.maxstale = HttpParser.parseInt(this.raw, parseState);
            this.setDirective(1024);
        } else if (HttpParser.compare(this.raw, n, n2, bminfresh) == 0) {
            parseState.ioff = parseState.start;
            parseState.bufend = parseState.end;
            this.minfresh = HttpParser.parseInt(this.raw, parseState);
            this.setDirective(2048);
        } else if (HttpParser.compare(this.raw, n, n2, bs_maxage) == 0) {
            parseState.ioff = parseState.start;
            parseState.bufend = parseState.end;
            this.s_maxage = HttpParser.parseInt(this.raw, parseState);
            this.setDirective(4096);
        } else if (HttpParser.compare(this.raw, n, n2, bnocache) == 0) {
            Vector<String> vector = new Vector<String>(8);
            ParseState parseState2 = new ParseState();
            parseState2.ioff = parseState.start;
            parseState2.bufend = parseState.end;
            HttpParser.unquote(this.raw, parseState2);
            while (HttpParser.nextItem(this.raw, parseState2) >= 0) {
                vector.addElement(new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start));
                parseState2.prepare();
            }
            this.nocache = new String[vector.size()];
            vector.copyInto(this.nocache);
            this.setDirective(1);
        } else if (HttpParser.compare(this.raw, n, n2, bprivate) == 0) {
            Vector<String> vector = new Vector<String>(8);
            ParseState parseState3 = new ParseState();
            parseState3.ioff = parseState.start;
            parseState3.bufend = parseState.end;
            HttpParser.unquote(this.raw, parseState3);
            while (HttpParser.nextItem(this.raw, parseState3) >= 0) {
                vector.addElement(new String(this.raw, 0, parseState3.start, parseState3.end - parseState3.start));
                parseState3.prepare();
            }
            this.priv = new String[vector.size()];
            vector.copyInto(this.priv);
            this.setDirective(64);
        } else {
            this.error("Unknown directive " + new String(this.raw, 0, n, n2 - n));
        }
    }

    private final void setDirective(int n) {
        this.defined |= n;
    }

    public void setMaxAge(int n) {
        this.validate();
        if (n == -1) {
            if (this.checkDirective(4)) {
                this.invalidateByteValue();
            }
            this.maxage = -1;
            this.unsetDirective(4);
        } else {
            if (n != this.maxage || !this.checkDirective(4)) {
                this.invalidateByteValue();
            }
            this.setDirective(4);
            this.maxage = n;
        }
    }

    public void setMaxStale(int n) {
        this.validate();
        if (n == -1) {
            if (this.checkDirective(1024)) {
                this.invalidateByteValue();
            }
            this.maxstale = -1;
            this.unsetDirective(1024);
        } else {
            if (n != this.maxstale || !this.checkDirective(1024)) {
                this.invalidateByteValue();
            }
            this.setDirective(1024);
            this.maxstale = n;
        }
    }

    public void setMinFresh(int n) {
        this.validate();
        if (n == -1) {
            if (this.checkDirective(2048)) {
                this.invalidateByteValue();
            }
            this.minfresh = -1;
            this.unsetDirective(2048);
        } else {
            if (n != this.minfresh || !this.checkDirective(2048)) {
                this.invalidateByteValue();
            }
            this.setDirective(2048);
            this.minfresh = n;
        }
    }

    public void setMustRevalidate(boolean bl) {
        this.validate();
        if (!bl) {
            if (this.mustrevalidate) {
                this.invalidateByteValue();
                this.mustrevalidate = false;
            }
            this.unsetDirective(256);
        } else if (!this.mustrevalidate) {
            this.invalidateByteValue();
            this.setDirective(256);
            this.mustrevalidate = true;
        }
    }

    public void setNoCache() {
        this.validate();
        this.setDirective(1);
        this.invalidateByteValue();
    }

    public void setNoCache(String[] stringArray) {
        this.validate();
        if (stringArray == null) {
            if (this.checkDirective(1)) {
                this.invalidateByteValue();
            }
            this.unsetDirective(1);
        } else {
            this.setDirective(1);
            this.nocache = stringArray;
            this.invalidateByteValue();
        }
    }

    public void setNoStore(boolean bl) {
        this.validate();
        if (!bl) {
            if (this.nostore) {
                this.invalidateByteValue();
                this.nostore = false;
            }
            this.unsetDirective(2);
        } else if (!this.nostore) {
            this.invalidateByteValue();
            this.setDirective(2);
            this.nostore = true;
        }
    }

    public void setNoTransform(boolean bl) {
        this.validate();
        if (!bl) {
            if (this.notransform) {
                this.invalidateByteValue();
                this.notransform = false;
            }
            this.unsetDirective(128);
        } else if (!this.notransform) {
            this.invalidateByteValue();
            this.setDirective(128);
            this.notransform = true;
        }
    }

    public void setOnlyIfCached(boolean bl) {
        this.validate();
        if (!bl) {
            if (this.onlyifcached) {
                this.invalidateByteValue();
                this.onlyifcached = false;
            }
            this.unsetDirective(16);
        } else if (!this.onlyifcached) {
            this.invalidateByteValue();
            this.setDirective(16);
            this.onlyifcached = true;
        }
    }

    public void setPrivate(String[] stringArray) {
        this.validate();
        this.invalidateByteValue();
        this.setDirective(64);
        this.priv = stringArray;
    }

    public void setProxyRevalidate(boolean bl) {
        this.validate();
        if (!bl) {
            if (this.proxyrevalidate) {
                this.invalidateByteValue();
                this.proxyrevalidate = false;
            }
            this.unsetDirective(512);
        } else if (!this.proxyrevalidate) {
            this.invalidateByteValue();
            this.setDirective(512);
            this.proxyrevalidate = true;
        }
    }

    public void setPublic(boolean bl) {
        this.validate();
        if (!bl) {
            if (this.pub) {
                this.invalidateByteValue();
                this.pub = false;
            }
            this.unsetDirective(32);
        } else if (!this.pub) {
            this.invalidateByteValue();
            this.setDirective(32);
            this.pub = true;
        }
    }

    public void setSMaxAge(int n) {
        this.validate();
        if (n == -1) {
            if (this.checkDirective(4096)) {
                this.invalidateByteValue();
            }
            this.s_maxage = -1;
            this.unsetDirective(4096);
        } else {
            if (n != this.s_maxage || !this.checkDirective(4096)) {
                this.invalidateByteValue();
            }
            this.setDirective(4096);
            this.s_maxage = n;
        }
    }

    private final void unsetDirective(int n) {
        this.defined &= ~n;
    }

    public void unsetNoCache() {
        this.validate();
        if (this.checkDirective(1)) {
            this.invalidateByteValue();
            this.unsetDirective(1);
            this.nocache = null;
        }
    }

    public void unsetPrivate() {
        this.validate();
        if (this.checkDirective(64)) {
            this.invalidateByteValue();
        }
        this.unsetDirective(64);
        this.priv = null;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        boolean bl = false;
        if (this.checkDirective(1)) {
            if (this.nocache != null) {
                httpBuffer.appendQuoted("no-cache", (byte)61, this.nocache);
            } else {
                httpBuffer.append("no-cache");
            }
            bl = true;
        }
        if (this.checkDirective(2) && this.nostore) {
            httpBuffer.append("no-store");
            bl = true;
        }
        if (this.checkDirective(4) && this.maxage >= 0) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("max-age", (byte)61, this.maxage);
            bl = true;
        }
        if (this.checkDirective(16) && this.onlyifcached) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("only-if-cached");
            bl = true;
        }
        if (this.checkDirective(32) && this.pub) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("public");
            bl = true;
        }
        if (this.checkDirective(64) && this.priv != null) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.appendQuoted("private", (byte)61, this.priv);
            bl = true;
        }
        if (this.checkDirective(128) && this.notransform) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("no-transform");
            bl = true;
        }
        if (this.checkDirective(256) && this.mustrevalidate) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("must-revalidate");
            bl = true;
        }
        if (this.checkDirective(512) && this.proxyrevalidate) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("proxy-revalidate");
            bl = true;
        }
        if (this.checkDirective(1024) && this.maxstale >= 0) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("max-stale", (byte)61, this.maxstale);
            bl = true;
        }
        if (this.checkDirective(2048) && this.minfresh >= 0) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("min-fresh", (byte)61, this.minfresh);
            bl = true;
        }
        if (this.checkDirective(4096) && this.s_maxage >= 0) {
            if (bl) {
                httpBuffer.append(',');
            }
            httpBuffer.append("s_maxage", (byte)61, this.s_maxage);
            bl = true;
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

