/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;

class HttpBuffer {
    private static final int INIT_SIZE = 32;
    byte[] buf = new byte[32];
    int len = 0;
    byte sep = 0;

    HttpBuffer() {
    }

    final void append(byte by) {
        this.ensureCapacity(1);
        this.buf[this.len++] = by;
    }

    final void append(char c) {
        this.append((byte)c);
    }

    void append(double d) {
        this.append(Double.toString(d));
    }

    final void append(int n) {
        this.append((byte)n);
    }

    void append(String string) {
        int n = string.length();
        this.ensureCapacity(n);
        string.getBytes(0, n, this.buf, this.len);
        this.len += n;
    }

    void append(String string, byte by, int n) {
        this.append(string);
        this.append(by);
        this.appendInt(n);
    }

    void append(String string, byte by, String string2) {
        this.append(string);
        this.append(by);
        this.append(string2);
    }

    void append(String string, byte by, String[] stringArray) {
        this.append(string);
        if (stringArray.length > 0) {
            this.append(by);
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    this.append(',');
                }
                this.append(stringArray[n]);
                ++n;
            }
        }
    }

    final void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    void append(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(byArray, n, this.buf, this.len, n2);
        this.len += n2;
    }

    final void appendInt(int n) {
        this.appendInt(n, -1, (byte)0);
    }

    final void appendInt(int n, int n2, byte by) {
        boolean bl = n < 0;
        int n3 = this.len;
        if (!bl) {
            n = -n;
        }
        while (n <= -10) {
            this.append((byte)(48 - n % 10));
            --n2;
            n /= 10;
        }
        this.append((byte)(48 - n));
        --n2;
        if (bl) {
            this.append((byte)45);
            --n2;
        }
        while (--n2 >= 0) {
            this.append(by);
        }
        int n4 = (this.len - n3) / 2;
        int n5 = this.len - 1;
        while (--n4 >= 0) {
            int n6 = n3 + this.len - n5 - 1;
            byte by2 = this.buf[n5];
            this.buf[n5] = this.buf[n6];
            this.buf[n6] = by2;
            --n5;
        }
    }

    void appendQuoted(String string) {
        this.append((byte)34);
        this.append(string);
        this.append((byte)34);
    }

    void appendQuoted(String string, byte by, String string2) {
        this.append(string);
        this.append(by);
        this.append('\"');
        this.append(string2);
        this.append('\"');
    }

    void appendQuoted(String string, byte by, String[] stringArray) {
        this.append(string);
        if (stringArray.length > 0) {
            this.append(by);
            this.append((byte)34);
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    this.append(',');
                }
                this.append(stringArray[n]);
                ++n;
            }
            this.append((byte)34);
        }
    }

    public final void emit(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.len);
    }

    final void ensureCapacity(int n) {
        int n2 = this.len + n;
        if (n2 >= this.buf.length) {
            int n3 = this.buf.length << 1;
            if (n3 < n2) {
                n3 = n2 + 1;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.len);
            this.buf = byArray;
        }
    }

    public byte[] getByteCopy() {
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        return byArray;
    }

    public final byte[] getBytes() {
        return this.buf;
    }

    public final int length() {
        return this.len;
    }

    public final void reset() {
        this.len = 0;
    }

    public String toString() {
        return new String(this.buf, 0, 0, this.len);
    }
}

