/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpAcceptEncoding;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.ParseState;

public class HttpAcceptEncodingList
extends BasicValue {
    HttpAcceptEncoding[] encodings = null;

    HttpAcceptEncodingList() {
        this.isValid = false;
    }

    HttpAcceptEncodingList(HttpAcceptEncoding[] httpAcceptEncodingArray) {
        this.encodings = httpAcceptEncodingArray;
        this.isValid = true;
    }

    public void addEncoding(HttpAcceptEncoding httpAcceptEncoding) {
        if (this.encodings == null) {
            this.encodings = new HttpAcceptEncoding[1];
            this.encodings[0] = httpAcceptEncoding;
        } else {
            int n = this.encodings.length;
            HttpAcceptEncoding[] httpAcceptEncodingArray = new HttpAcceptEncoding[n + 1];
            System.arraycopy(this.encodings, 0, httpAcceptEncodingArray, 0, n);
            httpAcceptEncodingArray[n] = httpAcceptEncoding;
            this.encodings = httpAcceptEncodingArray;
        }
    }

    public Object getValue() {
        this.validate();
        return this.encodings;
    }

    protected void parse() {
        Vector<HttpAcceptEncoding> vector = new Vector<HttpAcceptEncoding>(4);
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.separator = (byte)44;
        parseState.spaceIsSep = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            vector.addElement(new HttpAcceptEncoding(this, this.raw, parseState.start, parseState.end));
            parseState.prepare();
        }
        this.encodings = new HttpAcceptEncoding[vector.size()];
        vector.copyInto(this.encodings);
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        if (this.encodings == null) {
            int n = 0;
            while (n < this.encodings.length) {
                if (n > 0) {
                    httpBuffer.append(',');
                }
                this.encodings[n].appendValue(httpBuffer);
                ++n;
            }
            this.raw = httpBuffer.getByteCopy();
            this.roff = 0;
            this.rlen = this.raw.length;
        } else {
            this.raw = new byte[0];
            this.roff = 0;
            this.rlen = 0;
        }
    }
}

