/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FilenameAttribute;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidParentException;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.SimpleAttribute;

public class FileResource
extends FramedResource {
    protected static int ATTR_FILENAME = -1;
    protected static int ATTR_FILESTAMP = -1;
    protected static int ATTR_FILE_LENGTH = -1;
    protected static int ATTR_FILE_BACKUP = -1;
    protected File file = null;

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.FileResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        simpleAttribute = new FilenameAttribute("filename", (Object)null, 2);
        ATTR_FILENAME = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new DateAttribute("file-stamp", (Object)new Long(-1L), 1);
        ATTR_FILESTAMP = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("file-length", null, 1);
        ATTR_FILE_LENGTH = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("backup", Boolean.FALSE, 2);
        ATTR_FILE_BACKUP = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public long checkContent() {
        File file = this.getFile();
        long l = file.lastModified();
        long l2 = this.getFileStamp();
        if (l2 < 0L || l2 < l) {
            this.updateFileAttributes();
            return this.getLastModified();
        }
        return l2;
    }

    public File getBackupFile() {
        File file = this.getFile();
        String string = file.getName();
        return new File(file.getParent(), String.valueOf(string) + "~");
    }

    public boolean getBackupFlag() {
        return this.getBoolean(ATTR_FILE_BACKUP, false);
    }

    public synchronized File getFile() {
        block12: {
            if (this.file != null) break block12;
            String string = this.getFilename();
            if (string == null) {
                string = this.getIdentifier();
            }
            ResourceReference resourceReference = this.getParent();
            ResourceReference resourceReference2 = null;
            Resource resource = this;
            while (true) {
                Object var7_5;
                try {
                    try {
                        if (resourceReference == null) {
                            throw new InvalidParentException(String.valueOf(resource.getIdentifier()) + " can't find his parent, " + "context : " + resource.getContext());
                        }
                        resource = resourceReference.lock();
                        if (resource instanceof DirectoryResource) {
                            File file = this.file = new File(((DirectoryResource)resource).getDirectory(), string);
                            var7_5 = null;
                            if (resourceReference != null) {
                                resourceReference.unlock();
                            }
                            return file;
                        }
                        resourceReference2 = resource.getParent();
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        invalidResourceException.printStackTrace();
                        File file = null;
                        var7_5 = null;
                        if (resourceReference != null) {
                            resourceReference.unlock();
                        }
                        return file;
                    }
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    if (resourceReference != null) {
                        resourceReference.unlock();
                    }
                    throw throwable;
                }
                var7_5 = null;
                if (resourceReference != null) {
                    resourceReference.unlock();
                }
                resourceReference = resourceReference2;
            }
        }
        return this.file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized File getFile(String string) {
        ResourceReference resourceReference = this.getParent();
        ResourceReference resourceReference2 = null;
        Resource resource = this;
        while (true) {
            Object var7_5;
            block10: {
                File file;
                block9: {
                    try {
                        try {
                            if (resourceReference == null) {
                                File file2 = null;
                                var7_5 = null;
                                if (resourceReference == null) return file2;
                                resourceReference.unlock();
                                return file2;
                            }
                            resource = resourceReference.lock();
                            if (resource instanceof DirectoryResource) {
                                file = new File(((DirectoryResource)resource).getDirectory(), string);
                                break block9;
                            }
                            resourceReference2 = resource.getParent();
                            break block10;
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            invalidResourceException.printStackTrace();
                            File file3 = null;
                            var7_5 = null;
                            if (resourceReference == null) return file3;
                            resourceReference.unlock();
                            return file3;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_5 = null;
                        if (resourceReference != null) {
                            resourceReference.unlock();
                        }
                        throw throwable;
                    }
                }
                var7_5 = null;
                if (resourceReference == null) return file;
                resourceReference.unlock();
                return file;
            }
            var7_5 = null;
            if (resourceReference != null) {
                resourceReference.unlock();
            }
            resourceReference = resourceReference2;
        }
    }

    public int getFileLength() {
        return (Integer)this.getValue(ATTR_FILE_LENGTH, (Object)new Integer(0));
    }

    public long getFileStamp() {
        return this.getLong(ATTR_FILESTAMP, -1L);
    }

    public String getFilename() {
        return (String)this.getValue(ATTR_FILENAME, null);
    }

    public void initialize(Object[] objectArray) {
        ResourceReference resourceReference;
        super.initialize(objectArray);
        this.disableEvent();
        String string = this.getFilename();
        if (string != null && (resourceReference = this.getParent()) != null) {
            try {
                try {
                    Resource resource = resourceReference.lock();
                    this.setValue(Resource.ATTR_URL, (Object)(String.valueOf(resource.getURLPath()) + URLEncoder.encode(this.getIdentifier())));
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                Object var5_5 = null;
                resourceReference.unlock();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                resourceReference.unlock();
                throw throwable;
            }
        }
        this.enableEvent();
    }

    public synchronized boolean newContent(InputStream inputStream) throws IOException {
        Object object;
        File file;
        boolean bl;
        File file2;
        block12: {
            file2 = this.getFile();
            bl = !file2.exists() || file2.length() == 0L;
            String string = file2.getName();
            file = new File(file2.getParent(), "#" + string + "#");
            String string2 = null;
            try {
                try {
                    object = new FileOutputStream(file);
                    byte[] byArray = new byte[4096];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) > 0) {
                        ((FileOutputStream)object).write(byArray, 0, n);
                    }
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {
                    string2 = iOException.getMessage();
                }
                Object var8_12 = null;
                if (string2 == null) break block12;
                file.delete();
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (string2 != null) {
                    file.delete();
                    throw new IOException(string2);
                }
                if (this.getBackupFlag()) {
                    File file3 = this.getBackupFile();
                    if (file3.exists()) {
                        file3.delete();
                    }
                    file2.renameTo(this.getBackupFile());
                }
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
                this.updateFileAttributes();
                throw throwable;
            }
            throw new IOException(string2);
        }
        if (this.getBackupFlag()) {
            object = this.getBackupFile();
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            file2.renameTo(this.getBackupFile());
        }
        if (file2.exists()) {
            file2.delete();
        }
        file.renameTo(file2);
        this.updateFileAttributes();
        return bl;
    }

    public synchronized void setValue(int n, Object object) {
        if (n == Resource.ATTR_IDENTIFIER) {
            File file;
            String string = this.getIdentifier();
            if (this.getFilename() == null && (file = this.getFile(string)) != null && file.exists()) {
                super.setValue(ATTR_FILENAME, (Object)string);
            }
        }
        super.setValue(n, object);
        if (n == ATTR_FILENAME || n == Resource.ATTR_IDENTIFIER) {
            this.file = null;
        }
    }

    public void updateAttributes() {
        long l = this.getFile().lastModified();
        long l2 = this.getLong(ATTR_FILESTAMP, -1L);
        if (l2 < 0L || l2 != l) {
            this.updateFileAttributes();
        }
    }

    public void updateFileAttributes() {
        File file = this.getFile();
        this.setValue(ATTR_FILESTAMP, (Object)new Long(file.lastModified()));
        this.setValue(ATTR_FILE_LENGTH, (Object)new Integer((int)file.length()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean verify() throws MultipleLockException {
        File file = this.getFile();
        if (file.exists()) {
            return true;
        }
        ResourceReference resourceReference = this.getParent();
        ResourceReference resourceReference2 = null;
        Resource resource = null;
        while (true) {
            Object var7_5;
            block13: {
                boolean bl;
                block12: {
                    boolean bl2;
                    block11: {
                        try {
                            try {
                                if (resourceReference == null) {
                                    boolean bl3 = false;
                                    var7_5 = null;
                                    if (resourceReference == null) return bl3;
                                    resourceReference.unlock();
                                    return bl3;
                                }
                                resource = resourceReference.lock();
                                if (resource instanceof DirectoryResource) {
                                    DirectoryResource directoryResource = (DirectoryResource)resource;
                                    if (!directoryResource.getExtensibleFlag()) {
                                        bl2 = false;
                                        break block11;
                                    }
                                    String string = String.valueOf(String.valueOf(file)) + ": deleted, removing the FileResource.";
                                    this.getServer().errlog(this, string);
                                    this.delete();
                                    bl = false;
                                    break block12;
                                }
                                resourceReference2 = resource.getParent();
                                break block13;
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                boolean bl4 = false;
                                var7_5 = null;
                                if (resourceReference == null) return bl4;
                                resourceReference.unlock();
                                return bl4;
                            }
                        }
                        catch (Throwable throwable) {
                            var7_5 = null;
                            if (resourceReference != null) {
                                resourceReference.unlock();
                            }
                            throw throwable;
                        }
                    }
                    var7_5 = null;
                    if (resourceReference == null) return bl2;
                    resourceReference.unlock();
                    return bl2;
                }
                var7_5 = null;
                if (resourceReference == null) return bl;
                resourceReference.unlock();
                return bl;
            }
            var7_5 = null;
            if (resourceReference != null) {
                resourceReference.unlock();
            }
            resourceReference = resourceReference2;
        }
    }
}

