/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.event.StructureChangedEvent;
import org.w3c.tools.resources.indexer.IndexerModule;
import org.w3c.tools.resources.indexer.ResourceIndexer;

public class DirectoryResource
extends ContainerResource {
    protected static int ATTR_DIRECTORY = -1;
    protected static int ATTR_DIRSTAMP = -1;
    protected static int ATTR_INDEXER = -1;
    protected static int ATTR_EXTENSIBLE = -1;

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.DirectoryResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new FileAttribute("directory", null, 9);
        ATTR_DIRECTORY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new DateAttribute("dirstamp", (Object)null, 1);
        ATTR_DIRSTAMP = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new StringAttribute("indexer", null, 2);
        ATTR_INDEXER = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("extensible", Boolean.TRUE, 2);
        ATTR_EXTENSIBLE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public synchronized ResourceReference createDefaultResource(String string) {
        return this.createDefaultResource(string, null);
    }

    protected synchronized ResourceReference createDefaultResource(String string, RequestInterface requestInterface) {
        if (string.equals("..") || string.equals(".") || string.indexOf(92) >= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable(10);
        Resource resource = this.index(string, hashtable, requestInterface);
        ResourceReference resourceReference = null;
        if (resource != null) {
            resourceReference = this.addResource(resource, hashtable);
            this.markModified();
        }
        return resourceReference;
    }

    public ResourceReference createDirectoryResource(String string) {
        ResourceReference resourceReference;
        block17: {
            File file = new File(this.getDirectory(), string);
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (file.exists()) {
                    if (!file.isDirectory()) {
                        bl = false;
                    } else {
                        bl2 = true;
                    }
                } else {
                    file.mkdir();
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) {
                return null;
            }
            resourceReference = this.createDefaultResource(string);
            if (resourceReference == null) {
                if (!bl2) {
                    file.delete();
                }
                return null;
            }
            try {
                try {
                    Resource resource = resourceReference.lock();
                    if (resource instanceof DirectoryResource) break block17;
                    try {
                        resource.delete();
                    }
                    catch (MultipleLockException multipleLockException) {}
                    if (!bl2) {
                        file.delete();
                    }
                    ResourceReference resourceReference2 = null;
                    Object var8_9 = null;
                    resourceReference.unlock();
                    return resourceReference2;
                }
                catch (InvalidResourceException invalidResourceException) {
                    if (!bl2) {
                        file.delete();
                    }
                    ResourceReference resourceReference3 = null;
                    Object var8_10 = null;
                    resourceReference.unlock();
                    return resourceReference3;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                resourceReference.unlock();
                throw throwable;
            }
        }
        Object var8_11 = null;
        resourceReference.unlock();
        return resourceReference;
    }

    public ResourceReference createResource(String string) {
        return this.createResource(string, null);
    }

    public ResourceReference createResource(String string, RequestInterface requestInterface) {
        File file = new File(this.getDirectory(), string);
        boolean bl = false;
        if (!file.exists()) {
            try {
                new RandomAccessFile(file, "rw").close();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            return null;
        }
        ResourceReference resourceReference = this.createDefaultResource(string, requestInterface);
        file.delete();
        return resourceReference;
    }

    public synchronized void delete() throws MultipleLockException {
        this.disableEvent();
        this.setBoolean(ATTR_EXTENSIBLE, false);
        super.delete();
    }

    protected synchronized Enumeration enumerateAllResourceIdentifiers() {
        File file = this.getDirectory();
        if (file != null) {
            DirectoryResource directoryResource = this;
            synchronized (directoryResource) {
                String[] stringArray = file.list();
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (!stringArray[n].equals(".") && !stringArray[n].equals("..") && super.lookup(stringArray[n]) == null) {
                            String string = this.getIndexedName(stringArray[n]);
                            if (string.equals(stringArray[n])) {
                                this.createDefaultResource(stringArray[n]);
                            } else if (super.lookup(string) == null) {
                                this.createDefaultResource(stringArray[n]);
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        return super.enumerateResourceIdentifiers(true);
    }

    public synchronized Enumeration enumerateResourceIdentifiers(boolean bl) {
        File file;
        if (bl && this.getExtensibleFlag() && (file = this.getDirectory()) != null) {
            DirectoryResource directoryResource = this;
            synchronized (directoryResource) {
                long l = file.lastModified();
                if (l > this.getDirStamp()) {
                    String[] stringArray = file.list();
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            if (!stringArray[n].equals(".") && !stringArray[n].equals("..") && super.lookup(stringArray[n]) == null) {
                                String string = this.getIndexedName(stringArray[n]);
                                if (string.equals(stringArray[n])) {
                                    this.createDefaultResource(stringArray[n]);
                                } else if (super.lookup(string) == null) {
                                    this.createDefaultResource(stringArray[n]);
                                }
                            }
                            ++n;
                        }
                    }
                    this.setLong(ATTR_DIRSTAMP, l);
                }
            }
        }
        return super.enumerateResourceIdentifiers(bl);
    }

    public long getDirStamp() {
        return this.getLong(ATTR_DIRSTAMP, -1L);
    }

    public File getDirectory() {
        return (File)this.getValue(ATTR_DIRECTORY, null);
    }

    public boolean getExtensibleFlag() {
        return this.getBoolean(ATTR_EXTENSIBLE, true);
    }

    protected String getIndexedName(String string) {
        ResourceContext resourceContext = this.getContext();
        String string2 = null;
        ResourceReference resourceReference = null;
        ResourceReference resourceReference2 = null;
        while (resourceContext != null) {
            Object var7_6;
            do {
                resourceReference = this.getIndexer(resourceContext);
                resourceContext = resourceContext.getParent();
            } while (resourceReference == resourceReference2 && resourceContext != null);
            resourceReference2 = resourceReference;
            if (resourceReference2 == null) continue;
            try {
                try {
                    ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
                    string2 = resourceIndexer.getIndexedName(this.getDirectory(), string);
                    if (string2 != null) {
                        var7_6 = null;
                        resourceReference.unlock();
                        break;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                    string2 = null;
                }
            }
            catch (Throwable throwable) {
                var7_6 = null;
                resourceReference.unlock();
                throw throwable;
            }
            var7_6 = null;
            resourceReference.unlock();
        }
        return string2 == null ? string : string2;
    }

    protected ResourceReference getIndexer(ResourceContext resourceContext) {
        IndexerModule indexerModule = (IndexerModule)resourceContext.getModule("org.w3c.jigsaw.indexer");
        ResourceReference resourceReference = indexerModule.getIndexer(resourceContext);
        return resourceReference;
    }

    private Resource index(String string, Hashtable hashtable) {
        return this.index(string, hashtable, null);
    }

    protected Resource index(String string, Hashtable hashtable, RequestInterface requestInterface) {
        hashtable.put("identifier", string);
        this.updateDefaultChildAttributes(hashtable);
        ResourceContext resourceContext = this.getContext();
        Resource resource = null;
        ResourceReference resourceReference = null;
        ResourceReference resourceReference2 = null;
        while (resourceContext != null) {
            Object var9_8;
            do {
                resourceReference = this.getIndexer(resourceContext);
                resourceContext = resourceContext.getParent();
            } while (resourceReference == resourceReference2 && resourceContext != null);
            resourceReference2 = resourceReference;
            if (resourceReference2 == null) continue;
            try {
                try {
                    ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
                    resource = resourceIndexer.createResource(this, requestInterface, this.getDirectory(), string, hashtable);
                    if (resource != null) {
                        var9_8 = null;
                        resourceReference.unlock();
                        break;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                    resource = null;
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                resourceReference.unlock();
                throw throwable;
            }
            var9_8 = null;
            resourceReference.unlock();
        }
        return resource;
    }

    public void initialize(Object[] objectArray) {
        IndexerModule indexerModule;
        Object object;
        super.initialize(objectArray);
        this.disableEvent();
        File file = null;
        if (!this.definesAttribute(ATTR_DIRECTORY)) {
            object = this.getParent();
            if (object != null) {
                try {
                    try {
                        File file2;
                        Resource resource = object.lock();
                        if (resource.definesAttribute("directory") && (file2 = (File)resource.getValue("directory", null)) != null) {
                            file = new File(file2, this.getIdentifier());
                            this.setValue(ATTR_DIRECTORY, (Object)file);
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                    }
                    indexerModule = null;
                    object.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    object.unlock();
                    throw throwable;
                }
            }
        } else {
            file = this.getDirectory();
        }
        object = this.getContext();
        String string = this.getString(ATTR_INDEXER, null);
        if (string != null && !string.equals("")) {
            indexerModule = (IndexerModule)((ResourceContext)object).getModule("org.w3c.jigsaw.indexer");
            indexerModule.registerIndexer((ResourceContext)object, string);
        }
        this.enableEvent();
    }

    public ResourceReference lookup(String string) {
        ResourceReference resourceReference = null;
        resourceReference = super.lookup(string);
        if (resourceReference != null) {
            return resourceReference;
        }
        return this.getExtensibleFlag() ? this.createDefaultResource(string) : null;
    }

    public synchronized void reindex(boolean bl) {
        if (this.getExtensibleFlag()) {
            Enumeration enumeration = this.enumerateAllResourceIdentifiers();
            String string = null;
            ResourceReference resourceReference = null;
            Resource resource = null;
            while (enumeration.hasMoreElements()) {
                Object var7_6;
                block18: {
                    string = (String)enumeration.nextElement();
                    resourceReference = this.lookup(string);
                    if (resourceReference == null) continue;
                    try {
                        try {
                            Cloneable cloneable;
                            Cloneable cloneable2;
                            resource = resourceReference.lock();
                            if (resource == this) {
                                var7_6 = null;
                                resourceReference.unlock();
                                continue;
                            }
                            if (resource instanceof DirectoryResource) {
                                cloneable2 = (DirectoryResource)resource;
                                cloneable = new Hashtable<String, ResourceContext>(10);
                                cloneable.put("context", ((Resource)cloneable2).getContext());
                                Resource resource2 = this.index(string, (Hashtable)cloneable);
                                if (resource2 == null && bl) {
                                    ((DirectoryResource)cloneable2).reindex(true);
                                    break block18;
                                }
                                if (!(resource2 instanceof DirectoryResource)) {
                                    throw new RuntimeException("Reindex Error : " + string + " can't be reindexed. " + "The reindexed resource is " + "no more a DirectoryResource.");
                                }
                                DirectoryResource directoryResource = (DirectoryResource)resource2;
                                String string2 = directoryResource.getString(ATTR_INDEXER, "");
                                if (string2.equals("")) {
                                    if (bl) {
                                        ((DirectoryResource)cloneable2).reindex(true);
                                    }
                                    string2 = ((AttributeHolder)cloneable2).getString(ATTR_INDEXER, null);
                                    directoryResource.setValue(ATTR_INDEXER, (Object)string2);
                                } else {
                                    ((DirectoryResource)cloneable2).setValue(ATTR_INDEXER, string2);
                                    if (bl) {
                                        ((DirectoryResource)cloneable2).reindex(true);
                                    }
                                }
                                directoryResource.setValue(ContainerResource.ATTR_KEY, (Object)((ContainerResource)cloneable2).getKey());
                                ((DirectoryResource)cloneable2).setValue(Resource.ATTR_IDENTIFIER, String.valueOf(string) + "-bakindex");
                                this.addResource(directoryResource, (Hashtable)cloneable);
                                try {
                                    ((ContainerResource)cloneable2).replace(directoryResource);
                                    break block18;
                                }
                                catch (MultipleLockException multipleLockException) {
                                    throw new RuntimeException("Reindex Error : " + multipleLockException.getMessage());
                                }
                            }
                            if (resource instanceof AbstractContainer || (cloneable = this.index(string, (Hashtable)(cloneable2 = new Hashtable(10)))) == null) break block18;
                            try {
                                resource.delete();
                            }
                            catch (MultipleLockException multipleLockException) {
                                throw new RuntimeException("Reindex Error : " + multipleLockException.getMessage());
                            }
                            this.addResource((Resource)cloneable, (Hashtable)cloneable2);
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            System.out.println(invalidResourceException.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        resourceReference.unlock();
                        throw throwable;
                    }
                }
                var7_6 = null;
                resourceReference.unlock();
            }
            this.markModified();
        }
    }

    public void resourceRemoved(StructureChangedEvent structureChangedEvent) {
        super.resourceRemoved(structureChangedEvent);
        if (!this.isUnloaded()) {
            this.markModified();
        }
    }

    public void setValue(int n, Object object) {
        String string;
        super.setValue(n, object);
        if (n == ATTR_INDEXER && (string = this.getString(ATTR_INDEXER, null)) != null) {
            ResourceContext resourceContext = null;
            IndexerModule indexerModule = null;
            resourceContext = this.getContext();
            indexerModule = (IndexerModule)resourceContext.getModule("org.w3c.jigsaw.indexer");
            indexerModule.registerIndexer(resourceContext, string);
        }
    }

    protected ResourceContext updateDefaultChildAttributes(Hashtable hashtable) {
        ResourceContext resourceContext = null;
        resourceContext = super.updateDefaultChildAttributes(hashtable);
        String string = (String)hashtable.get("identifier");
        if (string != null && this.getDirectory() != null) {
            hashtable.put("directory", new File(this.getDirectory(), string));
        }
        return resourceContext;
    }

    public synchronized boolean verify() {
        return this.getDirectory().exists();
    }
}

