/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.w3c.tools.jpeg.Jpeg;
import org.w3c.tools.jpeg.JpegException;

public class JpegHeaders
implements Jpeg {
    protected File jpegfile = null;
    protected InputStream in = null;
    protected Vector vcom = null;
    protected Vector[] vacom = new Vector[16];
    protected String[] comments = null;
    protected byte[][] appcomments = null;

    public JpegHeaders(File file) throws FileNotFoundException, JpegException, IOException {
        this.jpegfile = file;
        this.in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.scanHeaders();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.in.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object var3_2 = null;
        try {
            this.in.close();
        }
        catch (Exception exception) {}
    }

    public JpegHeaders(InputStream inputStream) throws JpegException, IOException {
        this.in = inputStream;
        this.scanHeaders();
    }

    protected int firstMarker() throws IOException, JpegException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n != 255 || n2 != 216) {
            throw new JpegException("Not a JPEG file");
        }
        return n2;
    }

    public String[] getAppComments() {
        return this.getStringAppComments();
    }

    public byte[][] getByteArrayAPPComment() {
        return null;
    }

    public String[] getComments() {
        if (this.comments == null) {
            this.comments = new String[this.vcom.size()];
            this.vcom.copyInto(this.comments);
        }
        return this.comments;
    }

    public String[] getStringAPPComments(int n) {
        if (n < 224 || n > 239) {
            return null;
        }
        int n2 = n - 224;
        int n3 = this.vacom[n2].size();
        if (this.appcomments == null) {
            this.appcomments = new byte[n3][];
            this.vacom[n2].copyInto((Object[])this.appcomments);
        }
        String[] stringArray = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            try {
                stringArray[n4] = new String(this.appcomments[n4], "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            ++n4;
        }
        return stringArray;
    }

    public String[] getStringAppComments() {
        return this.getStringAPPComments(236);
    }

    public static void main(String[] stringArray) {
        try {
            JpegHeaders jpegHeaders = new JpegHeaders(new File(stringArray[0]));
            String[] stringArray2 = jpegHeaders.getComments();
            if (stringArray2 != null) {
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int nextMarker() throws IOException {
        boolean bl = false;
        int n = this.in.read();
        while (n != 255) {
            n = this.in.read();
        }
        while ((n = this.in.read()) == 255) {
        }
        return n;
    }

    protected byte[] processComment() throws IOException, JpegException {
        int n = this.read2bytes();
        if (n < 2) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        StringBuffer stringBuffer = new StringBuffer(n -= 2);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n > 0) {
            int n3 = this.in.read(byArray, n2, n);
            if (n3 < 0) {
                throw new JpegException("EOF while reading jpeg comment");
            }
            n2 += n3;
            n -= n3;
        }
        return byArray;
    }

    protected int read2bytes() throws IOException, JpegException {
        int n = this.in.read();
        if (n == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        return (n << 8) + n2;
    }

    protected int scanHeaders() throws IOException, JpegException {
        this.vcom = new Vector(1);
        this.vacom = new Vector[16];
        int n = 0;
        while (n < 16) {
            this.vacom[n] = new Vector(1);
            ++n;
        }
        if (this.firstMarker() != 216) {
            throw new JpegException("Expected SOI marker first");
        }
        block8: while (true) {
            int n2 = this.nextMarker();
            switch (n2) {
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 197: 
                case 198: 
                case 199: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 207: {
                    this.skipVariable();
                    continue block8;
                }
                case 218: {
                    this.skipVariable();
                    return n2;
                }
                case 217: {
                    return n2;
                }
                case 254: {
                    this.vcom.addElement(new String(this.processComment(), "ISO-8859-1"));
                    continue block8;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    this.vacom[n2 - 224].addElement(this.processComment());
                    continue block8;
                }
            }
            this.skipVariable();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void skipVariable() throws IOException, JpegException {
        var1_1 = (long)this.read2bytes() - 2L;
        if (var1_1 >= 0L) ** GOTO lbl8
        throw new JpegException("Erroneous JPEG marker length");
lbl-1000:
        // 1 sources

        {
            var3_2 = this.in.skip(var1_1);
            if (var3_2 < 0L) {
                throw new IOException("Error while reading jpeg stream");
            }
            var1_1 -= var3_2;
lbl8:
            // 2 sources

            ** while (var1_1 > 0L)
        }
lbl9:
        // 1 sources

    }
}

