/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.util.Hashtable;
import java.util.Properties;

public class Jdbc {
    public static final String MAX_CONNECTIONS_P = "org.w3c.tools.jdbc.maxconn";
    public static final int DEFAULT_MAX_CONN = 10;
    public static final String JDBC_DRIVER_P = "org.w3c.tools.jdbc.jdbcdriver";
    public static final String USER_P = "org.w3c.tools.jdbc.user";
    public static final String PASSWORD_P = "org.w3c.tools.jdbc.password";

    private static boolean getBoolean(Properties properties, String string) {
        String string2 = (String)((Hashtable)properties).get(string);
        if (string2 != null) {
            return string2.equalsIgnoreCase("true");
        }
        return false;
    }

    public static String getDriver(Properties properties) {
        return (String)((Hashtable)properties).get(JDBC_DRIVER_P);
    }

    private static int getInt(Properties properties, String string, int n) {
        String string2 = (String)((Hashtable)properties).get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    private static long getLong(Properties properties, String string, long l) {
        String string2 = (String)((Hashtable)properties).get(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }
        return l;
    }

    public static int getMaxConn(Properties properties) {
        return Jdbc.getInt(properties, MAX_CONNECTIONS_P, 10);
    }

    public static String getPassword(Properties properties) {
        return (String)((Hashtable)properties).get(PASSWORD_P);
    }

    public static String getUser(Properties properties) {
        return (String)((Hashtable)properties).get(USER_P);
    }

    private static void setBoolean(Properties properties, String string, boolean bl) {
        ((Hashtable)properties).put(string, String.valueOf(bl));
    }

    public static Properties setDriver(Properties properties, String string) {
        if (string != null) {
            ((Hashtable)properties).put(JDBC_DRIVER_P, string);
        }
        return properties;
    }

    private static void setInt(Properties properties, String string, int n) {
        String string2 = String.valueOf(n);
        ((Hashtable)properties).put(string, string2);
    }

    private static void setLong(Properties properties, String string, long l) {
        String string2 = String.valueOf(l);
        ((Hashtable)properties).put(string, string2);
    }

    public static Properties setMaxConn(Properties properties, int n) {
        if (n < 1) {
            ((Hashtable)properties).put(MAX_CONNECTIONS_P, String.valueOf(10));
        } else {
            ((Hashtable)properties).put(MAX_CONNECTIONS_P, String.valueOf(n));
        }
        return properties;
    }

    public static Properties setPassword(Properties properties, String string) {
        if (string != null) {
            ((Hashtable)properties).put(PASSWORD_P, string);
        }
        return properties;
    }

    public static Properties setUser(Properties properties, String string) {
        if (string != null) {
            ((Hashtable)properties).put(USER_P, string);
        }
        return properties;
    }
}

