/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Properties;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcConnection;
import org.w3c.tools.jdbc.JdbcServer;
import org.w3c.tools.jdbc.JdbcServerState;
import org.w3c.tools.jdbc.ManagerDescription;
import org.w3c.util.LRUList;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.SyncLRUList;

public class ConnectionManager
implements PropertyMonitoring {
    public static final long WAIT_TIMEOUT = 120000L;
    public static final boolean debug = false;
    public static final int STATE_UNCHANGED = 0;
    public static final int STATE_CHANGED = 1;
    protected int state = 0;
    protected int conn_count = 0;
    protected int conn_max;
    protected int conn2free;
    Properties props = null;
    private static ManagerDescription[] managers = null;
    protected LRUList connectionsLru = null;
    protected LinkedList usedConnections = null;
    protected Comparator conn_comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object instanceof JdbcConnection && object2 instanceof JdbcConnection) {
                JdbcConnection jdbcConnection = (JdbcConnection)object;
                JdbcConnection jdbcConnection2 = (JdbcConnection)object2;
                if (jdbcConnection.isClosed()) {
                    if (jdbcConnection2.isClosed()) {
                        return 0;
                    }
                    return -1;
                }
                return (int)(jdbcConnection2.getQueryStamp() - jdbcConnection.getQueryStamp());
            }
            throw new ClassCastException("can't compare");
        }
    };

    private ConnectionManager(Properties properties) {
        this.props = properties;
        this.connectionsLru = new SyncLRUList();
        this.usedConnections = new LinkedList();
        if (this.props instanceof ObservableProperties) {
            ((ObservableProperties)this.props).registerObserver(this);
        }
        this.conn_max = Jdbc.getMaxConn(this.props);
        this.conn2free = Math.max(this.conn_max / 5, 1);
    }

    protected JdbcConnection allocateConnection(JdbcServer jdbcServer) {
        JdbcConnection jdbcConnection = new JdbcConnection(jdbcServer);
        this.notifyConnection(jdbcConnection);
        return jdbcConnection;
    }

    protected void deleteConnection(JdbcConnection jdbcConnection) {
        JdbcServerState jdbcServerState = jdbcConnection.getServer().getState();
        jdbcServerState.deleteConnection(jdbcConnection);
        this.usedConnections.remove(jdbcConnection);
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            --this.conn_count;
            this.state = 1;
            this.notifyAll();
        }
    }

    protected synchronized void freeConnections() {
        Collections.sort(this.usedConnections, this.conn_comparator);
        int n = this.usedConnections.size();
        int n2 = this.conn2free > n ? n : this.conn2free;
        while (n2-- > 0) {
            JdbcConnection jdbcConnection = (JdbcConnection)this.usedConnections.removeFirst();
            jdbcConnection.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JdbcConnection getConnection(JdbcServer jdbcServer) {
        JdbcServerState jdbcServerState = jdbcServer.getState();
        JdbcConnection jdbcConnection = null;
        while (true) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                while ((jdbcConnection = jdbcServerState.getConnection()) != null) {
                    if (!jdbcConnection.markUsed()) continue;
                    return jdbcConnection;
                }
                if (this.negotiateConnection(jdbcServer)) {
                    jdbcConnection = this.allocateConnection(jdbcServer);
                    if (!jdbcConnection.markUsed()) return null;
                    return jdbcConnection;
                }
            }
            try {
                this.waitForConnection(jdbcServer);
            }
            catch (InterruptedException interruptedException) {}
            if (this.state != 0) continue;
            this.freeConnections();
        }
    }

    public static ConnectionManager getManager() {
        return ConnectionManager.getManager(System.getProperties());
    }

    public static synchronized ConnectionManager getManager(Properties properties) {
        if (managers != null) {
            int n = 0;
            while (n < managers.length) {
                if (managers[n] != null && managers[n].sameProperties(properties)) {
                    return managers[n].getManager();
                }
                ++n;
            }
        }
        ConnectionManager connectionManager = new ConnectionManager(properties);
        if (managers != null) {
            ManagerDescription[] managerDescriptionArray = new ManagerDescription[managers.length + 1];
            System.arraycopy(managers, 0, managerDescriptionArray, 0, managers.length);
            managerDescriptionArray[ConnectionManager.managers.length] = new ManagerDescription(connectionManager, properties);
        } else {
            managers = new ManagerDescription[1];
            ConnectionManager.managers[0] = new ManagerDescription(connectionManager, properties);
        }
        return connectionManager;
    }

    protected boolean negotiateConnection(JdbcServer jdbcServer) {
        if (this.conn_count >= this.conn_max) {
            JdbcConnection jdbcConnection = (JdbcConnection)this.connectionsLru.removeTail();
            if (jdbcConnection == null) {
                return false;
            }
            jdbcConnection.delete();
        }
        return true;
    }

    protected synchronized void notifyConnection(JdbcConnection jdbcConnection) {
        ++this.conn_count;
    }

    public synchronized void notifyIdle(JdbcConnection jdbcConnection) {
        this.usedConnections.remove(jdbcConnection);
        this.connectionsLru.toHead(jdbcConnection);
        JdbcServerState jdbcServerState = jdbcConnection.getServer().getState();
        jdbcServerState.registerConnection(jdbcConnection);
        this.state = 1;
        this.notifyAll();
    }

    public void notifyUse(JdbcConnection jdbcConnection) {
        this.connectionsLru.remove(jdbcConnection);
        this.usedConnections.add(jdbcConnection);
    }

    public boolean propertyChanged(String string) {
        if (string.equals("org.w3c.tools.jdbc.maxconn")) {
            this.conn_max = Jdbc.getMaxConn(this.props);
            this.conn2free = Math.max(this.conn_max / 5, 1);
            return true;
        }
        return false;
    }

    protected synchronized void waitForConnection(JdbcServer jdbcServer) throws InterruptedException {
        this.state = 0;
        this.wait(120000L);
    }
}

