/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.webdav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.frames.PostableFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.webdav.DAVPropertyException;
import org.w3c.jigsaw.webdav.DAVReply;
import org.w3c.jigsaw.webdav.DAVRequest;
import org.w3c.jigsaw.webdav.MultiStatusException;
import org.w3c.tools.codec.Base64Decoder;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.codec.Base64FormatException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.PropertiesAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.DateParser;
import org.w3c.util.ObservableProperties;
import org.w3c.util.UUID;
import org.w3c.www.http.ContentLengthInputStream;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.webdav.DAVManager;
import org.w3c.www.webdav.DAVEntityTag;
import org.w3c.www.webdav.DAVIf;
import org.w3c.www.webdav.DAVParser;
import org.w3c.www.webdav.DAVStateToken;
import org.w3c.www.webdav.xml.DAVBody;
import org.w3c.www.webdav.xml.DAVFactory;
import org.w3c.www.webdav.xml.DAVLockInfo;
import org.w3c.www.webdav.xml.DAVMultiStatus;
import org.w3c.www.webdav.xml.DAVNode;
import org.w3c.www.webdav.xml.DAVPropAction;
import org.w3c.www.webdav.xml.DAVPropFind;
import org.w3c.www.webdav.xml.DAVPropStat;
import org.w3c.www.webdav.xml.DAVProperties;
import org.w3c.www.webdav.xml.DAVPropertyBehavior;
import org.w3c.www.webdav.xml.DAVResponse;
import org.xml.sax.SAXException;

public class DAVFrame
extends PostableFrame {
    public static final boolean debug = false;
    public static final boolean debugxml = false;
    public static final int COND_OK_LOCK = 3;
    protected static HttpMimeType xmlcontenttype = null;
    protected DAVManager manager = null;
    public static final String REMAINING_PATH = "org.w3c.jigsaw.webdav.rpath";
    public static final String LOCK_USERNAME = "org.w3c.jigsaw.webdav.user";
    public static final String LOCK_TOKEN = "org.w3c.jigsaw.webdav.token";
    public static final String LOCK_OWNER = "org.w3c.jigsaw.webdav.owner";
    public static final String LOCK_EXPIRE = "org.w3c.jigsaw.webdav.expire";
    public static final String LOCK_TIMEOUT = "org.w3c.jigsaw.webdav.timeout";
    public static final String LOCKED_REREFENCE = "org.w3c.jigsaw.webdav.reference";
    public static final Long DEFAULT_LOCK_TIMEOUT = new Long(86400000L);
    public static final Long MAX_LOCK_TIMEOUT = new Long(604800000L);
    protected static int ATTR_CREATION_DATE = -1;
    protected static int ATTR_DEAD_PROPERTIES = -1;
    protected static int ATTR_LOCK_TOKEN = -1;
    protected static int ATTR_LOCK_TIMEOUT = -1;
    protected static int ATTR_LOCK_DATE = -1;
    protected static int ATTR_LOCK_DEPTH = -1;
    protected static int ATTR_LOCK_OWNER = -1;
    protected static int ATTR_LOCK_USERNAME = -1;
    protected Node ownerNode = null;
    protected Hashtable deadindex = null;
    protected boolean deadpropmodified = false;
    static /* synthetic */ Class class$org$w3c$jigsaw$webdav$DAVFrame;

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.webdav.DAVFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        Attribute attribute = new DateAttribute("creation-date", (Object)null, 1);
        ATTR_CREATION_DATE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new PropertiesAttribute("dead-properties", null, 1);
        ATTR_DEAD_PROPERTIES = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("lock-token", null, 1);
        ATTR_LOCK_TOKEN = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new DateAttribute("lock-timeout", (Object)null, 1);
        ATTR_LOCK_TIMEOUT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new DateAttribute("lock-date", (Object)null, 1);
        ATTR_LOCK_DATE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("lock-depth", null, 1);
        ATTR_LOCK_DEPTH = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("lock-owner", null, 1);
        ATTR_LOCK_OWNER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("lock-username", null, 1);
        ATTR_LOCK_USERNAME = AttributeRegistry.registerAttribute(clazz, attribute);
        try {
            MimeType mimeType = new MimeType("text/xml");
            mimeType.addParameter("charset", "utf-8");
            xmlcontenttype = HttpFactory.makeMimeType(mimeType);
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            mimeTypeFormatException.printStackTrace();
            System.exit(1);
        }
    }

    protected static boolean acceptRedirect(DAVRequest dAVRequest) {
        String string = dAVRequest.getMethod();
        return (string.equals("PROPPATCH") || string.equals("PROPFIND") || string.equals("COPY") || string.equals("MOVE") || string.equals("DELETE") || string.equals("LOCK") || string.equals("UNLOCK")) ^ true;
    }

    protected void addContentLanguage(DAVProperties dAVProperties) {
        String string = this.getContentLanguage();
        if (string != null) {
            dAVProperties.addProperty("getcontentlanguage", string);
        }
    }

    protected void addContentLength(DAVProperties dAVProperties) {
        int n = this.getContentLength();
        if (n >= 0) {
            dAVProperties.addProperty("getcontentlength", String.valueOf(n));
        }
    }

    protected void addContentType(DAVProperties dAVProperties) {
        MimeType mimeType = this.getContentType();
        if (mimeType != null) {
            dAVProperties.addProperty("getcontenttype", mimeType.toString());
        }
    }

    protected void addCreationDate(DAVProperties dAVProperties) {
        String string = DateParser.getIsoDate(new Date(this.getCreationDate()));
        dAVProperties.addProperty("creationdate", string);
    }

    protected void addDisplayName(DAVProperties dAVProperties) {
        String string = this.getTitle();
        if (string != null && string.length() > 0) {
            dAVProperties.addProperty("displayname", string);
        }
    }

    protected void addETag(DAVProperties dAVProperties) {
        HttpEntityTag httpEntityTag = this.getETag();
        if (httpEntityTag != null) {
            dAVProperties.addProperty("getetag", httpEntityTag.getTag());
        }
    }

    protected void addLastModified(DAVProperties dAVProperties) {
        String string = DateParser.getIsoDate(new Date(this.getLastModified()));
        dAVProperties.addProperty("getlastmodified", string);
    }

    protected void addLockDiscovery(DAVRequest dAVRequest, Node node) {
        if (this.isLocked(dAVRequest)) {
            Element element = DAVNode.addDAVNode(node, "lockdiscovery", null);
            Element element2 = DAVNode.addDAVNode(element, "activelock", null);
            Element element3 = DAVNode.addDAVNode(element2, "locktype", null);
            DAVNode.addDAVNode(element3, "write", null);
            Element element4 = DAVNode.addDAVNode(element2, "lockscope", null);
            DAVNode.addDAVNode(element4, "exclusive", null);
            String string = DAVRequest.depthToString(this.getCurrentLockDepth());
            DAVNode.addDAVNode(element2, "depth", string);
            Node node2 = this.getCurrentLockOwner(dAVRequest);
            if (node2 != null) {
                DAVNode.importNode(node.getOwnerDocument(), element2, node2, true);
            }
            String string2 = "Second-" + this.getCurrentLockTimeout(dAVRequest) / 1000L;
            DAVNode.addDAVNode(element2, "timeout", string2);
            Element element5 = DAVNode.addDAVNode(element2, "locktoken", null);
            DAVNode.addDAVNode(element5, "href", this.getCurrentLockToken(dAVRequest));
        }
    }

    protected void addLockDiscovery(DAVRequest dAVRequest, DAVProperties dAVProperties) {
        this.addLockDiscovery(dAVRequest, dAVProperties.getNode());
    }

    protected void addResourceType(DAVProperties dAVProperties) {
        if (this.isCollection()) {
            dAVProperties.setResourceType("collection");
        } else {
            dAVProperties.setResourceType(null);
        }
    }

    protected void addSupportedLock(DAVProperties dAVProperties) {
        Element element = dAVProperties.addDAVNode("supportedlock", null);
        Element element2 = DAVNode.addDAVNode(element, "lockentry", null);
        Element element3 = DAVNode.addDAVNode(element2, "lockscope", null);
        DAVNode.addDAVNode(element3, "exclusive", null);
        Element element4 = DAVNode.addDAVNode(element2, "locktype", null);
        DAVNode.addDAVNode(element4, "write", null);
    }

    protected int checkIf(DAVRequest dAVRequest) throws HTTPException {
        block16: {
            URL uRL = this.getURL(dAVRequest);
            String string = uRL.toExternalForm();
            DAVIf[] dAVIfArray = dAVRequest.getIf();
            if (dAVIfArray == null) break block16;
            int n = dAVIfArray.length;
            boolean bl = dAVRequest.isTaggedListIfHeader();
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    Object object;
                    boolean bl3;
                    DAVIf dAVIf;
                    block17: {
                        dAVIf = dAVIfArray[n2];
                        bl3 = false;
                        if (!dAVIf.hasResource()) break block17;
                        object = null;
                        try {
                            object = new URL(uRL, dAVIf.getResource());
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                            break block15;
                        }
                        if (((URL)object).equals(uRL)) break block17;
                        if (!string.startsWith(((URL)object).toExternalForm())) break block15;
                        bl3 = true;
                    }
                    object = dAVIf.getTokenListIterator();
                    while (object.hasNext()) {
                        boolean bl4 = true;
                        boolean bl5 = false;
                        LinkedList linkedList = (LinkedList)object.next();
                        ListIterator listIterator = linkedList.listIterator(0);
                        while (listIterator.hasNext()) {
                            Object object2;
                            Object e = listIterator.next();
                            if (e instanceof DAVStateToken) {
                                object2 = (DAVStateToken)e;
                                if (this.matchLockToken(dAVRequest, ((DAVStateToken)object2).getStateToken())) {
                                    if (((DAVStateToken)object2).isNot()) {
                                        bl4 = false;
                                        bl5 = false;
                                        continue;
                                    }
                                    bl2 = true;
                                    continue;
                                }
                                if (((DAVStateToken)object2).isNot()) continue;
                                bl4 = false;
                                continue;
                            }
                            if (bl3 || !(e instanceof DAVEntityTag)) continue;
                            object2 = (DAVEntityTag)e;
                            if (this.matchETag((HttpEntityTag)object2)) {
                                if (!((DAVEntityTag)object2).isNot()) continue;
                                bl4 = false;
                                bl5 = false;
                                continue;
                            }
                            if (((DAVEntityTag)object2).isNot()) continue;
                            bl4 = false;
                        }
                        if (bl3) continue;
                        if (bl4 && bl2) {
                            return 3;
                        }
                        if (!bl4) continue;
                        return 2;
                    }
                }
                ++n2;
            }
            if (bl) {
                if (bl2) {
                    return 3;
                }
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected boolean checkLockOwner(DAVRequest dAVRequest) {
        String string = (String)dAVRequest.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String string2 = this.getCurrentLockUsername(dAVRequest);
        if (string2 == null) {
            return true;
        }
        if (string != null) {
            return string.equals(string2);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected URL computeDestURL(URL uRL, DAVFrame dAVFrame) throws MalformedURLException {
        String string = uRL.getFile();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith("/")) {
            stringBuffer.append("/");
        }
        stringBuffer.append(dAVFrame.getResource().getIdentifier());
        if (dAVFrame.isCollection()) {
            stringBuffer.append("/");
        }
        return new URL(uRL, stringBuffer.toString());
    }

    public Reply copy(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        String string = dAVRequest.getDestination();
        URL uRL = this.getURL(dAVRequest);
        URL uRL2 = null;
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Reply reply = dAVRequest.makeReply(400);
            reply.setContent("Invalid destination URL");
            throw new HTTPException(reply);
        }
        if (uRL2.equals(uRL)) {
            Reply reply = dAVRequest.makeReply(403);
            String string2 = "The source and destination URIs are the same";
            reply.setContent(string2);
            return reply;
        }
        org.w3c.www.protocol.webdav.DAVRequest dAVRequest2 = null;
        org.w3c.www.protocol.webdav.DAVReply dAVReply = null;
        dAVRequest2 = this.createRequest(dAVRequest, "HEAD", uRL2, null);
        try {
            dAVReply = this.manager.runDAVRequest(dAVRequest2);
            this.skipBody(dAVReply);
        }
        catch (HttpException httpException) {
            Reply reply = dAVRequest.makeReply(500);
            reply.setContent(httpException.getMessage());
            throw new HTTPException(reply);
        }
        boolean bl = false;
        if (dAVReply.getStatus() != 404) {
            bl = dAVRequest.getOverwrite();
            if (!bl) {
                String string3 = "The state of the destination is non-null";
                Reply reply = dAVRequest.makeReply(412);
                reply.setContent(string3);
                return reply;
            }
            dAVRequest2 = this.createRequest(dAVRequest, "DELETE", uRL2, null);
            try {
                dAVReply = this.manager.runDAVRequest(dAVRequest2);
                this.skipBody(dAVReply);
            }
            catch (HttpException httpException) {
                Reply reply = dAVRequest.makeReply(500);
                reply.setContent(httpException.getMessage());
                throw new HTTPException(reply);
            }
        }
        if (this.isCollection()) {
            return this.copyCollection(uRL2, dAVRequest, bl);
        }
        return this.copyResource(uRL2, dAVRequest, bl);
    }

    protected Reply copyCollection(URL uRL, DAVRequest dAVRequest, boolean bl) throws ProtocolException, ResourceException {
        DAVBody dAVBody = this.getBody(dAVRequest);
        Document document = DAVBody.createDocument("multistatus");
        Object var6_6 = null;
        try {
            return this.copyCollection(uRL, dAVRequest, bl, dAVBody, document);
        }
        catch (MultiStatusException multiStatusException) {
            return this.createDAVReply(dAVRequest, 207, multiStatusException.getDocument());
        }
    }

    protected Reply copyCollection(URL uRL, DAVRequest dAVRequest, boolean bl, DAVBody dAVBody, Document document) throws ProtocolException, ResourceException, MultiStatusException {
        org.w3c.www.protocol.webdav.DAVRequest dAVRequest2 = null;
        org.w3c.www.protocol.webdav.DAVReply dAVReply = null;
        dAVRequest2 = this.createRequest(dAVRequest, "MKCOL", uRL, null);
        try {
            dAVReply = this.manager.runDAVRequest(dAVRequest2);
            this.skipBody(dAVReply);
        }
        catch (HttpException httpException) {
            Reply reply = dAVRequest.makeReply(500);
            reply.setContent(httpException.getMessage());
            throw new HTTPException(reply);
        }
        if (dAVReply.getStatus() != 201) {
            return this.dupReply(dAVRequest, dAVReply, false);
        }
        org.w3c.www.protocol.webdav.DAVReply dAVReply2 = dAVReply;
        this.copyProperties(dAVRequest, uRL, dAVBody);
        if (dAVRequest.getDepth() == 0) {
            return this.dupReply(dAVRequest, dAVReply, bl);
        }
        DAVMultiStatus dAVMultiStatus = DAVFactory.createMultiStatus(document.getDocumentElement());
        boolean bl2 = false;
        Enumeration enumeration = this.dresource.enumerateResourceIdentifiers();
        ResourceReference resourceReference = null;
        FramedResource framedResource = null;
        while (enumeration.hasMoreElements()) {
            Object var16_17;
            block19: {
                String string = (String)enumeration.nextElement();
                resourceReference = this.dresource.lookup(string);
                if (resourceReference == null) continue;
                try {
                    try {
                        framedResource = (FramedResource)resourceReference.lock();
                        if (framedResource == this.resource) {
                            var16_17 = null;
                            resourceReference.unlock();
                            continue;
                        }
                        DAVFrame dAVFrame = (DAVFrame)framedResource.getFrame(class$org$w3c$jigsaw$webdav$DAVFrame != null ? class$org$w3c$jigsaw$webdav$DAVFrame : DAVFrame.class$("org.w3c.jigsaw.webdav.DAVFrame"));
                        URL uRL2 = null;
                        if (dAVFrame == null) break block19;
                        try {
                            uRL2 = this.computeDestURL(uRL, dAVFrame);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Reply reply = dAVRequest.makeReply(500);
                            String string2 = "Can't build destination URI : " + malformedURLException.getMessage();
                            reply.setContent(string2);
                            throw new HTTPException(reply);
                        }
                        if (dAVFrame.isCollection()) {
                            try {
                                dAVFrame.copyCollection(uRL2, dAVRequest, bl, dAVBody, document);
                            }
                            catch (MultiStatusException multiStatusException) {
                                bl2 = true;
                                multiStatusException.printStackTrace();
                                multiStatusException.addResponses(document, dAVMultiStatus);
                            }
                        } else {
                            try {
                                dAVFrame.copyDAVResource(dAVRequest, dAVFrame.getURL(dAVRequest), uRL2, dAVBody);
                            }
                            catch (MultiStatusException multiStatusException) {
                                bl2 = true;
                                multiStatusException.printStackTrace();
                                multiStatusException.addResponses(document, dAVMultiStatus);
                            }
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                    }
                }
                catch (Throwable throwable) {
                    var16_17 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
            }
            var16_17 = null;
            resourceReference.unlock();
        }
        if (bl2) {
            throw new MultiStatusException(document);
        }
        return this.dupReply(dAVRequest, dAVReply2, bl);
    }

    protected org.w3c.www.protocol.webdav.DAVReply copyDAVResource(DAVRequest dAVRequest, URL uRL, URL uRL2, DAVBody dAVBody) throws MultiStatusException {
        Object var5_5 = null;
        org.w3c.www.protocol.webdav.DAVRequest dAVRequest2 = null;
        org.w3c.www.protocol.webdav.DAVReply dAVReply = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Content-Length", String.valueOf(this.getContentLength()));
        hashtable.put("Content-Type", this.getContentType().toString());
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fresource.getFile());
        }
        catch (IOException iOException) {
            String string = "Cannot read source file";
            throw new MultiStatusException(uRL2.toExternalForm(), this.getStatusLine(500), string);
        }
        dAVRequest2 = this.createRequest(dAVRequest, "PUT", uRL2, hashtable, fileInputStream);
        try {
            dAVReply = this.manager.runDAVRequest(dAVRequest2);
            this.skipBody(dAVReply);
        }
        catch (HttpException httpException) {
            throw new MultiStatusException(uRL2.toExternalForm(), this.getStatusLine(500), httpException.getMessage());
        }
        int n = dAVReply.getStatus();
        org.w3c.www.protocol.webdav.DAVReply dAVReply2 = dAVReply;
        if (n / 100 != 2) {
            throw new MultiStatusException(uRL2.toExternalForm(), this.getStatusLine(n));
        }
        this.copyProperties(dAVRequest, uRL2, dAVBody);
        return dAVReply2;
    }

    protected void copyProperties(DAVRequest dAVRequest, URL uRL, DAVBody dAVBody) throws MultiStatusException {
        DAVPropertyBehavior dAVPropertyBehavior;
        org.w3c.www.protocol.webdav.DAVRequest dAVRequest2 = null;
        org.w3c.www.protocol.webdav.DAVReply dAVReply = null;
        Document document = DAVBody.createDocument("propertyupdate");
        DAVPropAction dAVPropAction = DAVFactory.createPropAction(1, this.getPropertiesForCopy(document), document);
        document.getDocumentElement().appendChild(dAVPropAction.getNode());
        dAVRequest2 = this.createRequest(dAVRequest, "PROPPATCH", uRL, null, document);
        try {
            dAVReply = this.manager.runDAVRequest(dAVRequest2);
            this.skipBody(dAVReply);
        }
        catch (HttpException httpException) {
            throw new MultiStatusException(uRL.toExternalForm(), this.getStatusLine(500), httpException.getMessage());
        }
        if (dAVBody != null && (dAVPropertyBehavior = dAVBody.getPropertyBehavior()) != null && !dAVPropertyBehavior.omit() && !dAVPropertyBehavior.keepaliveAll()) {
            String[] stringArray = dAVPropertyBehavior.getHrefs();
        }
    }

    protected Reply copyResource(URL uRL, DAVRequest dAVRequest, boolean bl) throws ProtocolException, ResourceException {
        try {
            URL uRL2 = this.getURL(dAVRequest);
            org.w3c.www.protocol.webdav.DAVReply dAVReply = this.copyDAVResource(dAVRequest, uRL2, uRL, this.getBody(dAVRequest));
            if (bl) {
                dAVReply.setStatus(204);
            }
            return this.dupReply(dAVRequest, dAVReply, bl);
        }
        catch (MultiStatusException multiStatusException) {
            return this.createDAVReply(dAVRequest, 207, multiStatusException.getDocument());
        }
    }

    protected Reply createDAVReply(DAVRequest dAVRequest, int n, Document document) {
        Reply reply = dAVRequest.makeReply(n);
        reply.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)xmlcontenttype);
        reply.setDate(System.currentTimeMillis() / 1000L * 1000L);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat(document, "utf-8", true);
        outputFormat.setOmitXMLDeclaration(false);
        outputFormat.setPreserveSpace(false);
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n2 = byteArrayOutputStream.size();
        reply.setContentLength(n2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        reply.setStream(byteArrayInputStream);
        return reply;
    }

    protected org.w3c.www.protocol.webdav.DAVRequest createRequest(DAVRequest dAVRequest, String string, URL uRL, Hashtable hashtable) {
        return this.createRequest(dAVRequest, string, uRL, hashtable, (InputStream)null);
    }

    protected org.w3c.www.protocol.webdav.DAVRequest createRequest(DAVRequest dAVRequest, String string, URL uRL, Hashtable hashtable, InputStream inputStream) {
        org.w3c.www.protocol.webdav.DAVRequest dAVRequest2 = null;
        dAVRequest2 = this.manager.createDAVRequest();
        dAVRequest2.setURL(uRL);
        dAVRequest2.setMethod(string);
        if (dAVRequest.hasAuthorization()) {
            dAVRequest2.setAuthorization(dAVRequest.getAuthorization());
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                dAVRequest2.setValue(string2, string3);
            }
        }
        if (inputStream != null) {
            dAVRequest2.setOutputStream(inputStream);
        }
        return dAVRequest2;
    }

    protected org.w3c.www.protocol.webdav.DAVRequest createRequest(DAVRequest dAVRequest, String string, URL uRL, Hashtable hashtable, Document document) {
        if (document != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputFormat outputFormat = new OutputFormat(document, "utf-8", true);
            outputFormat.setOmitXMLDeclaration(false);
            outputFormat.setPreserveSpace(false);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
            try {
                xMLSerializer.serialize(document);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            int n = byteArrayOutputStream.size();
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            hashtable.put("Content-Length", String.valueOf(n));
            hashtable.put("Content-Type", xmlcontenttype.toString());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return this.createRequest(dAVRequest, string, uRL, hashtable, byteArrayInputStream);
        }
        return this.createRequest(dAVRequest, string, uRL, (Hashtable)hashtable, (InputStream)null);
    }

    public Reply davextended(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        String string = dAVRequest.getMethod();
        Reply reply = dAVRequest.makeReply(501);
        reply.setContent("Method " + string + " not implemented.");
        throw new HTTPException(reply);
    }

    protected String decodeURL(DAVRequest dAVRequest, String string) throws HTTPException {
        try {
            return DAVParser.decodeURL(string);
        }
        catch (HttpInvalidValueException httpInvalidValueException) {
            Reply reply = dAVRequest.makeReply(400);
            reply.setContent("Invalid request: " + httpInvalidValueException.getMessage());
            throw new HTTPException(reply);
        }
    }

    public Reply delete(Request request) throws ProtocolException, ResourceException {
        return super.delete(request);
    }

    protected Reply dupReply(DAVRequest dAVRequest, org.w3c.www.protocol.webdav.DAVReply dAVReply, boolean bl) {
        Reply reply = null;
        if (bl) {
            reply = dAVRequest.makeReply(204);
            return reply;
        }
        reply = dAVRequest.makeReply(dAVReply.getStatus());
        reply.setHeaderValue(HttpReplyMessage.H_SERVER, null);
        Enumeration enumeration = dAVReply.enumerateHeaderDescriptions();
        while (enumeration.hasMoreElements()) {
            HeaderDescription headerDescription = (HeaderDescription)enumeration.nextElement();
            HeaderValue headerValue = dAVReply.getHeaderValue(headerDescription);
            if (headerValue == null) continue;
            reply.setHeaderValue(headerDescription, headerValue);
        }
        reply.setContentLength(0);
        reply.setHeaderValue(HttpMessage.H_CONNECTION, null);
        reply.setHeaderValue(HttpMessage.H_PROXY_CONNECTION, null);
        reply.setHeaderValue(HttpReplyMessage.H_PUBLIC, null);
        reply.setHeaderValue(HttpMessage.H_TRANSFER_ENCODING, null);
        reply.setHeaderValue(HttpMessage.H_UPGRADE, null);
        reply.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, null);
        reply.removeHeader("keep-alive");
        return reply;
    }

    public Reply extended(Request request) throws ProtocolException, ResourceException {
        if (request instanceof DAVRequest) {
            DAVRequest dAVRequest = (DAVRequest)request;
            String string = dAVRequest.getMethod();
            Reply reply = null;
            reply = string.equals("PROPFIND") ? this.propfind(dAVRequest) : (string.equals("PROPPATCH") ? this.proppatch(dAVRequest) : (string.equals("MKCOL") ? this.mkcol(dAVRequest) : (string.equals("COPY") ? this.copy(dAVRequest) : (string.equals("MOVE") ? this.move(dAVRequest) : (string.equals("LOCK") ? this.lock(dAVRequest) : (string.equals("UNLOCK") ? this.unlock(dAVRequest) : this.davextended(dAVRequest)))))));
            return reply;
        }
        String string = request.getMethod();
        Reply reply = request.makeReply(501);
        reply.setContent("Method " + string + " not implemented.");
        throw new HTTPException(reply);
    }

    public Reply get(Request request) throws ProtocolException, ResourceException {
        return super.get(request);
    }

    protected HttpTokenList getAllow() {
        this.allowed = super.getAllow();
        this.allowed.addToken("PROPFIND", false);
        this.allowed.addToken("PROPPATCH", false);
        this.allowed.addToken("MKCOL", false);
        this.allowed.addToken("COPY", false);
        this.allowed.addToken("MOVE", false);
        this.allowed.addToken("LOCK", false);
        this.allowed.addToken("UNLOCK", false);
        return this.allowed;
    }

    protected DAVBody getBody(DAVRequest dAVRequest) throws HTTPException {
        try {
            InputStream inputStream = dAVRequest.getInputStream();
            if (inputStream instanceof ContentLengthInputStream && dAVRequest.getContentLength() == 0) {
                return null;
            }
            if (inputStream != null) {
                return new DAVBody(inputStream);
            }
            return null;
        }
        catch (Exception exception) {
            Reply reply = dAVRequest.makeReply(400);
            reply.setContent("Invalid request: " + exception.getMessage());
            throw new HTTPException(reply);
        }
    }

    protected DAVResponse[] getChildResponses(DAVRequest dAVRequest, DAVPropFind dAVPropFind, Document document, boolean bl) {
        if (this.resource instanceof ContainerResource) {
            Object object;
            Vector<DAVResponse> vector = new Vector<DAVResponse>();
            ContainerResource containerResource = (ContainerResource)this.resource;
            Enumeration enumeration = containerResource.enumerateResourceIdentifiers();
            ResourceReference resourceReference = null;
            FramedResource framedResource = null;
            while (enumeration.hasMoreElements()) {
                Object var12_11;
                object = (String)enumeration.nextElement();
                resourceReference = containerResource.lookup((String)object);
                if (resourceReference == null) continue;
                try {
                    try {
                        framedResource = (FramedResource)resourceReference.lock();
                        if (framedResource == this.resource) {
                            var12_11 = null;
                            resourceReference.unlock();
                            continue;
                        }
                        DAVFrame dAVFrame = (DAVFrame)framedResource.getFrame(class$org$w3c$jigsaw$webdav$DAVFrame != null ? class$org$w3c$jigsaw$webdav$DAVFrame : DAVFrame.class$("org.w3c.jigsaw.webdav.DAVFrame"));
                        if (dAVFrame != null) {
                            DAVResponse[] dAVResponseArray;
                            vector.addElement(dAVFrame.getResponse(dAVRequest, dAVPropFind, document));
                            if (bl && framedResource instanceof ContainerResource && (dAVResponseArray = dAVFrame.getChildResponses(dAVRequest, dAVPropFind, document, bl)) != null) {
                                int n = dAVResponseArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    vector.addElement(dAVResponseArray[n2]);
                                    ++n2;
                                }
                            }
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                    }
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
                var12_11 = null;
                resourceReference.unlock();
            }
            object = new DAVResponse[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public long getCreationDate() {
        return this.getLong(ATTR_CREATION_DATE, -1L);
    }

    protected int getCurrentLockDepth() {
        return this.getInt(ATTR_LOCK_DEPTH, -1);
    }

    protected Node getCurrentLockOwner(DAVRequest dAVRequest) {
        if (this.ownerNode == null) {
            String string = this.getString(ATTR_LOCK_OWNER, null);
            if (string != null) {
                Base64Decoder base64Decoder = new Base64Decoder(string);
                try {
                    String string2 = base64Decoder.processString();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                    Document document = DAVBody.getDocument(byteArrayInputStream, null);
                    this.ownerNode = document.getDocumentElement();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string == null && dAVRequest != null) {
                return (Node)dAVRequest.getState(LOCK_OWNER);
            }
        }
        return this.ownerNode;
    }

    protected long getCurrentLockTimeout(DAVRequest dAVRequest) {
        long l = this.getLong(ATTR_LOCK_TIMEOUT, -1L);
        if (l == -1L) {
            Long l2 = (Long)dAVRequest.getState(LOCK_TIMEOUT);
            if (l2 != null) {
                return l2;
            }
            return DEFAULT_LOCK_TIMEOUT;
        }
        return l;
    }

    protected String getCurrentLockToken(DAVRequest dAVRequest) {
        String string = this.getString(ATTR_LOCK_TOKEN, null);
        if (string == null && dAVRequest != null) {
            string = (String)dAVRequest.getState(LOCK_TOKEN);
        }
        return string;
    }

    protected String getCurrentLockUsername(DAVRequest dAVRequest) {
        String string = (String)this.getValue(ATTR_LOCK_USERNAME, null);
        if (string == null && dAVRequest != null) {
            string = (String)dAVRequest.getState(LOCK_USERNAME);
        }
        return string;
    }

    public ArrayDictionary getDeadProperties() {
        return (ArrayDictionary)this.getValue(ATTR_DEAD_PROPERTIES, null);
    }

    protected synchronized Hashtable getDeadPropertiesIndex() {
        if (this.deadindex == null) {
            ArrayDictionary arrayDictionary = this.getDeadProperties();
            if (arrayDictionary == null) {
                return new Hashtable();
            }
            Enumeration enumeration = arrayDictionary.keys();
            this.deadindex = new Hashtable(arrayDictionary.size());
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Base64Decoder base64Decoder = new Base64Decoder((String)arrayDictionary.get(string));
                try {
                    String string2 = base64Decoder.processString();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                    Document document = DAVBody.getDocument(byteArrayInputStream, null);
                    this.deadindex.put(string, document);
                }
                catch (Base64FormatException base64FormatException) {
                    base64FormatException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
        }
        return this.deadindex;
    }

    protected synchronized String getNewLockToken() {
        return "opaquelocktoken:" + new UUID().toString();
    }

    protected DAVProperties getPropNames(DAVRequest dAVRequest, Document document) {
        DAVProperties dAVProperties = DAVFactory.createProperties(document);
        Hashtable hashtable = this.getDeadPropertiesIndex();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Document document2 = (Document)hashtable.get(string);
            Element element = document2.getDocumentElement();
            try {
                DAVNode.exportChildren(document, dAVProperties.getNode(), element, false);
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
            }
        }
        if (this.hasStringProperty(HTTPFrame.ATTR_TITLE)) {
            dAVProperties.addProperty("displayname");
        }
        if (this.hasStringProperty(HTTPFrame.ATTR_CONTENT_LANGUAGE)) {
            dAVProperties.addProperty("getcontentlanguage");
        }
        if (this.getETag() != null) {
            dAVProperties.addProperty("getetag");
        }
        if (this.hasProperty(HTTPFrame.ATTR_CONTENT_TYPE)) {
            dAVProperties.addProperty("getcontenttype");
        }
        if (this.hasIntProperty(HTTPFrame.ATTR_CONTENT_LENGTH)) {
            dAVProperties.addProperty("getcontentlength");
        }
        if (this.hasLongProperty(ATTR_CREATION_DATE)) {
            dAVProperties.addProperty("creationdate");
        }
        if (this.getCurrentLockToken(dAVRequest) != null) {
            dAVProperties.addProperty("lockdiscovery");
        }
        dAVProperties.addProperty("getlastmodified");
        dAVProperties.addProperty("resourcetype");
        dAVProperties.addProperty("supportedlock");
        return dAVProperties;
    }

    protected DAVPropStat[] getPropStat(DAVRequest dAVRequest, Document document, DAVProperties dAVProperties) {
        DAVPropStat[] dAVPropStatArray;
        DAVProperties dAVProperties2 = DAVFactory.createProperties(document);
        DAVProperties dAVProperties3 = null;
        Element[] elementArray = dAVProperties.getProperties();
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node;
            dAVPropStatArray = elementArray[n2];
            String string = dAVPropStatArray.getNamespaceURI();
            String string2 = dAVPropStatArray.getLocalName();
            if (string == null || string.equals("DAV:")) {
                if (string2.equals("creationdate")) {
                    this.addCreationDate(dAVProperties2);
                } else if (string2.equals("displayname")) {
                    this.addDisplayName(dAVProperties2);
                } else if (string2.equals("getcontentlanguage")) {
                    this.addContentLanguage(dAVProperties2);
                } else if (string2.equals("getcontenttype")) {
                    this.addContentType(dAVProperties2);
                } else if (string2.equals("getcontentlength")) {
                    this.addContentLength(dAVProperties2);
                } else if (string2.equals("getetag")) {
                    this.addETag(dAVProperties2);
                } else if (string2.equals("getlastmodified")) {
                    this.addLastModified(dAVProperties2);
                } else if (string2.equals("lockdiscovery")) {
                    this.addLockDiscovery(dAVRequest, dAVProperties2);
                } else if (string2.equals("resourcetype")) {
                    this.addResourceType(dAVProperties2);
                } else if (!string2.equals("source")) {
                    if (string2.equals("supportedlock")) {
                        this.addSupportedLock(dAVProperties2);
                    } else {
                        if (dAVProperties3 == null) {
                            dAVProperties3 = DAVFactory.createProperties(document);
                        }
                        node = document.createElementNS("http://www.w3.org/Jigsaw/Webdav/", string2);
                        node.setPrefix("F");
                        DAVNode.addNodeNS(dAVProperties3.getNode(), node);
                    }
                }
            } else {
                Element element;
                DAVProperties dAVProperties4;
                Node node2;
                node = (Document)this.getDeadPropertiesIndex().get(string);
                if (node != null && (node2 = (dAVProperties4 = DAVFactory.createProperties(element = node.getDocumentElement())).getNodeNS(string2, string)) != null) {
                    dAVProperties2.addNodeNS(document.importNode(node2, true));
                }
            }
            ++n2;
        }
        dAVPropStatArray = null;
        if (dAVProperties3 != null) {
            dAVPropStatArray = new DAVPropStat[2];
            dAVPropStatArray[1] = DAVFactory.createPropStat(this.getStatusLine(404), document);
            dAVPropStatArray[1].addDAVNode(dAVProperties3);
        } else {
            dAVPropStatArray = new DAVPropStat[]{DAVFactory.createPropStat(this.getStatusLine(200), document)};
        }
        dAVPropStatArray[0].addDAVNode(dAVProperties2);
        return dAVPropStatArray;
    }

    protected DAVProperties getProperties(DAVRequest dAVRequest, Document document) {
        DAVProperties dAVProperties = DAVFactory.createProperties(document);
        this.addCreationDate(dAVProperties);
        this.addDisplayName(dAVProperties);
        this.addContentLanguage(dAVProperties);
        this.addContentLength(dAVProperties);
        this.addETag(dAVProperties);
        this.addLastModified(dAVProperties);
        this.addContentType(dAVProperties);
        this.addLockDiscovery(dAVRequest, dAVProperties);
        this.addResourceType(dAVProperties);
        this.addSupportedLock(dAVProperties);
        Hashtable hashtable = this.getDeadPropertiesIndex();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Document document2 = (Document)hashtable.get(string);
            Element element = document2.getDocumentElement();
            try {
                DAVNode.exportChildren(document, dAVProperties.getNode(), element, true);
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
            }
        }
        return dAVProperties;
    }

    protected DAVProperties getProperties(DAVRequest dAVRequest, Document document, DAVProperties dAVProperties) {
        DAVProperties dAVProperties2 = DAVFactory.createProperties(document);
        Element[] elementArray = dAVProperties.getProperties();
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = elementArray[n2];
            String string = element.getNamespaceURI();
            String string2 = element.getLocalName();
            if (string == null || string.equals("DAV:")) {
                if (string2.equals("creationdate")) {
                    this.addCreationDate(dAVProperties2);
                } else if (string2.equals("displayname")) {
                    this.addDisplayName(dAVProperties2);
                } else if (string2.equals("getcontentlanguage")) {
                    this.addContentLanguage(dAVProperties2);
                } else if (string2.equals("getcontenttype")) {
                    this.addContentType(dAVProperties2);
                } else if (string2.equals("getcontentlength")) {
                    this.addContentLength(dAVProperties2);
                } else if (string2.equals("getetag")) {
                    this.addETag(dAVProperties2);
                } else if (string2.equals("getlastmodified")) {
                    this.addLastModified(dAVProperties2);
                } else if (string2.equals("lockdiscovery")) {
                    this.addLockDiscovery(dAVRequest, dAVProperties2);
                } else if (string2.equals("resourcetype")) {
                    this.addResourceType(dAVProperties2);
                } else if (!string2.equals("source") && string2.equals("supportedlock")) {
                    this.addSupportedLock(dAVProperties2);
                }
            } else {
                Element element2;
                DAVProperties dAVProperties3;
                Node node;
                Document document2 = (Document)this.getDeadPropertiesIndex().get(string);
                if (document2 != null && (node = (dAVProperties3 = DAVFactory.createProperties(element2 = document2.getDocumentElement())).getNodeNS(string2, string)) != null) {
                    dAVProperties2.addNodeNS(document.importNode(node, true));
                }
            }
            ++n2;
        }
        return dAVProperties2;
    }

    protected DAVProperties getPropertiesForCopy(Document document) {
        DAVProperties dAVProperties = DAVFactory.createProperties(document);
        this.addDisplayName(dAVProperties);
        this.addContentLanguage(dAVProperties);
        this.addContentType(dAVProperties);
        Hashtable hashtable = this.getDeadPropertiesIndex();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Document document2 = (Document)hashtable.get(string);
            Element element = document2.getDocumentElement();
            try {
                DAVNode.exportChildren(document, dAVProperties.getNode(), element, true);
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
            }
        }
        return dAVProperties;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DAVResponse getResponse(DAVRequest dAVRequest, DAVPropFind dAVPropFind, Document document) {
        if (this.fresource != null) {
            this.fresource.checkContent();
        }
        this.updateCachedHeaders();
        DAVProperties dAVProperties = null;
        if (dAVPropFind == null) {
            dAVProperties = this.getProperties(dAVRequest, document);
            return DAVFactory.createPropStatResponse(this.getURL(dAVRequest).toExternalForm(), this.getStatusLine(200), dAVProperties, document);
        }
        if (dAVPropFind.findPropNames()) {
            dAVProperties = this.getPropNames(dAVRequest, document);
            return DAVFactory.createPropStatResponse(this.getURL(dAVRequest).toExternalForm(), this.getStatusLine(200), dAVProperties, document);
        }
        if (dAVPropFind.findAllProps()) {
            dAVProperties = this.getProperties(dAVRequest, document);
            return DAVFactory.createPropStatResponse(this.getURL(dAVRequest).toExternalForm(), this.getStatusLine(200), dAVProperties, document);
        }
        DAVProperties dAVProperties2 = dAVPropFind.getProperties();
        DAVPropStat[] dAVPropStatArray = this.getPropStat(dAVRequest, document, dAVProperties2);
        DAVResponse dAVResponse = DAVFactory.createResponse(this.getURL(dAVRequest).toExternalForm(), document);
        int n = 0;
        while (n < dAVPropStatArray.length) {
            dAVResponse.addDAVNode(dAVPropStatArray[n]);
            ++n;
        }
        return dAVResponse;
    }

    protected String getStatusLine(int n) {
        return "HTTP/1.1 " + n + " " + DAVReply.getDAVReason(n);
    }

    protected long getTokenExpirationDate(DAVRequest dAVRequest) {
        Long l;
        long l2 = this.getLong(ATTR_LOCK_TIMEOUT, -1L);
        long l3 = this.getLong(ATTR_LOCK_DATE, -1L);
        if (l3 != -1L && l2 != -1L) {
            return l3 + l2;
        }
        if (dAVRequest != null && (l = (Long)dAVRequest.getState(LOCK_EXPIRE)) != null) {
            return l;
        }
        return -1L;
    }

    protected boolean hasIntProperty(int n) {
        return this.getInt(n, -1) != -1;
    }

    private boolean hasLock() {
        return this.definesAttribute(ATTR_LOCK_TOKEN);
    }

    protected boolean hasLongProperty(int n) {
        return this.getLong(n, -1L) != -1L;
    }

    protected boolean hasProperty(int n) {
        return this.getValue(n, null) != null;
    }

    protected boolean hasStringProperty(int n) {
        String string = (String)this.getValue(n, (Object)"");
        return string.length() > 0;
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        if (this.getCreationDate() == -1L) {
            this.setValue(ATTR_CREATION_DATE, (Object)new Long(System.currentTimeMillis()));
        }
    }

    public boolean isCollection() {
        return this.dresource != null;
    }

    protected boolean isLockable(DAVRequest dAVRequest) {
        String string = dAVRequest.getMethod();
        return string.equals("PUT") || string.equals("POST") || string.equals("PROPATCH") || string.equals("LOCK") || string.equals("MOVE") || string.equals("DELETE") || string.equals("MKCOL");
    }

    protected boolean isLocked(DAVRequest dAVRequest) {
        if (this.hasLock()) {
            if (System.currentTimeMillis() > this.getTokenExpirationDate(null)) {
                this.unlock();
                return false;
            }
            return true;
        }
        return dAVRequest != null && dAVRequest.hasState(LOCK_TOKEN);
    }

    protected static boolean isReadOnly(String string) {
        return string.equals("creationdate") || string.equals("getcontentlength") || string.equals("getetag") || string.equals("getlastmodified");
    }

    protected synchronized void lock(String string, int n, String[] stringArray, String string2, Node node) throws HTTPException {
        this.setValue(ATTR_LOCK_TOKEN, (Object)string);
        if (string2 != null) {
            this.setValue(ATTR_LOCK_USERNAME, (Object)string2);
        }
        this.setValue(ATTR_LOCK_DEPTH, (Object)new Integer(n));
        this.setLockOwner(node);
        this.setTimeout(stringArray);
    }

    public synchronized Reply lock(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        DAVBody dAVBody = this.getBody(dAVRequest);
        if (dAVBody == null) {
            this.refreshLock(dAVRequest.getTimeout());
            Document document = DAVBody.createDocument("prop");
            this.addLockDiscovery(dAVRequest, document.getDocumentElement());
            Reply reply = this.createDAVReply(dAVRequest, 200, document);
            return reply;
        }
        String[] stringArray = dAVRequest.getTimeout();
        DAVLockInfo dAVLockInfo = dAVBody.getLockInfo();
        if (dAVLockInfo != null) {
            Node node = dAVLockInfo.getOwner();
            this.lock(this.getNewLockToken(), dAVRequest.getDepth(), dAVRequest.getTimeout(), (String)dAVRequest.getState("org.w3c.jigsaw.auth.AuthFilter.user"), node);
            Document document = DAVBody.createDocument("prop");
            this.addLockDiscovery(dAVRequest, document.getDocumentElement());
            Reply reply = this.createDAVReply(dAVRequest, 200, document);
            return reply;
        }
        Reply reply = dAVRequest.makeReply(400);
        reply.setContent("Invalid request: missing lockinfo");
        throw new HTTPException(reply);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean lookupDirectory(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Object object;
        DAVRequest dAVRequest = (DAVRequest)lookupState.getRequest();
        if (dAVRequest == null) {
            return super.lookupDirectory(lookupState, lookupResult);
        }
        if (this.isLocked(null)) {
            this.updateStates(dAVRequest);
        }
        if (lookupState.hasMoreComponents()) {
            String string;
            if (dAVRequest.getMethod().equals("PUT")) {
                String string2 = lookupState.peekNextComponent();
                object = this.dresource.lookup(string2);
                if (object == null && this.dresource.getExtensibleFlag() && this.getPutableFlag()) {
                    if (lookupState.countRemainingComponents() != 1) {
                        Reply reply = dAVRequest.makeReply(409);
                        reply.setContent(String.valueOf(string2) + " does not exists!");
                        throw new HTTPException(reply);
                    }
                    object = this.dresource.createResource(string2, dAVRequest);
                    if (object == null) {
                        Reply reply = dAVRequest.makeReply(415);
                        reply.setContent("Failed to create resource " + string2 + " : " + "Unable to create the appropriate file:" + dAVRequest.getURLPath() + " this media type is not supported");
                        throw new HTTPException(reply);
                    }
                } else if (object == null) {
                    Reply reply = dAVRequest.makeReply(403);
                    reply.setContent("You are not allowed to create resource " + string2 + " : " + this.dresource.getIdentifier() + " is not extensible.");
                    throw new HTTPException(reply);
                }
            } else if (dAVRequest.getMethod().equals("MKCOL") && (object = this.dresource.lookup(string = lookupState.peekNextComponent())) == null) {
                if (lookupState.countRemainingComponents() == 1) {
                    dAVRequest.setState(REMAINING_PATH, string);
                    return true;
                }
                Reply reply = dAVRequest.makeReply(409);
                reply.setContent("Can't create " + lookupState.getRemainingPath(true));
                throw new HTTPException(reply);
            }
        }
        if (!super.lookupOther(lookupState, lookupResult)) {
            return false;
        }
        if (!lookupState.isDirectory() && !lookupState.isInternal()) {
            void var4_10;
            if (dAVRequest == null) {
                lookupResult.setTarget(null);
                return true;
            }
            if (!DAVFrame.acceptRedirect(dAVRequest)) {
                return true;
            }
            Object var4_7 = null;
            try {
                if (dAVRequest != null && dAVRequest.hasState("org.w3c.jigsaw.http.Request.origurl")) {
                    object = (URL)dAVRequest.getState("org.w3c.jigsaw.http.Request.origurl");
                    URL uRL = new URL((URL)object, String.valueOf(((URL)object).getFile()) + "/");
                } else {
                    URL uRL = lookupState.hasRequest() ? this.getURL(dAVRequest) : new URL(this.getServer().getURL(), this.resource.getURLPath());
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.getServer().errlog(this, "unable to build full URL.");
                throw new HTTPException("Internal server error");
            }
            object = "Invalid requested URL: the directory resource  you are trying to reach is available only through  its full URL: <a href=\"" + var4_10 + "\">" + var4_10 + "</a>.";
            if (this.getRelocateFlag()) {
                Reply reply = dAVRequest.makeReply(302);
                reply.setContent((String)object);
                reply.setLocation((URL)var4_10);
                lookupResult.setTarget(null);
                lookupResult.setReply(reply);
                return true;
            }
            Reply reply = dAVRequest.makeReply(404);
            reply.setContent((String)object);
            lookupResult.setTarget(null);
            lookupResult.setReply(reply);
            return true;
        }
        if (!lookupState.isInternal() && DAVFrame.acceptRedirect(dAVRequest)) {
            dAVRequest.setState("org.w3c.jigsaw.frames.HTTPFrame.cl", "true");
            String[] stringArray = this.getIndexes();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    DirectoryResource directoryResource;
                    ResourceReference resourceReference;
                    String string = stringArray[n];
                    if (string != null && string.length() > 0 && (resourceReference = (directoryResource = (DirectoryResource)this.resource).lookup(string)) != null) {
                        Object var11_23;
                        try {
                            try {
                                FramedResource framedResource = (FramedResource)resourceReference.lock();
                                boolean bl = framedResource.lookup(lookupState, lookupResult);
                                var11_23 = null;
                                resourceReference.unlock();
                                return bl;
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                var11_23 = null;
                                resourceReference.unlock();
                            }
                        }
                        catch (Throwable throwable) {
                            var11_23 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                    ++n;
                }
            }
        }
        return true;
    }

    protected boolean lookupResource(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        DAVRequest dAVRequest = (DAVRequest)lookupState.getRequest();
        if (dAVRequest != null && this.isLocked(null)) {
            this.updateLockDate(dAVRequest);
        }
        return super.lookupResource(lookupState, lookupResult);
    }

    protected boolean matchETag(HttpEntityTag httpEntityTag) {
        HttpEntityTag httpEntityTag2 = this.getETag();
        if (httpEntityTag2 != null) {
            return httpEntityTag2.getTag().equals(httpEntityTag.getTag());
        }
        return false;
    }

    protected boolean matchLockToken(DAVRequest dAVRequest, String string) {
        return string.equals(this.getCurrentLockToken(dAVRequest));
    }

    public Reply mkcol(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        if (this.dresource != null) {
            String string = (String)dAVRequest.getState(REMAINING_PATH);
            if (string != null) {
                if (this.dresource.getExtensibleFlag() && this.getPutableFlag()) {
                    ResourceReference resourceReference = this.dresource.createDirectoryResource(string);
                    if (resourceReference == null) {
                        Reply reply = dAVRequest.makeReply(415);
                        reply.setContent("Failed to create collection " + string);
                        throw new HTTPException(reply);
                    }
                    Reply reply = dAVRequest.makeReply(201);
                    reply.setContent("<P>Collection " + string + " succesfully created");
                    return reply;
                }
                Reply reply = dAVRequest.makeReply(403);
                reply.setContent("The server doen't allow collection creation here.");
                throw new HTTPException(reply);
            }
            Reply reply = dAVRequest.makeReply(405);
            reply.setContent(String.valueOf(this.dresource.getIdentifier()) + " already exists!");
            throw new HTTPException(reply);
        }
        Reply reply = dAVRequest.makeReply(405);
        reply.setContent(String.valueOf(this.dresource.getIdentifier()) + " already exists!");
        throw new HTTPException(reply);
    }

    public Reply move(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        if (this.getAllowDeleteFlag()) {
            Reply reply = this.copy(dAVRequest);
            int n = reply.getStatus();
            if (n == 204 || n == 201) {
                this.delete(dAVRequest);
                return reply;
            }
            return reply;
        }
        Reply reply = dAVRequest.makeReply(405);
        reply.setContent("Method MOVE not allowed.");
        reply.setHeaderValue(HttpEntityMessage.H_ALLOW, (HeaderValue)this.getAllow());
        throw new HTTPException(reply);
    }

    private HTTPException notYetImplemented(DAVRequest dAVRequest) throws ProtocolException {
        Reply reply = dAVRequest.makeReply(501);
        reply.setContent("Method " + dAVRequest.getMethod() + " not implemented.");
        throw new HTTPException(reply);
    }

    public Reply options(Request request) throws ProtocolException, ResourceException {
        DAVReply dAVReply = (DAVReply)super.options(request);
        dAVReply.setDAV("1");
        return dAVReply;
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        if (requestInterface instanceof DAVRequest) {
            DAVRequest dAVRequest = (DAVRequest)requestInterface;
            int n = this.checkIf(dAVRequest);
            if (n == 1) {
                dAVRequest.skipBody();
                Reply reply = dAVRequest.makeReply(412);
                reply.setContent("Pre-conditions failed.");
                reply.setContentMD5(null);
                return reply;
            }
            if (n == 2 || n == 0) {
                if (this.isLockable(dAVRequest) && this.isLocked(dAVRequest)) {
                    dAVRequest.skipBody();
                    Reply reply = dAVRequest.makeReply(423);
                    reply.setContent("The resource is locked");
                    return reply;
                }
            } else if (n == 3 && !this.checkLockOwner(dAVRequest)) {
                Reply reply = dAVRequest.makeReply(423);
                reply.setContent("The resource is locked");
                return reply;
            }
        }
        return super.perform(requestInterface);
    }

    public Reply post(Request request) throws ProtocolException, ResourceException {
        return super.post(request);
    }

    public Reply propfind(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        int n = dAVRequest.getDepth();
        DAVBody dAVBody = this.getBody(dAVRequest);
        Document document = DAVBody.createDocument("multistatus");
        DAVMultiStatus dAVMultiStatus = DAVFactory.createMultiStatus(document.getDocumentElement());
        DAVPropFind dAVPropFind = null;
        DAVResponse dAVResponse = null;
        if (dAVBody != null) {
            dAVPropFind = dAVBody.getPropFind();
        }
        switch (n) {
            case 0: {
                dAVResponse = this.getResponse(dAVRequest, dAVPropFind, document);
                dAVMultiStatus.addDAVNode(dAVResponse);
                break;
            }
            case 1: {
                dAVResponse = this.getResponse(dAVRequest, dAVPropFind, document);
                dAVMultiStatus.addDAVNode(dAVResponse);
                dAVMultiStatus.addDAVNodes(this.getChildResponses(dAVRequest, dAVPropFind, document, false));
                break;
            }
            default: {
                dAVResponse = this.getResponse(dAVRequest, dAVPropFind, document);
                dAVMultiStatus.addDAVNode(dAVResponse);
                dAVMultiStatus.addDAVNodes(this.getChildResponses(dAVRequest, dAVPropFind, document, true));
            }
        }
        return this.createDAVReply(dAVRequest, 207, document);
    }

    /*
     * Unable to fully structure code
     */
    public Reply proppatch(DAVRequest var1_1) throws ProtocolException, ResourceException {
        var2_2 = this.values;
        var3_3 = this.getBody(var1_1);
        var4_4 = DAVBody.createDocument("multistatus");
        var5_5 = DAVFactory.createResponse(this.getURL(var1_1).toExternalForm(), var4_4);
        var4_4.getDocumentElement().appendChild(var5_5.getNode());
        if (var3_3 != null && (var6_6 = var3_3.getPropertyUpdate()) != null) {
            block10: {
                var7_7 = var6_6.getActions();
                var8_8 = null;
                var9_9 = var7_7.length;
                try {
                    var10_10 = 0;
                    while (var10_10 < var9_9) {
                        var11_12 = var7_7[var10_10];
                        switch (var11_12.getAction()) {
                            case 1: {
                                var8_8 = this.setDAVProperties(var11_12.getProperties(), var4_4);
                                break;
                            }
                            case 2: {
                                var8_8 = this.removeDAVProperties(var11_12.getProperties(), var4_4);
                                break;
                            }
                            default: {
                                var12_14 = var1_1.makeReply(400);
                                var12_14.setContent("Invalid request");
                                throw new HTTPException(var12_14);
                            }
                        }
                        if (var8_8 != null) {
                            var5_5.addDAVNode(var8_8);
                        }
                        ++var10_10;
                    }
                    this.saveDeadProperties();
                    break block10;
                }
                catch (DAVPropertyException var10_11) {
                    this.reloadDeadProperties();
                    this.values = var2_2;
                    var11_13 = (DAVPropStat[])var10_11.getReason();
                    var12_15 = 0;
                    ** while (var12_15 < var11_13.length)
                }
lbl-1000:
                // 1 sources

                {
                    var5_5.addDAVNode(var11_13[var12_15]);
                    ++var12_15;
                    continue;
                }
lbl41:
                // 1 sources

                var5_5.setDescription(var10_11.getMessage());
            }
            return this.createDAVReply(var1_1, 207, var4_4);
        }
        var6_6 = var1_1.makeReply(400);
        var6_6.setContent("Invalid request");
        throw new HTTPException((Reply)var6_6);
    }

    public Reply put(Request request) throws ProtocolException, ResourceException {
        return super.put(request);
    }

    protected synchronized void refreshLock(String[] stringArray) {
        this.setTimeout(stringArray);
    }

    public void registerResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        ObservableProperties observableProperties = this.getResource().getServer().getProperties();
        this.manager = DAVManager.getDAVManager(observableProperties);
    }

    protected synchronized void reloadDeadProperties() {
        this.deadindex = null;
        this.deadpropmodified = false;
    }

    protected DAVPropStat removeDAVProperties(DAVProperties dAVProperties, Document document) throws DAVPropertyException {
        Element[] elementArray = dAVProperties.getProperties();
        int n = elementArray.length;
        DAVProperties dAVProperties2 = DAVFactory.createProperties(document);
        try {
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                String string = element.getNamespaceURI();
                if (string == null || string.equals("DAV:")) {
                    this.removeLiveProperty(DAVFactory.createDAVNode(element), dAVProperties2, document);
                } else {
                    this.removeDeadProperty(DAVFactory.createDAVNode(element), dAVProperties2, document);
                }
                ++n2;
            }
        }
        catch (DAVPropertyException dAVPropertyException) {
            DAVPropStat dAVPropStat = (DAVPropStat)dAVPropertyException.getReason();
            String string = dAVPropertyException.getMessage();
            DAVPropStat[] dAVPropStatArray = null;
            if (dAVProperties2.getNode().hasChildNodes()) {
                DAVPropStat dAVPropStat2 = DAVFactory.createPropStat(this.getStatusLine(200), dAVProperties2, document);
                dAVPropStatArray = new DAVPropStat[]{dAVPropStat2, dAVPropStat};
            } else {
                dAVPropStatArray = new DAVPropStat[]{dAVPropStat};
            }
            throw new DAVPropertyException(string, dAVPropStatArray);
        }
        if (dAVProperties2.getNode().hasChildNodes()) {
            return DAVFactory.createPropStat(this.getStatusLine(200), dAVProperties2, document);
        }
        return null;
    }

    protected synchronized void removeDeadProperty(Element element) throws DOMException {
        Object object;
        String string = element.getNodeName();
        String string2 = element.getNamespaceURI();
        if (string2 == null) {
            throw new DOMException(14, "Missing namespace");
        }
        Document document = (Document)this.getDeadPropertiesIndex().get(string2);
        if (document != null) {
            object = document.getDocumentElement();
            DAVProperties dAVProperties = DAVFactory.createProperties((Element)object);
            Element[] elementArray = dAVProperties.getProperties();
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element element2 = elementArray[n2];
                if (element2.getNamespaceURI().equals(string2) && element2.getLocalName().equals(element.getLocalName())) {
                    object.removeChild(element2);
                    this.deadpropmodified = true;
                    return;
                }
                ++n2;
            }
        }
        object = String.valueOf(element.getLocalName()) + " property cannot be removed, not found";
        throw new DOMException(8, (String)object);
    }

    protected void removeDeadProperty(DAVNode dAVNode, DAVProperties dAVProperties, Document document) throws DAVPropertyException {
        Node node = dAVNode.getNode();
        String string = node.getLocalName();
        try {
            if (node.getNodeType() != 1) {
                DAVPropStat dAVPropStat = DAVFactory.createPropStatNS(this.getStatusLine(409), document.importNode(node, false), document);
                String string2 = "Invalid XML : " + string;
                throw new DAVPropertyException(string2, dAVPropStat);
            }
            Element element = (Element)node;
            this.removeDeadProperty(element);
            dAVProperties.addNodeNS(document.importNode(element, false));
        }
        catch (DOMException dOMException) {
            DAVPropStat dAVPropStat = DAVFactory.createPropStatNS(this.getStatusLine(409), document.importNode(node, false), document);
            throw new DAVPropertyException(dOMException.getMessage(), dAVPropStat);
        }
    }

    protected void removeLiveProperty(DAVNode dAVNode, DAVProperties dAVProperties, Document document) throws DAVPropertyException {
        String string = dAVNode.getNode().getLocalName();
        String string2 = dAVNode.getTextValue();
        if (string.equals("displayname")) {
            this.setValue(HTTPFrame.ATTR_TITLE, (Object)"");
            dAVProperties.addProperty(string);
        } else if (string.equals("getcontentlanguage")) {
            this.setValue(HTTPFrame.ATTR_CONTENT_LANGUAGE, null);
            dAVProperties.addProperty(string);
        } else {
            try {
                this.removeDeadProperty(dAVNode, dAVProperties, document);
            }
            catch (DAVPropertyException dAVPropertyException) {
                DAVPropStat dAVPropStat = DAVFactory.createPropStat(this.getStatusLine(409), string, document);
                throw new DAVPropertyException(String.valueOf(string) + " cannot be removed", dAVPropStat);
            }
        }
    }

    protected synchronized void saveDeadProperties() {
        if (this.deadpropmodified) {
            ArrayDictionary arrayDictionary = new ArrayDictionary(this.deadindex.size());
            Enumeration enumeration = this.deadindex.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Document document = (Document)this.deadindex.get(string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputFormat outputFormat = new OutputFormat(document, "utf-8", true);
                outputFormat.setOmitXMLDeclaration(false);
                outputFormat.setPreserveSpace(true);
                XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
                try {
                    xMLSerializer.serialize(document);
                    Base64Encoder base64Encoder = new Base64Encoder(byteArrayOutputStream.toString("utf-8"));
                    arrayDictionary.put(string, base64Encoder.processString());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.setValue(ATTR_DEAD_PROPERTIES, (Object)arrayDictionary);
            this.deadpropmodified = false;
        }
    }

    private synchronized void saveLockOwner() {
        block2: {
            if (this.ownerNode == null) break block2;
            Document document = DAVBody.createDocument("owner");
            DAVNode.exportChildren(document, document.getDocumentElement(), this.ownerNode, true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputFormat outputFormat = new OutputFormat(document, "utf-8", true);
            outputFormat.setOmitXMLDeclaration(false);
            outputFormat.setPreserveSpace(true);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
            try {
                xMLSerializer.serialize(document);
                Base64Encoder base64Encoder = new Base64Encoder(byteArrayOutputStream.toString("utf-8"));
                this.setValue(ATTR_LOCK_OWNER, (Object)base64Encoder.processString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected DAVPropStat setDAVProperties(DAVProperties dAVProperties, Document document) throws DAVPropertyException {
        Element[] elementArray = dAVProperties.getProperties();
        int n = elementArray.length;
        DAVProperties dAVProperties2 = DAVFactory.createProperties(document);
        try {
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                String string = element.getNamespaceURI();
                if (string == null || string.equals("DAV:")) {
                    this.setLiveProperty(DAVFactory.createDAVNode(element), dAVProperties2, document);
                } else {
                    this.setDeadProperty(DAVFactory.createDAVNode(element), dAVProperties2, document);
                }
                ++n2;
            }
        }
        catch (DAVPropertyException dAVPropertyException) {
            DAVPropStat dAVPropStat = (DAVPropStat)dAVPropertyException.getReason();
            String string = dAVPropertyException.getMessage();
            DAVPropStat[] dAVPropStatArray = null;
            if (dAVProperties2.getNode().hasChildNodes()) {
                DAVPropStat dAVPropStat2 = DAVFactory.createPropStat(this.getStatusLine(200), dAVProperties2, document);
                dAVPropStatArray = new DAVPropStat[]{dAVPropStat2, dAVPropStat};
            } else {
                dAVPropStatArray = new DAVPropStat[]{dAVPropStat};
            }
            throw new DAVPropertyException(string, dAVPropStatArray);
        }
        if (dAVProperties2.getNode().hasChildNodes()) {
            return DAVFactory.createPropStat(this.getStatusLine(200), dAVProperties2, document);
        }
        return null;
    }

    protected synchronized void setDeadProperty(Element element) throws DOMException {
        String string;
        if (this.deadindex == null) {
            this.deadindex = new Hashtable();
        }
        if ((string = element.getNamespaceURI()) == null) {
            throw new DOMException(14, "Missing namespace.");
        }
        Document document = (Document)this.getDeadPropertiesIndex().get(string);
        if (document == null) {
            document = DAVBody.createDocumentNS("prop", string, element.getPrefix());
            Element element2 = document.getDocumentElement();
            Node node = document.importNode(element, true);
            element2.appendChild(node);
            this.deadindex.put(string, document);
            this.deadpropmodified = true;
        } else {
            Element element3 = document.getDocumentElement();
            DAVProperties dAVProperties = DAVFactory.createProperties(element3);
            Element[] elementArray = dAVProperties.getProperties();
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element element4 = elementArray[n2];
                if (element4.getNamespaceURI().equals(string) && element4.getLocalName().equals(element.getLocalName())) {
                    element3.replaceChild(document.importNode(element, true), element4);
                    this.deadpropmodified = true;
                    return;
                }
                ++n2;
            }
            element3.appendChild(document.importNode(element, true));
            this.deadpropmodified = true;
        }
    }

    protected void setDeadProperty(DAVNode dAVNode, DAVProperties dAVProperties, Document document) throws DAVPropertyException {
        Node node = dAVNode.getNode();
        String string = node.getLocalName();
        try {
            if (node.getNodeType() != 1) {
                DAVPropStat dAVPropStat = DAVFactory.createPropStatNS(this.getStatusLine(409), document.importNode(node, false), document);
                String string2 = "Invalid XML : " + string;
                throw new DAVPropertyException(string2, dAVPropStat);
            }
            Element element = (Element)node;
            this.setDeadProperty(element);
            dAVProperties.addNodeNS(document.importNode(element, false));
        }
        catch (DOMException dOMException) {
            DAVPropStat dAVPropStat = DAVFactory.createPropStatNS(this.getStatusLine(409), document.importNode(node, false), document);
            throw new DAVPropertyException(dOMException.getMessage(), dAVPropStat);
        }
    }

    protected void setLiveProperty(DAVNode dAVNode, DAVProperties dAVProperties, Document document) throws DAVPropertyException {
        String string = dAVNode.getNode().getLocalName();
        String string2 = dAVNode.getTextValue();
        if (string.equals("displayname")) {
            this.setValue(HTTPFrame.ATTR_TITLE, (Object)string2);
            dAVProperties.addProperty(string);
        } else if (string.equals("getcontentlanguage")) {
            this.setValue(HTTPFrame.ATTR_CONTENT_LANGUAGE, (Object)string2);
            dAVProperties.addProperty(string);
        } else if (!string.equals("source") && !string.equals("resourcetype")) {
            if (string.equals("getcontenttype")) {
                try {
                    MimeType mimeType = new MimeType(string2);
                    this.setValue(HTTPFrame.ATTR_CONTENT_TYPE, (Object)mimeType);
                    dAVProperties.addProperty(string);
                }
                catch (MimeTypeFormatException mimeTypeFormatException) {
                    DAVPropStat dAVPropStat = DAVFactory.createPropStat(this.getStatusLine(409), string, document);
                    String string3 = "Invalid value for " + string + " : " + string2;
                    throw new DAVPropertyException(string3, dAVPropStat);
                }
            } else {
                if (DAVFrame.isReadOnly(string)) {
                    DAVPropStat dAVPropStat = DAVFactory.createPropStat(this.getStatusLine(403), string, document);
                    throw new DAVPropertyException(String.valueOf(string) + " cannot be modified", dAVPropStat);
                }
                this.setDeadProperty(dAVNode, dAVProperties, document);
            }
        }
    }

    protected void setLockOwner(Node node) {
        this.ownerNode = node;
        this.saveLockOwner();
    }

    protected void setTimeout(String[] stringArray) {
        this.setValue(ATTR_LOCK_DATE, (Object)new Long(System.currentTimeMillis()));
        this.setValue(ATTR_LOCK_TIMEOUT, (Object)DEFAULT_LOCK_TIMEOUT);
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].startsWith("Second-")) {
                    String string = stringArray[n2].substring(7);
                    long l = Long.parseLong(string) * 1000L;
                    if (l > MAX_LOCK_TIMEOUT) {
                        this.setValue(ATTR_LOCK_TIMEOUT, (Object)MAX_LOCK_TIMEOUT);
                        break;
                    }
                    if (l > 0L) {
                        this.setValue(ATTR_LOCK_TIMEOUT, (Object)new Long(l));
                        break;
                    }
                    this.setValue(ATTR_LOCK_TIMEOUT, (Object)DEFAULT_LOCK_TIMEOUT);
                    break;
                }
                ++n2;
            }
        }
    }

    protected void skipBody(org.w3c.www.protocol.webdav.DAVReply dAVReply) {
        block7: {
            try {
                if (!dAVReply.hasInputStream()) break block7;
                InputStream inputStream = dAVReply.getInputStream();
                byte[] byArray = new byte[256];
                try {
                    while (inputStream.read(byArray) != -1) {
                    }
                }
                catch (IOException iOException) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void unlock() {
        this.setValue(ATTR_LOCK_TOKEN, null);
        this.setValue(ATTR_LOCK_DEPTH, null);
        this.setValue(ATTR_LOCK_TIMEOUT, null);
        this.setValue(ATTR_LOCK_DATE, null);
        this.setValue(ATTR_LOCK_OWNER, null);
        this.setValue(ATTR_LOCK_USERNAME, null);
    }

    public synchronized Reply unlock(DAVRequest dAVRequest) throws ProtocolException, ResourceException {
        if (!this.isLocked(dAVRequest)) {
            return dAVRequest.makeReply(204);
        }
        String string = dAVRequest.getLockToken();
        if (string != null) {
            String string2 = this.getCurrentLockToken(dAVRequest);
            String string3 = this.decodeURL(dAVRequest, string);
            if (string3.equals(string2) && this.checkLockOwner(dAVRequest)) {
                if (this.definesAttribute(ATTR_LOCK_TOKEN)) {
                    this.unlock();
                } else {
                    ResourceReference resourceReference = (ResourceReference)dAVRequest.getState(LOCKED_REREFENCE);
                    if (resourceReference == null) {
                        Reply reply = dAVRequest.makeReply(500);
                        reply.setContent("Unable to unlock, no request state");
                        throw new HTTPException(reply);
                    }
                    try {
                        try {
                            DAVFrame dAVFrame = (DAVFrame)resourceReference.lock();
                            dAVFrame.unlock();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Reply reply = dAVRequest.makeReply(500);
                            reply.setContent(exception.getMessage());
                            throw new HTTPException(reply);
                        }
                        Object var7_13 = null;
                        resourceReference.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var7_14 = null;
                        resourceReference.unlock();
                        throw throwable;
                    }
                }
                return dAVRequest.makeReply(204);
            }
            Reply reply = dAVRequest.makeReply(423);
            reply.setContent("The resource is locked");
            return reply;
        }
        Reply reply = dAVRequest.makeReply(403);
        reply.setContent("You are not allowed to unlock this resource");
        throw new HTTPException(reply);
    }

    protected void updateLockDate(DAVRequest dAVRequest) {
        if (this.checkLockOwner(dAVRequest)) {
            this.setValue(ATTR_LOCK_DATE, (Object)new Long(System.currentTimeMillis()));
        }
    }

    private void updateStates(DAVRequest dAVRequest) {
        if (this.getCurrentLockDepth() == -1) {
            dAVRequest.setState(LOCKED_REREFENCE, this.getResourceReference());
            dAVRequest.setState(LOCK_OWNER, this.getCurrentLockOwner(null));
            dAVRequest.setState(LOCK_TOKEN, this.getCurrentLockToken(null));
            dAVRequest.setState(LOCK_USERNAME, this.getCurrentLockUsername(null));
            dAVRequest.setState(LOCK_EXPIRE, new Long(this.getTokenExpirationDate(null)));
            dAVRequest.setState(LOCK_TIMEOUT, this.getValue(ATTR_LOCK_TIMEOUT, (Object)DEFAULT_LOCK_TIMEOUT));
        }
    }
}

