/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.servlet.JigsawHttpServletRequest;
import org.w3c.jigsaw.servlet.JigsawServletOutputStream;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpAcceptCharsetList;
import org.w3c.www.http.HttpAcceptEncodingList;
import org.w3c.www.http.HttpAcceptLanguageList;
import org.w3c.www.http.HttpAcceptList;
import org.w3c.www.http.HttpCookie;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpEntityTagList;
import org.w3c.www.http.HttpExt;
import org.w3c.www.http.HttpExtList;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpParamList;
import org.w3c.www.http.HttpRangeList;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.http.HttpSetCookieList;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.http.HttpWarningList;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;
import org.w3c.www.mime.Utils;

public class JigsawHttpServletResponse
implements HttpServletResponse {
    public static final String CHARSET_PARAMETER = "charset";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int MIN_BUFFER_SIZE = 4096;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_HEADERS_DONE = 1;
    private static final int STATE_ALL_DONE = 2;
    private static final int STREAM_STATE_INITIAL = 0;
    private static final int STREAM_WRITER_USED = 1;
    private static final int OUTPUT_STREAM_USED = 2;
    private int stream_state = 0;
    private JigsawServletOutputStream output = null;
    private PrintWriter writer = null;
    private MimeTypeFormatException setContentTypeException = null;
    private static final int CALC_CONTENT_LENGTH = -1;
    private int fixedContentLength = -1;
    protected Locale locale;
    protected ByteArrayOutputStream out = null;
    protected PipedOutputStream pout = null;
    protected JigsawHttpServletRequest jrequest = null;
    protected int buffer_size;
    public static final String INCLUDED = "org.w3c.jigsaw.servlet.included";
    public static final String STREAM = "org.w3c.jigsaw.servlet.stream";
    public static final String MONITOR = "org.w3c.jigsaw.servlet.monitor";
    int state = 0;
    Reply reply = null;
    Request request = null;

    JigsawHttpServletResponse(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        this.buffer_size = 8192;
    }

    public void addCookie(Cookie cookie) {
        HttpSetCookieList httpSetCookieList = this.reply.getSetCookie();
        if (httpSetCookieList == null) {
            HttpSetCookie[] httpSetCookieArray = new HttpSetCookie[]{this.convertCookie(cookie)};
            httpSetCookieList = new HttpSetCookieList(httpSetCookieArray);
        } else {
            httpSetCookieList.addSetCookie(this.convertCookie(cookie));
        }
        this.reply.setSetCookie(httpSetCookieList);
    }

    public void addDateHeader(String string, long l) {
        this.addHeader(string, HttpFactory.makeDate(l).toExternalForm());
    }

    public void addHeader(String string, String string2) {
        String string3 = string.toLowerCase();
        HeaderValue headerValue = this.reply.getHeaderValue(string3);
        if (headerValue == null) {
            this.setHeader(string, string2);
        } else if (headerValue instanceof HttpAcceptCharsetList) {
            HttpAcceptCharsetList httpAcceptCharsetList = (HttpAcceptCharsetList)headerValue;
            httpAcceptCharsetList.addCharset(HttpFactory.parseAcceptCharset(string2));
        } else if (headerValue instanceof HttpAcceptEncodingList) {
            HttpAcceptEncodingList httpAcceptEncodingList = (HttpAcceptEncodingList)headerValue;
            httpAcceptEncodingList.addEncoding(HttpFactory.parseAcceptEncoding(string2));
        } else if (headerValue instanceof HttpAcceptLanguageList) {
            HttpAcceptLanguageList httpAcceptLanguageList = (HttpAcceptLanguageList)headerValue;
            httpAcceptLanguageList.addLanguage(HttpFactory.parseAcceptLanguage(string2));
        } else if (headerValue instanceof HttpAcceptList) {
            HttpAcceptList httpAcceptList = (HttpAcceptList)headerValue;
            httpAcceptList.addAccept(HttpFactory.parseAccept(string2));
        } else if (headerValue instanceof HttpEntityTagList) {
            HttpEntityTagList httpEntityTagList = (HttpEntityTagList)headerValue;
            httpEntityTagList.addTag(HttpFactory.parseETag(string2));
        } else if (headerValue instanceof HttpExtList) {
            HttpExtList httpExtList = (HttpExtList)headerValue;
            httpExtList.addHttpExt(new HttpExt(string2, false));
        } else if (headerValue instanceof HttpCookieList) {
            HttpCookieList httpCookieList = (HttpCookieList)headerValue;
            HttpCookieList httpCookieList2 = HttpFactory.parseCookieList(string2);
            HttpCookie[] httpCookieArray = httpCookieList2.getCookies();
            int n = 0;
            while (n < httpCookieArray.length) {
                HttpCookie httpCookie = httpCookieArray[n];
                httpCookieList.addCookie(httpCookie.getName(), httpCookie.getValue());
                ++n;
            }
        } else if (headerValue instanceof HttpParamList) {
            int n = string2.indexOf(61);
            if (n != -1) {
                String string4 = string2.substring(0, n);
                String string5 = string2.substring(n + 1);
                HttpParamList httpParamList = (HttpParamList)headerValue;
                httpParamList.setParameter(string4, string5);
            }
        } else if (headerValue instanceof HttpRangeList) {
            HttpRangeList httpRangeList = (HttpRangeList)headerValue;
            httpRangeList.addRange(HttpFactory.parseRange(string2));
        } else if (headerValue instanceof HttpSetCookieList) {
            HttpSetCookieList httpSetCookieList = (HttpSetCookieList)headerValue;
            HttpSetCookieList httpSetCookieList2 = HttpFactory.parseSetCookieList(string2);
            HttpSetCookie[] httpSetCookieArray = httpSetCookieList2.getSetCookies();
            int n = 0;
            while (n < httpSetCookieArray.length) {
                httpSetCookieList.addSetCookie(httpSetCookieArray[n]);
                ++n;
            }
        } else if (headerValue instanceof HttpTokenList) {
            ((HttpTokenList)headerValue).addToken(string2, true);
        } else if (headerValue instanceof HttpWarningList) {
            HttpWarningList httpWarningList = (HttpWarningList)headerValue;
            httpWarningList.addWarning(HttpFactory.parseWarning(string2));
        } else if (headerValue instanceof HttpString) {
            HttpString httpString = (HttpString)headerValue;
            String string6 = (String)httpString.getValue();
            httpString.setValue(String.valueOf(string6) + ", " + string2);
        } else {
            this.setHeader(string, string2);
        }
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, String.valueOf(n));
    }

    public boolean containsHeader(String string) {
        return this.reply.hasHeader(string);
    }

    private HttpSetCookie convertCookie(Cookie cookie) {
        HttpSetCookie httpSetCookie = new HttpSetCookie(true, cookie.getName(), cookie.getValue());
        httpSetCookie.setComment(cookie.getComment());
        httpSetCookie.setDomain(cookie.getDomain());
        httpSetCookie.setMaxAge(cookie.getMaxAge());
        httpSetCookie.setPath(cookie.getPath());
        httpSetCookie.setSecurity(cookie.getSecure());
        httpSetCookie.setVersion(cookie.getVersion());
        return httpSetCookie;
    }

    public String encodeRedirectURL(String string) {
        return this.encodeRedirectUrl(string);
    }

    public String encodeRedirectUrl(String string) {
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(this.jrequest.getRequestURI());
            if (uRL.getHost().equals(uRL2.getHost()) && uRL.getPort() == uRL2.getPort()) {
                return this.encodeUrl(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
        return string;
    }

    public String encodeURL(String string) {
        return this.encodeUrl(string);
    }

    public String encodeUrl(String string) {
        if (!this.jrequest.isRequestedSessionIdFromCookie()) {
            string = String.valueOf(string) + (string.indexOf("?") != -1 ? "&" : "?") + this.jrequest.getCookieName() + "=" + this.jrequest.getSession(true).getId();
        }
        return string;
    }

    public void flushBuffer() throws IOException {
        if (this.output != null) {
            if (this.stream_state == 1) {
                this.writer.flush();
            }
            this.output.flush();
        }
    }

    protected synchronized void flushStream(boolean bl) throws IOException {
        if (this.state == 2) {
            return;
        }
        if (this.stream_state == 2) {
            this.output.flush();
        } else if (this.stream_state == 1) {
            this.writer.flush();
            if (bl) {
                this.output.realFlush();
            } else {
                this.output.flush();
            }
        } else {
            this.getWriter();
            this.writer.flush();
            this.output.realFlush();
        }
        if (this.request.hasState(INCLUDED)) {
            if (this.out == null) {
                return;
            }
            int n = this.fixedContentLength != -1 ? (this.out.size() < this.fixedContentLength ? this.out.size() : this.fixedContentLength) : this.out.size();
            this.reply.setContentLength(n);
            OutputStream outputStream = this.reply.getOutputStream(false);
            byte[] byArray = this.out.toByteArray();
            if (bl) {
                this.out.close();
            } else {
                this.out.reset();
            }
            outputStream.write(byArray);
            outputStream.flush();
        } else if (this.pout != null && bl) {
            this.pout.flush();
            this.pout.close();
        }
    }

    public int getBufferSize() {
        return this.buffer_size;
    }

    public String getCharacterEncoding() {
        MimeType mimeType = this.reply.getContentType();
        if (mimeType != null && mimeType.hasParameter(CHARSET_PARAMETER)) {
            return mimeType.getParameterValue(CHARSET_PARAMETER);
        }
        return System.getProperty("file.encoding");
    }

    protected ServletOutputStream getJigsawOutputStream(boolean bl) throws IOException {
        if (this.output != null) {
            return this.output;
        }
        if (this.setContentTypeException != null) {
            throw new IOException("Illegal Content Type: " + this.setContentTypeException.toString());
        }
        if (this.request.hasState(INCLUDED)) {
            this.out = new ByteArrayOutputStream();
            this.output = new JigsawServletOutputStream(this, new DataOutputStream(this.out), this.buffer_size, bl);
        } else {
            Object object;
            if (this.reply.hasState(STREAM)) {
                try {
                    this.pout = (PipedOutputStream)this.reply.getState(STREAM);
                    object = new DataOutputStream(this.pout);
                    this.output = new JigsawServletOutputStream(this, (DataOutputStream)object, this.buffer_size, bl);
                }
                catch (ClassCastException classCastException) {
                    this.output = new JigsawServletOutputStream(this, this.reply, this.buffer_size, bl);
                }
            } else {
                this.output = new JigsawServletOutputStream(this, this.reply, this.buffer_size, bl);
            }
            if (this.reply.hasState(STREAM)) {
                this.reply.setState(STREAM, null);
            }
            if ((object = this.reply.getState(MONITOR)) != null) {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        }
        return this.output;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public synchronized ServletOutputStream getOutputStream() throws IOException {
        if (this.stream_state == 1) {
            throw new IllegalStateException("Writer used");
        }
        this.stream_state = 2;
        return this.getJigsawOutputStream(false);
    }

    protected Reply getReply() {
        return this.reply;
    }

    public synchronized PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        if (this.stream_state == 2) {
            throw new IllegalStateException("Output stream used");
        }
        this.stream_state = 1;
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getJigsawOutputStream(true), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public boolean isCommitted() {
        if (this.output != null) {
            return this.output.isCommitted();
        }
        return false;
    }

    protected boolean isStreamObtained() {
        return this.stream_state != 0;
    }

    public void reset() {
        if (this.output != null) {
            if (this.stream_state == 1) {
                this.writer.flush();
            }
            this.output.reset();
        }
    }

    public void sendError(int n) throws IOException {
        this.setStatus(n);
        this.reply.setContent(this.reply.getStandardReason(n));
        this.state = 2;
        this.reply.setState(STREAM, new Object());
    }

    public void sendError(int n, String string) throws IOException {
        this.setStatus(n);
        this.reply.setContent(string);
        this.state = 2;
        this.reply.setState(STREAM, new Object());
    }

    public void sendRedirect(String string) throws IOException {
        URL uRL = null;
        try {
            String string2 = this.jrequest.getRequestURI();
            URL uRL2 = this.request.getURL();
            uRL = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string2);
            uRL = new URL(uRL, string);
            this.setStatus(302);
            this.reply.setLocation(uRL);
            HtmlGenerator htmlGenerator = new HtmlGenerator("Moved");
            htmlGenerator.append("<P>This resource has moved, click on the link if your browser doesn't support automatic redirection<BR><A HREF=\"" + uRL.toExternalForm() + "\">" + uRL.toExternalForm() + "</A>");
            this.reply.setStream(htmlGenerator);
            this.state = 2;
            this.reply.setState(STREAM, new Object());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBufferSize(int n) {
        if (this.stream_state != 0) {
            throw new IllegalStateException("Stream already initialized");
        }
        this.buffer_size = n < 4096 ? 4096 : n;
    }

    public void setContentLength(int n) {
        this.fixedContentLength = n;
        this.reply.setContentLength(n);
    }

    public void setContentType(String string) {
        try {
            MimeType mimeType = new MimeType(string);
            this.reply.setContentType(mimeType);
            this.setContentTypeException = null;
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            this.setContentTypeException = mimeTypeFormatException;
        }
    }

    public void setDateHeader(String string, long l) {
        this.setHeader(string, HttpFactory.makeDate(l).toExternalForm());
    }

    public void setHeader(String string, String string2) {
        this.reply.setValue(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, String.valueOf(n));
    }

    public void setLocale(Locale locale) {
        String[] stringArray;
        if (locale == null) {
            return;
        }
        this.locale = locale;
        String string = locale.getLanguage();
        if (string.length() > 0) {
            stringArray = new String[]{string};
            this.reply.setContentLanguage(stringArray);
        }
        if ((stringArray = Utils.getCharset(locale)) != null) {
            MimeType mimeType = this.reply.getContentType();
            mimeType.setParameter(CHARSET_PARAMETER, (String)stringArray);
        }
    }

    protected void setServletRequest(JigsawHttpServletRequest jigsawHttpServletRequest) {
        this.jrequest = jigsawHttpServletRequest;
    }

    public void setStatus(int n) {
        this.setStatus(n, this.reply.getStandardReason(n));
    }

    public void setStatus(int n, String string) {
        this.reply.setStatus(n);
        this.reply.setReason(string);
    }

    public void unsetHeader(String string) {
        this.setHeader(string, null);
    }
}

