/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.pics.LabelBureauFactory;
import org.w3c.jigsaw.pics.LabelBureauInterface;
import org.w3c.jigsaw.pics.LabelInterface;
import org.w3c.jigsaw.pics.LabelServiceInterface;
import org.w3c.jigsaw.pics.PICS;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.www.http.HttpBag;

public class PICSFilter
extends ResourceFilter {
    protected static int ATTR_BUREAU_IDENTIFIER = -1;
    protected LabelBureauInterface bureau = null;

    static {
        FileAttribute fileAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.pics.PICSFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        fileAttribute = new FileAttribute("bureau", null, 6);
        ATTR_BUREAU_IDENTIFIER = AttributeRegistry.registerAttribute(clazz, fileAttribute);
    }

    protected final void acquireBureau() {
        if (this.bureau != null) {
            return;
        }
        File file = this.getBureauIdentifier();
        if (file == null) {
            return;
        }
        this.bureau = LabelBureauFactory.getLabelBureau(file);
    }

    public File getBureauIdentifier() {
        return (File)this.getValue(ATTR_BUREAU_IDENTIFIER, null);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.acquireBureau();
    }

    protected HttpBag isPICSQuery(Request request) throws HTTPException {
        HttpBag httpBag = request.getProtocolRequest();
        if (httpBag == null) {
            return null;
        }
        if (!httpBag.hasBag("PICS-1.1")) {
            return null;
        }
        HttpBag httpBag2 = null;
        try {
            httpBag2 = httpBag.getBag("PICS-1.1");
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return httpBag2;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws HTTPException {
        Request request = (Request)requestInterface;
        Reply reply = (Reply)replyInterface;
        HttpBag httpBag = this.isPICSQuery(request);
        if (httpBag == null) {
            return reply;
        }
        HttpBag httpBag2 = httpBag.getBag("params");
        HttpBag httpBag3 = httpBag2.getBag("services");
        URL uRL = request.getURL();
        int n = 1;
        if (httpBag2.hasItem("minimal")) {
            n = 1;
        } else if (httpBag2.hasItem("short")) {
            n = 2;
        } else if (httpBag2.hasItem("full")) {
            n = 3;
        } else if (httpBag2.hasItem("signed")) {
            n = 4;
        } else {
            Reply reply2 = request.makeReply(400);
            reply2.setContent("Invalid label format: " + n);
            throw new HTTPException(reply2);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        Enumeration enumeration = httpBag3.keys();
        stringBuffer.append("(PICS-1.1");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LabelServiceInterface labelServiceInterface = this.bureau.getLabelService(string);
            if (labelServiceInterface == null) {
                stringBuffer.append(" error (service-unavailable \"unknown service\")");
                continue;
            }
            labelServiceInterface.dump(stringBuffer, n);
            LabelInterface labelInterface = labelServiceInterface.getSpecificLabel(uRL);
            if (labelInterface == null && (labelInterface = labelServiceInterface.getGenericLabel(uRL)) == null) {
                stringBuffer.append(" error (not-labeled \"" + uRL + "\")");
                continue;
            }
            stringBuffer.append(" labels ");
            labelInterface.dump(stringBuffer, n);
        }
        stringBuffer.append(")");
        reply.setProtocol(PICS.PICS_EXTENSION);
        reply.setValue("PICS-label", stringBuffer.toString());
        return reply;
    }
}

