/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.indexer;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.indexer.ContentTypesIndexerEnumeration;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.indexer.SampleResourceIndexer;
import org.w3c.tools.resources.indexer.TemplateContainer;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class ContentTypeIndexer
extends SampleResourceIndexer {
    private static final boolean debug = false;
    protected ResourceReference contentTypes = null;

    protected Resource createFileResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        ResourceReference resourceReference = null;
        FramedResource framedResource = null;
        if (requestInterface instanceof Request) {
            Request request = (Request)requestInterface;
            MimeType mimeType = request.getContentType();
            if (mimeType != null) {
                resourceReference = this.loadContentType(mimeType.toString());
            }
            if (resourceReference != null) {
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Object>(5);
                }
                if (hashtable.get("directory") == null) {
                    hashtable.put("directory", file);
                }
                if (hashtable.get("identifier") == null) {
                    hashtable.put("identifier", string);
                }
                if (hashtable.get("context") == null) {
                    hashtable.put("context", this.getContext());
                }
                try {
                    try {
                        framedResource = (FramedResource)resourceReference.lock();
                        try {
                            FramedResource framedResource2 = null;
                            framedResource2 = (FramedResource)framedResource.getClone(hashtable);
                            String[] stringArray = request.getContentLanguage();
                            String[] stringArray2 = request.getContentEncoding();
                            Class<?> clazz = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
                            HTTPFrame hTTPFrame = (HTTPFrame)framedResource2.getFrame(clazz);
                            if (hTTPFrame != null) {
                                if (stringArray != null && stringArray.length > 0) {
                                    hTTPFrame.setValue("content-language", (Object)stringArray[0]);
                                }
                                if (stringArray2 != null && stringArray2.length > 0) {
                                    hTTPFrame.setValue("content-encoding", (Object)stringArray2[0]);
                                }
                            }
                            FramedResource framedResource3 = framedResource2;
                            Object var11_17 = null;
                            resourceReference.unlock();
                            return framedResource3;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        invalidResourceException.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
                Object var11_18 = null;
                resourceReference.unlock();
            }
        }
        return super.createFileResource(file, requestInterface, string, hashtable);
    }

    public synchronized void delete() throws MultipleLockException {
        DummyResourceReference dummyResourceReference = (DummyResourceReference)this.getContentTypes();
        try {
            try {
                Resource resource = dummyResourceReference.lock();
                resource.delete();
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            Object var3_3 = null;
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
            throw throwable;
        }
        super.delete();
    }

    public Enumeration enumerateResourceIdentifiers(boolean bl) {
        return new ContentTypesIndexerEnumeration();
    }

    protected synchronized ResourceReference getContentTypes() {
        if (this.contentTypes == null) {
            String string = String.valueOf(this.getIdentifier()) + "-c";
            this.contentTypes = new DummyResourceReference(new TemplateContainer(new ResourceContext(this.getContext()), String.valueOf(string) + ".db"));
        }
        return this.contentTypes;
    }

    public synchronized ResourceReference loadContentType(String string) {
        MimeType mimeType = null;
        try {
            mimeType = new MimeType(string);
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            return null;
        }
        ResourceReference resourceReference = this.getContentTypes();
        try {
            try {
                TemplateContainer templateContainer = (TemplateContainer)resourceReference.lock();
                Enumeration enumeration = templateContainer.enumerateResourceIdentifiers(true);
                String string2 = "*:*";
                int n = -1;
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    MimeType mimeType2 = null;
                    try {
                        mimeType2 = new MimeType(string3.replace(':', '/'));
                    }
                    catch (MimeTypeFormatException mimeTypeFormatException) {
                        continue;
                    }
                    int n2 = mimeType.match(mimeType2);
                    if (n2 <= n) continue;
                    n = n2;
                    string2 = string3;
                    if (n == 4) break;
                }
                ResourceReference resourceReference2 = templateContainer.lookup(string2);
                Object var6_15 = null;
                resourceReference.unlock();
                return resourceReference2;
            }
            catch (InvalidResourceException invalidResourceException) {
                String string4 = "[resource indexer]: content-types \"" + string + "\" couldn't be restored (" + invalidResourceException.getMessage() + ")";
                this.getContext().getServer().errlog(string4);
                ResourceReference resourceReference3 = null;
                Object var6_16 = null;
                resourceReference.unlock();
                return resourceReference3;
            }
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    public ResourceReference lookup(String string) {
        if (string.equals("directories")) {
            return this.getDirectories();
        }
        if (string.equals("extensions")) {
            return this.getExtensions();
        }
        if (string.equals("content-types")) {
            return this.getContentTypes();
        }
        return null;
    }
}

